/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VertexInfo;
import jpcsp.util.CacheStatistics;

public class VertexCache {
    public static final int cacheMaxSize = 30000;
    public static final float cacheLoadFactor = 0.75f;
    protected static VertexCache instance = null;
    private LinkedHashMap<Integer, VertexInfo> cache;
    protected CacheStatistics statistics = new CacheStatistics("Vertex", 30000);
    private Set<Integer> vertexAlreadyChecked;

    public static VertexCache getInstance() {
        if (instance == null) {
            instance = new VertexCache();
        }
        return instance;
    }

    protected VertexCache() {
        this.cache = new LinkedHashMap(40001, 0.75f, true);
        this.vertexAlreadyChecked = new HashSet<Integer>();
    }

    public void exit() {
    }

    private static Integer getKey(VertexInfo vertexInfo) {
        return new Integer(vertexInfo.ptr_vertex + vertexInfo.ptr_index);
    }

    public boolean hasVertex(VertexInfo vertexInfo) {
        return this.cache.containsKey(VertexCache.getKey(vertexInfo));
    }

    protected synchronized VertexInfo getVertex(VertexInfo vertexInfo) {
        return this.cache.get(VertexCache.getKey(vertexInfo));
    }

    public synchronized void addVertex(IRenderingEngine re, VertexInfo vertexInfo, int numberOfVertex, float[][] boneMatrix, int numberOfWeightsForShader) {
        Iterator<Map.Entry<Integer, VertexInfo>> it;
        Integer key = VertexCache.getKey(vertexInfo);
        VertexInfo previousVertex = this.cache.get(key);
        if (previousVertex != null) {
            vertexInfo.reuseCachedBuffer(previousVertex);
            previousVertex.deleteVertex(re);
        } else if (this.cache.size() >= 30000 && (it = this.cache.entrySet().iterator()).hasNext()) {
            Map.Entry<Integer, VertexInfo> entry = it.next();
            entry.getValue().deleteVertex(re);
            it.remove();
            ++this.statistics.entriesRemoved;
        }
        vertexInfo.prepareForCache(this, numberOfVertex, boneMatrix, numberOfWeightsForShader);
        this.cache.put(key, vertexInfo);
        if ((long)this.cache.size() > this.statistics.maxSizeUsed) {
            this.statistics.maxSizeUsed = this.cache.size();
        }
    }

    public VertexInfo getVertex(VertexInfo vertexInfo, int numberOfVertex, float[][] boneMatrix, int numberOfWeightsForShader) {
        ++this.statistics.totalHits;
        VertexInfo vertex = this.getVertex(vertexInfo);
        if (vertex == null) {
            ++this.statistics.notPresentHits;
            return vertex;
        }
        if (vertex.equals(vertexInfo, numberOfVertex, boneMatrix, numberOfWeightsForShader)) {
            ++this.statistics.successfulHits;
            return vertex;
        }
        ++this.statistics.changedHits;
        return null;
    }

    public void resetVertexAlreadyChecked() {
        this.vertexAlreadyChecked.clear();
    }

    public boolean vertexAlreadyChecked(VertexInfo vertexInfo) {
        return this.vertexAlreadyChecked.contains(VertexCache.getKey(vertexInfo));
    }

    public void setVertexAlreadyChecked(VertexInfo vertexInfo) {
        this.vertexAlreadyChecked.add(VertexCache.getKey(vertexInfo));
    }

    public synchronized void reset(IRenderingEngine re) {
        for (VertexInfo vertexInfo : this.cache.values()) {
            vertexInfo.deleteVertex(re);
        }
        this.cache.clear();
    }
}

