/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.hardware;

public class GPS {
    private static float positionLatitude = 40.713387f;
    private static float positionLongitude = -74.005516f;
    private static float positionAltitude = 39.0f;

    public static float getPositionLatitude() {
        return positionLatitude;
    }

    public static void setPositionLatitude(float positionLatitude) {
        GPS.positionLatitude = positionLatitude;
    }

    public static float getPositionLongitude() {
        return positionLongitude;
    }

    public static void setPositionLongitude(float positionLongitude) {
        GPS.positionLongitude = positionLongitude;
    }

    public static float getPositionAltitude() {
        return positionAltitude;
    }

    public static void setPositionAltitude(float positionAltitude) {
        GPS.positionAltitude = positionAltitude;
    }

    public static void initialize() {
        FakeGPSMove.initialize();
    }

    private static class FakeGPSMove
    extends Thread {
        private static FakeGPSMove instance;
        private long sleepMillis;
        private float latitudeDelta;
        private float longitudeDelta;
        private float altitudeDelta;

        private static void initialize() {
            if (instance == null) {
                instance = new FakeGPSMove(2000L, 1.0E-5f, 1.0E-5f, 0.0f);
                instance.setDaemon(true);
                instance.setName("Fake GPS Move");
                instance.start();
            }
        }

        public FakeGPSMove(long sleepMillis, float latitudeDelta, float longitudeDelta, float altitudeDelta) {
            this.sleepMillis = sleepMillis;
            this.latitudeDelta = latitudeDelta;
            this.longitudeDelta = longitudeDelta;
            this.altitudeDelta = altitudeDelta;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    FakeGPSMove.sleep(this.sleepMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.latitudeDelta != 0.0f) {
                    GPS.setPositionLatitude(GPS.getPositionLatitude() + this.latitudeDelta);
                }
                if (this.longitudeDelta != 0.0f) {
                    GPS.setPositionLongitude(GPS.getPositionLongitude() + this.longitudeDelta);
                }
                if (this.altitudeDelta == 0.0f) continue;
                GPS.setPositionAltitude(GPS.getPositionAltitude() + this.altitudeDelta);
            }
        }
    }
}

