/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jpcsp.HLE.Modules;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.memory.NativeMemoryUtils;

public class SparseNativeMemory
extends Memory {
    private long[] memory;
    private int memorySize;
    private int pageShift = 26;
    private int pageSize = 1 << this.pageShift;
    private int pageMask = this.pageSize - 1;

    @Override
    public boolean allocate() {
        NativeMemoryUtils.init();
        this.memorySize = MemoryMap.END_RAM + 1;
        this.memory = new long[Math.max(this.memorySize + this.pageSize - 1 >> this.pageShift, 1)];
        for (int i = 0; i < this.memory.length; ++i) {
            this.memory[i] = NativeMemoryUtils.alloc(this.pageSize);
            if (this.memory[i] != 0L) continue;
            for (int j = 0; j < i; ++j) {
                NativeMemoryUtils.free(this.memory[j]);
            }
            return false;
        }
        log.info((Object)String.format("Using SparseNativeMemory(littleEndian=%b)", NativeMemoryUtils.isLittleEndian()));
        return super.allocate();
    }

    @Override
    public void Initialise() {
        for (int i = 0; i < this.memory.length; ++i) {
            NativeMemoryUtils.memset(this.memory[i], 0, 0, this.pageSize);
        }
    }

    @Override
    public int read8(int address) {
        return NativeMemoryUtils.read8(this.memory[(address &= 0x3FFFFFFF) >> this.pageShift], address & this.pageMask);
    }

    @Override
    public int read16(int address) {
        return NativeMemoryUtils.read16(this.memory[(address &= 0x3FFFFFFF) >> this.pageShift], address & this.pageMask);
    }

    @Override
    public int read32(int address) {
        return NativeMemoryUtils.read32(this.memory[(address &= 0x3FFFFFFF) >> this.pageShift], address & this.pageMask);
    }

    @Override
    public void write8(int address, byte data) {
        NativeMemoryUtils.write8(this.memory[(address &= 0x3FFFFFFF) >> this.pageShift], address & this.pageMask, data);
        Modules.sceDisplayModule.write8(address);
    }

    @Override
    public void write16(int address, short data) {
        NativeMemoryUtils.write16(this.memory[(address &= 0x3FFFFFFF) >> this.pageShift], address & this.pageMask, data);
        Modules.sceDisplayModule.write16(address);
    }

    @Override
    public void write32(int address, int data) {
        NativeMemoryUtils.write32(this.memory[(address &= 0x3FFFFFFF) >> this.pageShift], address & this.pageMask, data);
        Modules.sceDisplayModule.write32(address);
    }

    @Override
    public void memset(int address, byte data, int length) {
        address &= 0x3FFFFFFF;
        while (length > 0) {
            int pageLength = Math.min(this.pageSize - (address & this.pageMask), length);
            NativeMemoryUtils.memset(this.memory[address >> this.pageShift], address & this.pageMask, data, pageLength);
            length -= pageLength;
            address += pageLength;
        }
    }

    @Override
    public Buffer getMainMemoryByteBuffer() {
        return null;
    }

    @Override
    public Buffer getBuffer(int address, int length) {
        ByteBuffer buffer = NativeMemoryUtils.getBuffer(this.memory[(address &= 0x3FFFFFFF) >> this.pageShift], address & this.pageMask, length);
        if (NativeMemoryUtils.isLittleEndian()) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            buffer.order(ByteOrder.BIG_ENDIAN);
        }
        return buffer;
    }

    @Override
    public void copyToMemory(int address, ByteBuffer source, int length) {
        address &= 0x3FFFFFFF;
        if (source.isDirect()) {
            NativeMemoryUtils.copyBufferToMemory(this.memory[address >> this.pageShift], address & this.pageMask, source, source.position(), length);
        } else {
            for (length = Math.min(length, source.capacity()); length > 0; --length) {
                NativeMemoryUtils.write8(this.memory[address >> this.pageShift], address & this.pageMask, source.get());
                ++address;
            }
        }
    }

    @Override
    protected void memcpy(int destination, int source, int length, boolean checkOverlap) {
        if (length <= 0) {
            return;
        }
        Modules.sceDisplayModule.write8(destination &= 0x3FFFFFFF);
        if (!checkOverlap || (source &= 0x3FFFFFFF) >= destination || !this.areOverlapping(destination, source, length)) {
            while (length > 0) {
                int pageLengthDestination = Math.min(this.pageSize - (destination & this.pageMask), length);
                int pageLengthSource = Math.min(this.pageSize - (source & this.pageMask), length);
                int pageLength = Math.min(pageLengthDestination, pageLengthSource);
                NativeMemoryUtils.memcpy(this.memory[destination >> this.pageShift], destination & this.pageMask, this.memory[source >> this.pageShift], source & this.pageMask, pageLength);
                length -= pageLength;
                destination += pageLength;
                source += pageLength;
            }
        } else {
            for (int i = length - 1; i >= 0; --i) {
                int b = this.read8(source + i);
                this.write8(destination + i, (byte)b);
            }
        }
    }
}

