/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import jpcsp.HLE.Modules;
import jpcsp.HLE.VFS.ByteArrayVirtualFile;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.PartialVirtualFile;
import jpcsp.HLE.VFS.iso.UmdIsoVirtualFile;
import jpcsp.HLE.modules150.IoFileMgrForUser;
import jpcsp.Memory;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.filesystems.umdiso.UmdIsoFile;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.util.Hash;
import org.apache.log4j.Logger;

public class FileLocator {
    private static Logger log = Logger.getLogger((String)"fileLocator");
    private static FileLocator instance;
    private static boolean scanAllFileMagicOffsets;
    private IoListener ioListener = new IoListener();

    public static FileLocator getInstance() {
        if (instance == null) {
            instance = new FileLocator();
        }
        return instance;
    }

    private FileLocator() {
        Modules.IoFileMgrForUserModule.registerIoListener(this.ioListener);
    }

    public void setFileData(SeekableDataInput dataInput, IVirtualFile vFile, int address, long startPosition, int length) {
        this.ioListener.setFileData(dataInput, vFile, address, startPosition, length);
    }

    public IVirtualFile getVirtualFile(int address, int length, int fileSize, byte[] checkData) {
        return this.ioListener.getVirtualFile(address, length, fileSize, checkData);
    }

    static {
        scanAllFileMagicOffsets = true;
    }

    private static class IoListener
    implements IoFileMgrForUser.IIoListener {
        private HashMap<Integer, ReadInfo> readInfos = new HashMap();
        private HashMap<Integer, ReadInfo> readMagics = new HashMap();
        private static final int MAGIC_HASH_LENGTH = 512;
        private static final int[] fileMagics = new int[]{1179011410, 1179472720};

        private static boolean memcmp(byte[] data, int address, int length) {
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, length, 1);
            for (int i = 0; i < length; ++i) {
                if (memoryReader.readNext() == (data[i] & 0xFF)) continue;
                return false;
            }
            return true;
        }

        private static boolean cmp(byte[] data, byte[] checkData, int length) {
            length = Math.min(length, checkData.length);
            for (int i = 0; i < length; ++i) {
                if (data[i] == checkData[i]) continue;
                return false;
            }
            return true;
        }

        private static int getMagicHash(int address) {
            return Hash.getHashCodeFloatingMemory(0, address, 512);
        }

        private static int getMagicHash(byte[] data) {
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(data, 0, 512, 4);
            return Hash.getHashCodeFloatingMemory(0, memoryReader, 512);
        }

        private byte[] readData(ReadInfo readInfo, int positionOffset, int length) {
            byte[] fileData;
            block6: {
                try {
                    fileData = new byte[length];
                    if (readInfo.vFile != null) {
                        long currentPosition = readInfo.vFile.getPosition();
                        if (currentPosition < 0L) {
                            return null;
                        }
                        readInfo.vFile.ioLseek(readInfo.position + (long)positionOffset);
                        readInfo.vFile.ioRead(fileData, 0, fileData.length);
                        readInfo.vFile.ioLseek(currentPosition);
                        break block6;
                    }
                    if (readInfo.dataInput != null) {
                        long currentPosition = readInfo.dataInput.getFilePointer();
                        if (currentPosition < 0L) {
                            return null;
                        }
                        readInfo.dataInput.seek(readInfo.position + (long)positionOffset);
                        readInfo.dataInput.readFully(fileData);
                        readInfo.dataInput.seek(currentPosition);
                        break block6;
                    }
                    return null;
                }
                catch (IOException e) {
                    return null;
                }
            }
            return fileData;
        }

        public IVirtualFile getVirtualFile(int address, int length, int fileSize, byte[] checkData) {
            int checkLength;
            byte[] fileData;
            int positionOffset = 0;
            ReadInfo readInfo = this.readInfos.get(address);
            if (readInfo == null) {
                long currentPosition;
                byte[] fileData2;
                for (ReadInfo ri : this.readInfos.values()) {
                    try {
                        if (ri.vFile != null && ri.vFile.length() == (long)fileSize) {
                            fileData2 = new byte[length];
                            currentPosition = ri.vFile.getPosition();
                            ri.vFile.ioLseek(ri.position);
                            ri.vFile.ioRead(fileData2, 0, length);
                            ri.vFile.ioLseek(currentPosition);
                            if (!IoListener.memcmp(fileData2, address, length)) continue;
                            readInfo = ri;
                            break;
                        }
                        if (ri.dataInput != null && ri.dataInput.length() == (long)fileSize) {
                            fileData2 = new byte[length];
                            currentPosition = ri.dataInput.getFilePointer();
                            ri.dataInput.seek(ri.position);
                            ri.dataInput.readFully(fileData2);
                            ri.dataInput.seek(currentPosition);
                            if (!IoListener.memcmp(fileData2, address, length)) continue;
                            readInfo = ri;
                            break;
                        }
                        if (ri.address >= address || ri.address + ri.size < address + length) continue;
                        positionOffset = address - ri.address;
                        readInfo = ri;
                        break;
                    }
                    catch (IOException e) {
                    }
                }
                if (readInfo == null) {
                    ReadInfo ri = this.readMagics.get(IoListener.getMagicHash(address));
                    if (ri == null && checkData != null && checkData.length >= 512) {
                        ri = this.readMagics.get(IoListener.getMagicHash(checkData));
                    }
                    if (ri != null) {
                        try {
                            if (ri.vFile != null && ri.vFile.length() >= (long)fileSize) {
                                int checkLength2 = Math.min(length, fileSize);
                                fileData2 = new byte[checkLength2];
                                currentPosition = ri.vFile.getPosition();
                                ri.vFile.ioLseek(ri.position);
                                ri.vFile.ioRead(fileData2, 0, checkLength2);
                                ri.vFile.ioLseek(currentPosition);
                                boolean match = checkData != null ? IoListener.cmp(fileData2, checkData, checkLength2) : IoListener.memcmp(fileData2, address, checkLength2);
                                if (match) {
                                    readInfo = ri;
                                }
                            } else if (ri.dataInput != null && ri.dataInput.length() >= (long)fileSize) {
                                int checkLength3 = Math.min(length, fileSize);
                                fileData2 = new byte[checkLength3];
                                currentPosition = ri.dataInput.getFilePointer();
                                ri.dataInput.seek(ri.position);
                                ri.dataInput.readFully(fileData2);
                                ri.dataInput.seek(currentPosition);
                                boolean match = checkData != null ? IoListener.cmp(fileData2, checkData, checkLength3) : IoListener.memcmp(fileData2, address, checkLength3);
                                if (match) {
                                    readInfo = ri;
                                }
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    if (readInfo == null) {
                        return null;
                    }
                }
            }
            if ((fileData = this.readData(readInfo, positionOffset, checkLength = Math.min(length, 512))) == null) {
                return null;
            }
            boolean match = checkData != null ? IoListener.cmp(fileData, checkData, checkLength) : IoListener.memcmp(fileData, address, checkLength);
            if (!match) {
                return null;
            }
            if (readInfo.vFile != null) {
                IVirtualFile vFile = readInfo.vFile.duplicate();
                if (vFile == null) {
                    vFile = readInfo.vFile;
                } else {
                    vFile.ioLseek(readInfo.position);
                }
                if ((long)fileSize > vFile.length() && vFile instanceof UmdIsoVirtualFile) {
                    UmdIsoVirtualFile umdIsoVirtualFile = (UmdIsoVirtualFile)vFile;
                    umdIsoVirtualFile.setLength(fileSize);
                }
                if (readInfo.position + (long)positionOffset != 0L || vFile.length() != (long)fileSize) {
                    vFile = new PartialVirtualFile(vFile, readInfo.position + (long)positionOffset, fileSize);
                }
                return vFile;
            }
            if (readInfo.dataInput != null && readInfo.dataInput instanceof UmdIsoFile) {
                UmdIsoFile umdIsoFile = (UmdIsoFile)readInfo.dataInput;
                try {
                    UmdIsoFile duplicate = umdIsoFile.duplicate();
                    if (duplicate != null) {
                        duplicate.seek(readInfo.position);
                        umdIsoFile = duplicate;
                    }
                }
                catch (IOException e) {
                    log.warn((Object)"Cannot duplicate UmdIsoFile", (Throwable)e);
                }
                if ((long)fileSize > umdIsoFile.length()) {
                    umdIsoFile.setLength(fileSize);
                }
                IVirtualFile vFile = new UmdIsoVirtualFile(umdIsoFile);
                if (readInfo.position + (long)positionOffset != 0L || vFile.length() != (long)fileSize) {
                    vFile = new PartialVirtualFile(vFile, readInfo.position + (long)positionOffset, fileSize);
                }
                return vFile;
            }
            try {
                fileData = this.readData(readInfo, positionOffset, fileSize);
            }
            catch (OutOfMemoryError e) {
                log.error((Object)String.format("Error '%s' while decoding external audio file (fileSize=%d, position=%d, dataInput=%s)", e.toString(), fileSize, readInfo.position + (long)positionOffset, readInfo.dataInput.toString()));
                return null;
            }
            if (fileData == null) {
                return null;
            }
            return new ByteArrayVirtualFile(fileData, 0, fileData.length);
        }

        public void setFileData(SeekableDataInput dataInput, IVirtualFile vFile, int address, long startPosition, int length) {
            ReadInfo ri = new ReadInfo(address, length, dataInput, vFile, startPosition);
            this.readInfos.put(address, ri);
        }

        private static boolean isFileMagicValue(int magicValue) {
            for (int i = 0; i < fileMagics.length; ++i) {
                if (magicValue != fileMagics[i]) continue;
                return true;
            }
            return false;
        }

        private static int getFirstFileMagicOffset(int address, int size) {
            if (Memory.isAddressGood(address)) {
                IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, size, 4);
                int stepSize = 2048;
                int skip = 511;
                for (int i = 0; i < size; i += 2048) {
                    int magicValue = memoryReader.readNext();
                    if (IoListener.isFileMagicValue(magicValue)) {
                        return i;
                    }
                    memoryReader.skip(511);
                }
            }
            return -1;
        }

        private static int[] getAllFileMagicOffsets(int address, int size) {
            if (!Memory.isAddressGood(address)) {
                return null;
            }
            Vector<Integer> magicOffsets = new Vector<Integer>();
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, size, 4);
            int stepSize = 16;
            int skip = 3;
            int endSize = size / 16 * 16;
            for (int i = 0; i < endSize; i += 16) {
                int magicValue = memoryReader.readNext();
                if (IoListener.isFileMagicValue(magicValue)) {
                    magicOffsets.add(i);
                }
                memoryReader.skip(3);
            }
            if (magicOffsets.size() <= 0) {
                return null;
            }
            int[] fileMagicOffsets = new int[magicOffsets.size()];
            for (int i = 0; i < fileMagicOffsets.length; ++i) {
                fileMagicOffsets[i] = (Integer)magicOffsets.get(i);
            }
            return fileMagicOffsets;
        }

        @Override
        public void sceIoRead(int result, int uid, int data_addr, int size, int bytesRead, long position, SeekableDataInput dataInput, IVirtualFile vFile) {
            if (result >= 0 && (dataInput != null || vFile != null)) {
                ReadInfo readInfo = this.readInfos.get(data_addr);
                boolean processed = false;
                if (scanAllFileMagicOffsets) {
                    int[] magicOffsets = IoListener.getAllFileMagicOffsets(data_addr, bytesRead);
                    if (magicOffsets != null && magicOffsets.length > 0) {
                        for (int i = 0; i < magicOffsets.length; ++i) {
                            int magicOffset = magicOffsets[i];
                            int nextMagicOffset = i + 1 < magicOffsets.length ? magicOffsets[i + 1] : bytesRead;
                            int magicAddress = data_addr + magicOffset;
                            readInfo = new ReadInfo(magicAddress, nextMagicOffset - magicOffset, dataInput, vFile, position + (long)magicOffset);
                            this.readInfos.put(magicAddress, readInfo);
                            this.readMagics.put(IoListener.getMagicHash(magicAddress), readInfo);
                        }
                        processed = true;
                    }
                } else {
                    int magicOffset = IoListener.getFirstFileMagicOffset(data_addr, bytesRead);
                    if (magicOffset >= 0) {
                        int magicAddress = data_addr + magicOffset;
                        readInfo = new ReadInfo(magicAddress, bytesRead - magicOffset, dataInput, vFile, position + (long)magicOffset);
                        this.readInfos.put(magicAddress, readInfo);
                        this.readMagics.put(IoListener.getMagicHash(magicAddress), readInfo);
                        processed = true;
                    }
                }
                if (!processed && readInfo == null) {
                    readInfo = new ReadInfo(data_addr, bytesRead, dataInput, vFile, position);
                    this.readInfos.put(data_addr, readInfo);
                }
            }
        }

        @Override
        public void sceIoAssign(int result, int dev1_addr, String dev1, int dev2_addr, String dev2, int dev3_addr, String dev3, int mode, int unk1, int unk2) {
        }

        @Override
        public void sceIoCancel(int result, int uid) {
        }

        @Override
        public void sceIoChdir(int result, int path_addr, String path) {
        }

        @Override
        public void sceIoChstat(int result, int path_addr, String path, int stat_addr, int bits) {
        }

        @Override
        public void sceIoClose(int result, int uid) {
        }

        @Override
        public void sceIoDclose(int result, int uid) {
        }

        @Override
        public void sceIoDevctl(int result, int device_addr, String device, int cmd, int indata_addr, int inlen, int outdata_addr, int outlen) {
        }

        @Override
        public void sceIoDopen(int result, int path_addr, String path) {
        }

        @Override
        public void sceIoDread(int result, int uid, int dirent_addr) {
        }

        @Override
        public void sceIoGetStat(int result, int path_addr, String path, int stat_addr) {
        }

        @Override
        public void sceIoIoctl(int result, int uid, int cmd, int indata_addr, int inlen, int outdata_addr, int outlen) {
        }

        @Override
        public void sceIoMkdir(int result, int path_addr, String path, int permissions) {
        }

        @Override
        public void sceIoOpen(int result, int filename_addr, String filename, int flags, int permissions, String mode) {
        }

        @Override
        public void sceIoPollAsync(int result, int uid, int res_addr) {
        }

        @Override
        public void sceIoRemove(int result, int path_addr, String path) {
        }

        @Override
        public void sceIoRename(int result, int path_addr, String path, int new_path_addr, String newpath) {
        }

        @Override
        public void sceIoRmdir(int result, int path_addr, String path) {
        }

        @Override
        public void sceIoSeek32(int result, int uid, int offset, int whence) {
        }

        @Override
        public void sceIoSeek64(long result, int uid, long offset, int whence) {
        }

        @Override
        public void sceIoSync(int result, int device_addr, String device, int unknown) {
        }

        @Override
        public void sceIoWaitAsync(int result, int uid, int res_addr) {
        }

        @Override
        public void sceIoWrite(int result, int uid, int data_addr, int size, int bytesWritten) {
        }

        private static class ReadInfo {
            public int address;
            public int size;
            public SeekableDataInput dataInput;
            public IVirtualFile vFile;
            public long position;

            public ReadInfo(int address, int size, SeekableDataInput dataInput, IVirtualFile vFile, long position) {
                this.address = address;
                this.size = size;
                this.dataInput = dataInput;
                this.vFile = vFile;
                this.position = position;
            }

            public String toString() {
                return String.format("ReadInfo(0x%08X-0x%08X(size=0x%X), position=%d, %s)", this.address, this.address + this.size, this.size, this.position, this.dataInput.toString());
            }
        }
    }
}

