/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.Category;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryRange<T>
extends AbstractRange<T>
implements Iterable<Category<T>> {
    private static final String PROPERTY_VALUES = "values";
    private List<T> _possibleValues = null;
    private List<Category<T>> _categoryValues = null;

    public CategoryRange() {
        this._possibleValues = new ArrayList<T>();
        this._categoryValues = new ArrayList<Category<T>>();
    }

    public CategoryRange(T ... TArray) {
        this._possibleValues = new ArrayList<T>();
        this._possibleValues.addAll(Arrays.asList(TArray));
    }

    public CategoryRange(Set<T> set) {
        this._possibleValues = new ArrayList<T>(set);
    }

    public List<T> getPossibleValues() {
        return this._possibleValues;
    }

    public CategoryRange<T> add(Category<T> category) {
        this._possibleValues.add(category.getValue());
        this._categoryValues.add(category);
        category.setRange(this);
        this.firePropertyChange(PROPERTY_VALUES, null, this._possibleValues);
        return this;
    }

    @Override
    public T lower() {
        if (this._possibleValues == null || this._possibleValues.size() == 0) {
            return null;
        }
        return this._possibleValues.get(0);
    }

    @Override
    public T upper() {
        if (this._possibleValues == null || this._possibleValues.size() == 0) {
            return null;
        }
        int n = this._possibleValues.size();
        return this._possibleValues.get(n - 1);
    }

    @Override
    public void adjust(T t, T t2) {
    }

    @Override
    public double maximum() {
        return this.position(this.upper()) + 1;
    }

    @Override
    public double minimum() {
        return this.position(this.lower()) - 1;
    }

    @Override
    public double size() {
        if (this._possibleValues == null) {
            return 0.0;
        }
        int n = this._possibleValues.size();
        if (n == 0) {
            return 0.0;
        }
        return n + 1;
    }

    public int position(T t) {
        int n = this._possibleValues.indexOf(t);
        if (n < 0) {
            throw new IllegalArgumentException("Value " + t + " not known");
        }
        return 1 + n;
    }

    @Override
    public boolean contains(T t) {
        if (t == null) {
            return false;
        }
        for (T t2 : this._possibleValues) {
            if (!t.equals(t2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Category<T> category) {
        if (category == null) {
            return false;
        }
        for (Category<T> category2 : this.getCategoryValues()) {
            if (!category.equals(category2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Category<T>> iterator() {
        return this.getCategoryValues().iterator();
    }

    public List<Category<T>> getCategoryValues() {
        if (this._categoryValues == null) {
            this._categoryValues = new ArrayList<Category<T>>();
            for (T t : this._possibleValues) {
                this._categoryValues.add(new Category<T>(t, this));
            }
        }
        return this._categoryValues;
    }
}

