/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Debugger.MemoryBreakpoints;

import jpcsp.Memory;
import jpcsp.memory.DebuggerMemory;

public class MemoryBreakpoint {
    private int start_address;
    private int end_address;
    private AccessType access;
    private boolean installed;

    public MemoryBreakpoint() {
        this.start_address = 0;
        this.end_address = 0;
        this.access = AccessType.READ;
        this.installed = false;
    }

    public MemoryBreakpoint(DebuggerMemory debuggerMemory, int start_address, int end_address, AccessType access) {
        this.setStartAddress(start_address);
        this.setEndAddress(end_address);
        this.access = access;
        this.install(debuggerMemory);
    }

    public MemoryBreakpoint(DebuggerMemory debuggerMemory, int address, AccessType access) {
        this.setStartAddress(address);
        this.setEndAddress(address);
        this.access = access;
        this.install(debuggerMemory);
    }

    public final int getStartAddress() {
        return this.start_address;
    }

    public final void setStartAddress(int start_address) {
        this.start_address = Memory.normalizeAddress(start_address);
    }

    public final int getEndAddress() {
        return this.end_address;
    }

    public final void setEndAddress(int end_address) {
        this.end_address = Memory.normalizeAddress(end_address);
    }

    private static DebuggerMemory getDebuggerMemory() {
        Memory mem = Memory.getInstance();
        if (mem instanceof DebuggerMemory) {
            return (DebuggerMemory)mem;
        }
        return null;
    }

    public final void setEnabled(boolean enabled) {
        if (this.installed & !enabled) {
            this.uninstall(MemoryBreakpoint.getDebuggerMemory());
        } else if (!this.installed & enabled) {
            this.install(MemoryBreakpoint.getDebuggerMemory());
        }
    }

    public final boolean isEnabled() {
        return this.installed;
    }

    public AccessType getAccess() {
        return this.access;
    }

    public void setAccess(AccessType access) {
        this.access = access;
    }

    private void install(DebuggerMemory debuggerMemory) {
        if (debuggerMemory != null) {
            switch (this.access) {
                case READ: {
                    debuggerMemory.addRangeReadBreakpoint(this.start_address, this.end_address);
                    break;
                }
                case WRITE: {
                    debuggerMemory.addRangeWriteBreakpoint(this.start_address, this.end_address);
                    break;
                }
                case READWRITE: {
                    debuggerMemory.addRangeReadWriteBreakpoint(this.start_address, this.end_address);
                }
            }
            this.installed = true;
        }
    }

    private void uninstall(DebuggerMemory debuggerMemory) {
        if (debuggerMemory != null) {
            switch (this.access) {
                case READ: {
                    debuggerMemory.removeRangeReadBreakpoint(this.start_address, this.end_address);
                    break;
                }
                case WRITE: {
                    debuggerMemory.removeRangeWriteBreakpoint(this.start_address, this.end_address);
                    break;
                }
                case READWRITE: {
                    debuggerMemory.removeRangeReadWriteBreakpoint(this.start_address, this.end_address);
                }
            }
            this.installed = false;
        }
    }

    public static enum AccessType {
        READ,
        WRITE,
        READWRITE;

    }
}

