/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Debugger;

import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.Decoder;
import jpcsp.HLE.Modules;
import jpcsp.Memory;

public class StepFrame {
    private int pc;
    private int[] gpr = new int[32];
    private int opcode;
    private String asm;
    private int threadID;
    private String threadName;
    private boolean dirty = false;
    private String message = "";

    public void make(CpuState cpu) {
        this.pc = cpu.pc;
        for (int i = 0; i < 32; ++i) {
            this.gpr[i] = cpu.getRegister(i);
        }
        this.threadID = Modules.ThreadManForUserModule.getCurrentThreadID();
        this.threadName = Modules.ThreadManForUserModule.getThreadName(this.threadID);
        Memory mem = Memory.getInstance();
        if (Memory.isAddressGood(cpu.pc)) {
            this.opcode = mem.read32(cpu.pc);
            Common.Instruction insn = Decoder.instruction(this.opcode);
            this.asm = insn.disasm(cpu.pc, this.opcode);
        } else {
            this.opcode = 0;
            this.asm = "?";
        }
        this.dirty = true;
    }

    private String getThreadInfo() {
        return String.format("Thread ID - 0x%08X\n", this.threadID) + "Th Name   - " + this.threadName + "\n";
    }

    private String getRegistersInfo() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 32; i += 4) {
            sb.append(String.format("%s:0x%08X %s:0x%08X %s:0x%08X %s:0x%08X\n", Common.gprNames[i + 0].substring(1), this.gpr[i + 0], Common.gprNames[i + 1].substring(1), this.gpr[i + 1], Common.gprNames[i + 2].substring(1), this.gpr[i + 2], Common.gprNames[i + 3].substring(1), this.gpr[i + 3]));
        }
        return sb.toString();
    }

    private void makeMessage() {
        String address = String.format("0x%08X", this.pc);
        String rawdata = String.format("0x%08X", this.opcode);
        this.message = this.getThreadInfo() + this.getRegistersInfo() + address + ": " + rawdata + " - " + this.asm;
    }

    public String getMessage() {
        if (this.dirty) {
            this.dirty = false;
            this.makeMessage();
        }
        return this.message;
    }

    public boolean isJAL() {
        return this.asm.indexOf("jal") != -1;
    }

    public boolean isJRRA() {
        return this.asm.indexOf("jr") != -1 && this.asm.indexOf("$ra") != -1;
    }
}

