/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS;

import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.util.Utilities;

public class ByteArrayVirtualFile
implements IVirtualFile {
    private byte[] buffer;
    private int offset;
    private int length;
    private int currentIndex;

    public ByteArrayVirtualFile(byte[] buffer) {
        this.buffer = buffer;
        this.offset = 0;
        this.length = buffer.length;
    }

    public ByteArrayVirtualFile(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int ioClose() {
        this.buffer = null;
        return 0;
    }

    @Override
    public int ioRead(TPointer outputPointer, int outputLength) {
        outputLength = Math.min(this.length - (this.currentIndex - this.offset), outputLength);
        Utilities.writeBytes(outputPointer.getAddress(), outputLength, this.buffer, this.currentIndex);
        this.currentIndex += outputLength;
        return outputLength;
    }

    @Override
    public int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        outputLength = Math.min(this.length - (this.currentIndex - this.offset), outputLength);
        System.arraycopy(this.buffer, this.currentIndex, outputBuffer, outputOffset, outputLength);
        this.currentIndex += outputLength;
        return outputLength;
    }

    @Override
    public int ioWrite(TPointer inputPointer, int inputLength) {
        return -1;
    }

    @Override
    public int ioWrite(byte[] inputBuffer, int inputOffset, int inputLength) {
        return -1;
    }

    @Override
    public long ioLseek(long offset) {
        this.currentIndex = this.offset + Math.min(this.length, (int)offset);
        return this.getPosition();
    }

    @Override
    public int ioIoctl(int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        return -1;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public boolean isSectorBlockMode() {
        return false;
    }

    @Override
    public long getPosition() {
        return this.currentIndex - this.offset;
    }

    @Override
    public IVirtualFile duplicate() {
        ByteArrayVirtualFile duplicate = new ByteArrayVirtualFile(this.buffer, this.offset, this.length);
        duplicate.ioLseek(this.getPosition());
        return duplicate;
    }
}

