/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.local;

import java.io.FileNotFoundException;
import java.io.IOException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractVirtualFile;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.filesystems.SeekableRandomFile;
import jpcsp.util.Utilities;

public class LocalVirtualFile
extends AbstractVirtualFile {
    protected SeekableRandomFile file;
    protected boolean truncateAtNextWrite;

    public LocalVirtualFile(SeekableRandomFile file) {
        super(file);
        this.file = file;
    }

    @Override
    public int ioWrite(TPointer inputPointer, int inputLength) {
        try {
            Utilities.write(this.file, inputPointer.getAddress(), inputLength);
        }
        catch (IOException e) {
            log.error((Object)"ioWrite", (Throwable)e);
            return -1;
        }
        return inputLength;
    }

    @Override
    public int ioWrite(byte[] inputBuffer, int inputOffset, int inputLength) {
        try {
            if (this.isTruncateAtNextWrite()) {
                long position = this.getPosition();
                if (position < this.file.length()) {
                    this.file.setLength(this.getPosition());
                }
                this.setTruncateAtNextWrite(false);
            }
            this.file.write(inputBuffer, inputOffset, inputLength);
        }
        catch (IOException e) {
            log.error((Object)"ioWrite", (Throwable)e);
            return -1;
        }
        return inputLength;
    }

    public boolean isTruncateAtNextWrite() {
        return this.truncateAtNextWrite;
    }

    public void setTruncateAtNextWrite(boolean truncateAtNextWrite) {
        this.truncateAtNextWrite = truncateAtNextWrite;
    }

    @Override
    public IVirtualFile duplicate() {
        try {
            return new LocalVirtualFile(new SeekableRandomFile(this.file.getFileName(), this.file.getMode()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return super.duplicate();
        }
    }

    public String toString() {
        return String.format("LocalVirtualFile %s", this.file);
    }
}

