/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.local;

import jpcsp.HLE.VFS.ITmpVirtualFileSystem;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.local.LocalVirtualFileSystem;
import jpcsp.HLE.VFS.local.TmpLocalVirtualFile;
import jpcsp.settings.Settings;
import org.apache.log4j.Logger;

public class TmpLocalVirtualFileSystem
extends LocalVirtualFileSystem
implements ITmpVirtualFileSystem {
    protected static Logger log = Logger.getLogger((String)"vfs");

    public TmpLocalVirtualFileSystem() {
        super(Settings.getInstance().getTmpDirectory());
    }

    @Override
    public IVirtualFile ioOpen(String fileName, int flags, int mode, ITmpVirtualFileSystem.IPurpose purpose) {
        String purposeFileName = purpose.getFileName(fileName);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("TmpLocalVirtualFileSystem ioOpen %s -> %s", fileName, purposeFileName));
        }
        return this.ioOpen(purposeFileName, flags, mode);
    }

    @Override
    public IVirtualFile ioOpen(String fileName, int flags, int mode, ITmpVirtualFileSystem.IPurpose purpose, IVirtualFile originalFile) {
        IVirtualFile vFile;
        if (originalFile == null) {
            return this.ioOpen(fileName, flags, mode, purpose);
        }
        String purposeFileName = purpose.getFileName(fileName);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("TmpLocalVirtualFileSystem ioOpen %s -> %s", fileName, purposeFileName));
        }
        if ((vFile = this.ioOpen(purposeFileName, flags, mode)) == null) {
            return null;
        }
        return new TmpLocalVirtualFile(vFile, originalFile);
    }
}

