/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import java.util.HashMap;
import java.util.Iterator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelLwMutexInfo;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.ThreadManForUser;
import org.apache.log4j.Logger;

public class LwMutexManager {
    protected static Logger log = Modules.getLogger("ThreadManForUser");
    private HashMap<Integer, SceKernelLwMutexInfo> lwMutexMap;
    private LwMutexWaitStateChecker lwMutexWaitStateChecker;
    public static final int PSP_LWMUTEX_ATTR_FIFO = 0;
    public static final int PSP_LWMUTEX_ATTR_PRIORITY = 256;
    private static final int PSP_LWMUTEX_ATTR_ALLOW_RECURSIVE = 512;
    public static final LwMutexManager singleton = new LwMutexManager();

    public void reset() {
        this.lwMutexMap = new HashMap();
        this.lwMutexWaitStateChecker = new LwMutexWaitStateChecker();
    }

    private boolean removeWaitingThread(SceKernelThreadInfo thread) {
        SceKernelLwMutexInfo info = this.lwMutexMap.get(thread.wait.LwMutex_id);
        if (info == null) {
            return false;
        }
        info.threadWaitingList.removeWaitingThread(thread);
        return true;
    }

    public void onThreadWaitTimeout(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext._v0 = -2147352152;
        } else {
            log.warn((Object)"LwMutex deleted while we were waiting for it! (timeout expired)");
            thread.cpuContext._v0 = -2147352139;
        }
    }

    public void onThreadWaitReleased(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext._v0 = -2147352150;
        } else {
            log.warn((Object)"EventFlag deleted while we were waiting for it!");
            thread.cpuContext._v0 = -2147352139;
        }
    }

    public void onThreadDeleted(SceKernelThreadInfo thread) {
        if (thread.isWaitingForType(13)) {
            this.removeWaitingThread(thread);
        }
    }

    private void onLwMutexDeleted(int lwmid) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        Iterator<SceKernelThreadInfo> it = threadMan.iterator();
        while (it.hasNext()) {
            SceKernelThreadInfo thread = it.next();
            if (!thread.isWaitingFor(13, lwmid)) continue;
            thread.cpuContext._v0 = -2147352139;
            threadMan.hleChangeThreadState(thread, 2);
            reschedule = true;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private void onLwMutexModified(SceKernelLwMutexInfo info) {
        SceKernelThreadInfo thread;
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        SceKernelThreadInfo checkedThread = null;
        while ((thread = info.threadWaitingList.getNextWaitingThread(checkedThread)) != null) {
            if (this.tryLockLwMutex(info, thread.wait.LwMutex_count, thread)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("onLwMutexModified waking thread %s", thread));
                }
                info.threadid = thread.uid;
                info.threadWaitingList.removeWaitingThread(thread);
                thread.cpuContext._v0 = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
                continue;
            }
            checkedThread = thread;
        }
        if (reschedule) {
            Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        }
    }

    private boolean tryLockLwMutex(SceKernelLwMutexInfo info, int count, SceKernelThreadInfo thread) {
        if (info.lockedCount == 0) {
            info.threadid = thread.uid;
            info.lockedCount += count;
            return true;
        }
        if (info.threadid == thread.uid && (info.attr & 0x200) == 512) {
            info.lockedCount += count;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int hleKernelLockLwMutex(int uid, int count, TPointer32 timeoutAddr, boolean wait, boolean doCallbacks) {
        SceKernelLwMutexInfo info = this.lwMutexMap.get(uid);
        if (info == null) {
            log.warn((Object)String.format("hleKernelLockLwMutex uid=%d, count=%d, timeout_addr=%s, wait=%b, doCallbacks=%b -  - unknown UID", uid, count, timeoutAddr, wait, doCallbacks));
            return -2147352118;
        }
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
        if (this.tryLockLwMutex(info, count, currentThread)) {
            if (!log.isDebugEnabled()) return 0;
            log.debug((Object)String.format("hleKernelLockLwMutex %s, count=%d, timeout_addr=%s, wait=%b, doCallbacks=%b - fast check succeeded", info.toString(), count, timeoutAddr, wait, doCallbacks));
            return 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleKernelLockLwMutex %s, count=%d, timeout_addr=%s, wait=%b, doCallbacks=%b - fast check failed", info.toString(), count, timeoutAddr, wait, doCallbacks));
        }
        if (wait && info.threadid != currentThread.uid) {
            info.threadWaitingList.addWaitingThread(currentThread);
            currentThread.wait.LwMutex_id = uid;
            currentThread.wait.LwMutex_count = count;
            threadMan.hleKernelThreadEnterWaitState(13, uid, this.lwMutexWaitStateChecker, timeoutAddr.getAddress(), doCallbacks);
            return 0;
        }
        if ((info.attr & 0x200) == 512) return -2147352117;
        return -2147352113;
    }

    public int sceKernelCreateLwMutex(TPointer workAreaAddr, String name, int attr, int count, TPointer option) {
        SceKernelLwMutexInfo info = new SceKernelLwMutexInfo(workAreaAddr, name, count, attr);
        this.lwMutexMap.put(info.uid, info);
        return 0;
    }

    public int sceKernelDeleteLwMutex(TPointer workAreaAddr) {
        int uid = workAreaAddr.getValue32();
        SceKernelLwMutexInfo info = this.lwMutexMap.remove(uid);
        if (info == null) {
            log.warn((Object)("sceKernelDeleteLwMutex unknown UID " + Integer.toHexString(uid)));
            return -2147352118;
        }
        workAreaAddr.setValue32(0);
        this.onLwMutexDeleted(uid);
        return 0;
    }

    public int sceKernelLockLwMutex(TPointer workAreaAddr, int count, TPointer32 timeoutAddr) {
        int uid = workAreaAddr.getValue32();
        return this.hleKernelLockLwMutex(uid, count, timeoutAddr, true, false);
    }

    public int sceKernelLockLwMutexCB(TPointer workAreaAddr, int count, TPointer32 timeoutAddr) {
        int uid = workAreaAddr.getValue32();
        return this.hleKernelLockLwMutex(uid, count, timeoutAddr, true, true);
    }

    public int sceKernelTryLockLwMutex(TPointer workAreaAddr, int count) {
        int uid = workAreaAddr.getValue32();
        return this.hleKernelLockLwMutex(uid, count, TPointer32.NULL, false, false);
    }

    public int sceKernelUnlockLwMutex(TPointer workAreaAddr, int count) {
        int uid = workAreaAddr.getValue32();
        SceKernelLwMutexInfo info = this.lwMutexMap.get(uid);
        if (info == null) {
            log.warn((Object)"sceKernelUnlockLwMutex unknown uid");
            return -2147352118;
        }
        if (info.lockedCount == 0) {
            log.debug((Object)"sceKernelUnlockLwMutex not locked");
            return -2147352116;
        }
        if (info.lockedCount < 0) {
            log.warn((Object)"sceKernelUnlockLwMutex underflow");
            return -2147352114;
        }
        info.lockedCount -= count;
        if (info.lockedCount == 0) {
            info.threadid = -1;
            this.onLwMutexModified(info);
        }
        return 0;
    }

    public int sceKernelReferLwMutexStatus(TPointer workAreaAddr, TPointer addr) {
        int uid = workAreaAddr.getValue32();
        SceKernelLwMutexInfo info = this.lwMutexMap.get(uid);
        if (info == null) {
            log.warn((Object)("sceKernelReferLwMutexStatus unknown UID " + Integer.toHexString(uid)));
            return -2147352118;
        }
        info.write(addr);
        return 0;
    }

    public int sceKernelReferLwMutexStatusByID(int uid, TPointer addr) {
        SceKernelLwMutexInfo info = this.lwMutexMap.get(uid);
        if (info == null) {
            log.warn((Object)("sceKernelReferLwMutexStatus unknown UID " + Integer.toHexString(uid)));
            return -2147352118;
        }
        info.write(addr);
        return 0;
    }

    private LwMutexManager() {
    }

    private class LwMutexWaitStateChecker
    implements IWaitStateChecker {
        private LwMutexWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            SceKernelLwMutexInfo info = (SceKernelLwMutexInfo)LwMutexManager.this.lwMutexMap.get(wait.LwMutex_id);
            if (info == null) {
                thread.cpuContext._v0 = -2147352118;
                return false;
            }
            if (LwMutexManager.this.tryLockLwMutex(info, wait.LwMutex_count, thread)) {
                info.threadWaitingList.removeWaitingThread(thread);
                thread.cpuContext._v0 = 0;
                return false;
            }
            return true;
        }
    }
}

