/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructureVariableLength;

public class SceKernelCallbackInfo
extends pspAbstractMemoryMappedStructureVariableLength {
    public final String name;
    public final int threadId;
    public final int callback_addr;
    public final int callback_arg_addr;
    public int notifyCount;
    public int notifyArg;
    public final int uid;

    public SceKernelCallbackInfo(String name, int threadId, int callback_addr, int callback_arg_addr) {
        this.name = name;
        this.threadId = threadId;
        this.callback_addr = callback_addr;
        this.callback_arg_addr = callback_arg_addr;
        this.notifyCount = 0;
        this.notifyArg = 0;
        this.uid = SceUidManager.getNewUid("ThreadMan-callback");
    }

    @Override
    protected void write() {
        super.write();
        this.writeStringNZ(32, this.name);
        this.write32(this.threadId);
        this.write32(this.callback_addr);
        this.write32(this.callback_arg_addr);
        this.write32(this.notifyCount);
        this.write32(this.notifyArg);
    }

    public void startContext(SceKernelThreadInfo thread, IAction afterAction) {
        int registerA0 = this.notifyCount;
        int registerA1 = this.notifyArg;
        int registerA2 = this.callback_arg_addr;
        this.notifyCount = 0;
        this.notifyArg = 0;
        Modules.ThreadManForUserModule.executeCallback(thread, this.callback_addr, afterAction, true, registerA0, registerA1, registerA2);
    }

    @Override
    public String toString() {
        return String.format("uid:0x%X, name:'%s', thread:'%s', PC:%08X, $a0:%08X, $a1: %08X, $a2: %08X", this.uid, this.name, Modules.ThreadManForUserModule.getThreadName(this.threadId), this.callback_addr, this.notifyCount, this.notifyArg, this.callback_arg_addr);
    }
}

