/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import java.nio.charset.Charset;
import jpcsp.HLE.ITPointerBase;
import jpcsp.Memory;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Utilities;

public abstract class pspAbstractMemoryMappedStructure {
    private static final int unknown = 0x11111111;
    private static final Charset charset16 = Charset.forName("UTF-16LE");
    private int baseAddress;
    private int maxSize = Integer.MAX_VALUE;
    private int offset;
    protected Memory mem;

    public abstract int sizeof();

    protected abstract void read();

    protected abstract void write();

    private void start(Memory mem) {
        this.mem = mem;
        this.offset = 0;
    }

    protected void start(Memory mem, int address) {
        this.start(mem);
        this.baseAddress = address;
    }

    private void start(Memory mem, int address, int maxSize) {
        this.start(mem, address);
        this.maxSize = maxSize;
    }

    public void setMaxSize(int maxSize) {
        if (maxSize < 0) {
            maxSize = Integer.MAX_VALUE;
        }
        this.maxSize = maxSize;
    }

    public void read(Memory mem, int address) {
        this.start(mem, address);
        this.read();
    }

    public void read(ITPointerBase pointer) {
        this.read(pointer, 0);
    }

    public void read(ITPointerBase pointer, int offset) {
        this.read(Memory.getInstance(), pointer.getAddress() + offset);
    }

    public void write(Memory mem, int address) {
        this.start(mem, address);
        this.write();
    }

    public void write(ITPointerBase pointer) {
        this.write(pointer, 0);
    }

    public void write(ITPointerBase pointer, int offset) {
        this.write(Memory.getInstance(), pointer.getAddress() + offset);
    }

    public void write(Memory mem) {
        this.start(mem);
        this.write();
    }

    protected int read8() {
        int value = this.offset >= this.maxSize ? 0 : this.mem.read8(this.baseAddress + this.offset);
        ++this.offset;
        return value;
    }

    protected void read8Array(byte[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            array[i] = (byte)this.read8();
        }
    }

    protected void align16() {
        this.offset = this.offset + 1 & 0xFFFFFFFE;
    }

    protected void align32() {
        this.offset = this.offset + 3 & 0xFFFFFFFC;
    }

    protected int read16() {
        this.align16();
        int value = this.offset >= this.maxSize ? 0 : this.mem.read16(this.baseAddress + this.offset);
        this.offset += 2;
        return value;
    }

    protected int readUnaligned16() {
        int n0 = this.read8();
        int n1 = this.read8();
        return n1 << 8 | n0;
    }

    protected int read32() {
        this.align32();
        int value = this.offset >= this.maxSize ? 0 : this.mem.read32(this.baseAddress + this.offset);
        this.offset += 4;
        return value;
    }

    protected int readUnaligned32() {
        int n01 = this.readUnaligned16();
        int n23 = this.readUnaligned16();
        return n23 << 16 | n01;
    }

    protected long read64() {
        this.align32();
        long value = this.offset >= this.maxSize ? 0L : this.mem.read64(this.baseAddress + this.offset);
        this.offset += 8;
        return value;
    }

    protected void read32Array(int[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            array[i] = this.read32();
        }
    }

    protected boolean readBoolean() {
        int value = this.read8();
        return value != 0;
    }

    protected void readBooleanArray(boolean[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            array[i] = this.readBoolean();
        }
    }

    protected float readFloat() {
        int int32 = this.read32();
        return Float.intBitsToFloat(int32);
    }

    protected void readFloatArray(float[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            array[i] = this.readFloat();
        }
    }

    protected void readFloatArray(float[][] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            this.readFloatArray(array[i]);
        }
    }

    protected void readUnknown(int length) {
        this.offset += length;
    }

    protected String readStringNZ(int n) {
        String s = this.offset >= this.maxSize ? null : Utilities.readStringNZ(this.mem, this.baseAddress + this.offset, n);
        this.offset += n;
        return s;
    }

    protected String readStringZ(int addr) {
        if (addr == 0) {
            return null;
        }
        return Utilities.readStringZ(this.mem, addr);
    }

    protected String readStringUTF16Z(int addr) {
        int char16;
        if (addr == 0) {
            return null;
        }
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(addr, 2);
        StringBuilder s = new StringBuilder();
        while ((char16 = memoryReader.readNext()) != 0) {
            byte[] bytes = new byte[]{(byte)char16, (byte)(char16 >> 8)};
            s.append(new String(bytes, charset16));
        }
        return s.toString();
    }

    protected int writeStringUTF16Z(int addr, String s) {
        if (addr == 0 || s == null) {
            return 0;
        }
        byte[] bytes = s.getBytes(charset16);
        if (bytes == null) {
            return 0;
        }
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(addr, bytes.length + 2, 1);
        for (int i = 0; i < bytes.length; ++i) {
            memoryWriter.writeNext(bytes[i] & 0xFF);
        }
        memoryWriter.writeNext(0);
        memoryWriter.writeNext(0);
        memoryWriter.flush();
        return bytes.length;
    }

    protected void read(pspAbstractMemoryMappedStructure object) {
        if (object == null) {
            return;
        }
        if (this.offset < this.maxSize) {
            object.start(this.mem, this.baseAddress + this.offset, this.maxSize - this.offset);
            object.read();
        }
        this.offset += object.sizeof();
    }

    protected void write8(byte data) {
        if (this.offset < this.maxSize) {
            this.mem.write8(this.baseAddress + this.offset, data);
        }
        ++this.offset;
    }

    protected void write8Array(byte[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            this.write8(array[i]);
        }
    }

    protected void write16(short data) {
        this.align16();
        if (this.offset < this.maxSize) {
            this.mem.write16(this.baseAddress + this.offset, data);
        }
        this.offset += 2;
    }

    protected void writeUnaligned16(short data) {
        this.write8((byte)data);
        this.write8((byte)(data >>> 8));
    }

    protected void write32(int data) {
        this.align32();
        if (this.offset < this.maxSize) {
            this.mem.write32(this.baseAddress + this.offset, data);
        }
        this.offset += 4;
    }

    protected void writeUnaligned32(int data) {
        this.writeUnaligned16((short)data);
        this.writeUnaligned16((short)(data >>> 16));
    }

    protected void write64(long data) {
        this.align32();
        if (this.offset < this.maxSize) {
            this.mem.write64(this.baseAddress + this.offset, data);
        }
        this.offset += 8;
    }

    protected void write32Array(int[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            this.write32(array[i]);
        }
    }

    protected void writeBoolean(boolean data) {
        this.write8(data ? (byte)1 : 0);
    }

    protected void writeBooleanArray(boolean[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            this.writeBoolean(array[i]);
        }
    }

    protected void writeFloat(float data) {
        int int32 = Float.floatToIntBits(data);
        this.write32(int32);
    }

    protected void writeFloatArray(float[] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            this.writeFloat(array[i]);
        }
    }

    protected void writeFloatArray(float[][] array) {
        for (int i = 0; array != null && i < array.length; ++i) {
            this.writeFloatArray(array[i]);
        }
    }

    protected void writeUnknown(int length) {
        for (int i = 0; i < length; ++i) {
            this.write8((byte)17);
        }
    }

    protected void writeSkip(int length) {
        this.offset += length;
    }

    protected void writeStringNZ(int n, String s) {
        if (this.offset < this.maxSize) {
            Utilities.writeStringNZ(this.mem, this.baseAddress + this.offset, n - 1, s);
            this.mem.write8(this.baseAddress + this.offset + n - 1, (byte)0);
        }
        this.offset += n;
    }

    protected void writeStringZ(String s, int addr) {
        if (s != null && addr != 0) {
            Utilities.writeStringZ(this.mem, addr, s);
        }
    }

    protected void write(pspAbstractMemoryMappedStructure object) {
        if (object == null) {
            return;
        }
        if (this.offset < this.maxSize) {
            object.start(this.mem, this.baseAddress + this.offset, this.maxSize - this.offset);
            object.write();
        }
        this.offset += object.sizeof();
    }

    protected int getOffset() {
        return this.offset;
    }

    public int getBaseAddress() {
        return this.baseAddress;
    }

    protected int endianSwap16(short data) {
        return Short.reverseBytes(data) & 0xFFFF;
    }

    protected int endianSwap32(int data) {
        return Integer.reverseBytes(data);
    }

    public String toString() {
        return String.format("0x%08X", this.getBaseAddress());
    }
}

