/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules620;

import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.modules150.sceAtrac3plus;
import jpcsp.Memory;
import jpcsp.connector.AtracCodec;
import jpcsp.util.Utilities;

@HLELogging
public class sceAtrac3plus
extends jpcsp.HLE.modules600.sceAtrac3plus {
    protected int findRIFFHeader(int addr) {
        Memory mem = Memory.getInstance();
        for (int i = 0; i >= -512; i -= 4) {
            if (mem.read32(addr + i) != 1179011410) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Found RIFF header at 0x%08X", addr + i));
                if (log.isTraceEnabled()) {
                    log.trace((Object)Utilities.getMemoryDump(addr + i, -i));
                }
            }
            return addr + i;
        }
        return 0;
    }

    @HLEFunction(nid=202468891, version=620)
    public int sceAtracLowLevelDecode(@CheckArgument(value="checkAtracID") int atID, TPointer sourceAddr, TPointer32 sourceBytesConsumedAddr, TPointer samplesAddr, TPointer32 sampleBytesAddr) {
        sceAtrac3plus.AtracID id = (sceAtrac3plus.AtracID)this.atracIDs.get(atID);
        AtracCodec atracCodec = id.getAtracCodec();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceAtracLowLevelDecode input:%s", Utilities.getMemoryDump(sourceAddr.getAddress(), id.getSourceBufferLength())));
        }
        int sourceBytesConsumed = 0;
        if (id.getInputBuffer() == null) {
            int headerAddr = this.findRIFFHeader(sourceAddr.getAddress());
            if (headerAddr != 0) {
                id.setData(headerAddr, id.getSourceBufferLength() + (sourceAddr.getAddress() - headerAddr), id.getSourceBufferLength(), false);
            } else {
                id.setData(sourceAddr.getAddress(), id.getSourceBufferLength(), id.getSourceBufferLength(), false);
            }
            if (atracCodec != null && id.getAtracCodecType() == 4097) {
                atracCodec.setAtracChannelStartLength(32768);
            }
            sourceBytesConsumed = id.getSourceBufferLength();
            id.setLoopNum(-1);
        } else {
            int estimatedFileOffset = (int)((long)id.getInputFileSize() * (long)id.getAtracCurrentSample() / (long)id.getAtracEndSample());
            sourceBytesConsumed = Math.max(0, estimatedFileOffset - id.getInputBuffer().getFilePosition());
            sourceBytesConsumed = Math.min(sourceBytesConsumed, id.getSourceBufferLength());
            id.addStreamData(sourceAddr.getAddress(), sourceBytesConsumed);
        }
        int bytesPerSample = id.getAtracOutputChannels() << 1;
        if (atracCodec != null) {
            int sampleBytes;
            int samples = atracCodec.atracDecodeData(atID, samplesAddr.getAddress(), id.getAtracOutputChannels());
            if (sourceBytesConsumed < id.getSourceBufferLength() && (samples < id.getMaxSamples() || atracCodec.getChannelLength() < 32768)) {
                id.addStreamData(sourceAddr.getAddress() + sourceBytesConsumed, id.getSourceBufferLength() - sourceBytesConsumed);
                sourceBytesConsumed = id.getSourceBufferLength();
            }
            if (samples <= 1) {
                samples = id.getMaxSamples();
                sampleBytes = samples * bytesPerSample;
                samplesAddr.clear(sampleBytes);
            } else if (samples > 0) {
                id.setDecodedSamples(samples);
                if (samples < id.getMaxSamples()) {
                    sampleBytes = samples * bytesPerSample;
                    int fillSamples = id.getMaxSamples() - samples;
                    int fillSampleBytes = fillSamples * bytesPerSample;
                    samplesAddr.clear(sampleBytes, fillSampleBytes);
                    samples = id.getMaxSamples();
                }
            }
            sampleBytes = samples * bytesPerSample;
            sampleBytesAddr.setValue(sampleBytes);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAtracLowLevelDecode returning %d samples (0x%X bytes), 0x%X source bytes consumed, sample position %d/%d, file position %d/%d", samples, sampleBytes, sourceBytesConsumed, id.getAtracCurrentSample(), id.getAtracEndSample(), id.getInputBuffer().getFilePosition(), id.getInputFileSize()));
                if (log.isTraceEnabled()) {
                    log.trace((Object)Utilities.getMemoryDump(samplesAddr.getAddress(), sampleBytes));
                }
            }
        } else {
            int samples = id.getMaxSamples();
            int sampleBytes = samples * bytesPerSample;
            sampleBytesAddr.setValue(sampleBytes);
            samplesAddr.clear(sampleBytes);
        }
        sourceBytesConsumedAddr.setValue(sourceBytesConsumed);
        Modules.ThreadManForUserModule.hleKernelDelayThread(2300, false);
        return 0;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=360044107, version=620)
    public int sceAtracLowLevelInitDecoder(@CheckArgument(value="checkAtracID") int atID, TPointer32 paramsAddr) {
        int numberOfChannels = paramsAddr.getValue(0);
        int outputChannels = paramsAddr.getValue(4);
        int sourceBufferLength = paramsAddr.getValue(8);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracLowLevelInitDecoder values at %s: numberOfChannels=%d, outputChannels=%d, sourceBufferLength=0x%08X", paramsAddr, numberOfChannels, outputChannels, sourceBufferLength));
        }
        sceAtrac3plus.AtracID id = (sceAtrac3plus.AtracID)this.atracIDs.get(atID);
        id.setAtracChannels(numberOfChannels);
        if (numberOfChannels == 1 && numberOfChannels == outputChannels) {
            id.setAtracOutputChannels(outputChannels);
        }
        id.setSourceBufferLength(sourceBufferLength);
        return 0;
    }
}

