/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.crypto;

import java.nio.ByteBuffer;
import java.util.Random;
import jpcsp.crypto.AES128;
import jpcsp.crypto.CryptoEngine;
import jpcsp.crypto.ECDSA;
import jpcsp.crypto.KeyVault;
import jpcsp.crypto.SHA1;

public class KIRK {
    private int[] fuseID = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int PSP_KIRK_NOT_ENABLED = 1;
    public static final int PSP_KIRK_INVALID_MODE = 2;
    public static final int PSP_KIRK_INVALID_HEADER_HASH = 3;
    public static final int PSP_KIRK_INVALID_DATA_HASH = 4;
    public static final int PSP_KIRK_INVALID_SIG_CHECK = 5;
    public static final int PSP_KIRK_UNK1 = 6;
    public static final int PSP_KIRK_UNK2 = 7;
    public static final int PSP_KIRK_UNK3 = 8;
    public static final int PSP_KIRK_UNK4 = 9;
    public static final int PSP_KIRK_UNK5 = 10;
    public static final int PSP_KIRK_UNK6 = 11;
    public static final int PSP_KIRK_NOT_INIT = 12;
    public static final int PSP_KIRK_INVALID_OPERATION = 13;
    public static final int PSP_KIRK_INVALID_SEED = 14;
    public static final int PSP_KIRK_INVALID_SIZE = 15;
    public static final int PSP_KIRK_DATA_SIZE_IS_ZERO = 16;
    public static final int PSP_SUBCWR_NOT_16_ALGINED = 2314;
    public static final int PSP_SUBCWR_HEADER_HASH_INVALID = 2336;
    public static final int PSP_SUBCWR_BUFFER_TOO_SMALL = 4096;
    public static final int PSP_KIRK_CMD_DECRYPT_PRIVATE = 1;
    public static final int PSP_KIRK_CMD_ENCRYPT_SIGN = 2;
    public static final int PSP_KIRK_CMD_DECRYPT_SIGN = 3;
    public static final int PSP_KIRK_CMD_ENCRYPT = 4;
    public static final int PSP_KIRK_CMD_ENCRYPT_FUSE = 5;
    public static final int PSP_KIRK_CMD_ENCRYPT_USER = 6;
    public static final int PSP_KIRK_CMD_DECRYPT = 7;
    public static final int PSP_KIRK_CMD_DECRYPT_FUSE = 8;
    public static final int PSP_KIRK_CMD_DECRYPT_USER = 9;
    public static final int PSP_KIRK_CMD_PRIV_SIG_CHECK = 10;
    public static final int PSP_KIRK_CMD_SHA1_HASH = 11;
    public static final int PSP_KIRK_CMD_ECDSA_GEN_KEYS = 12;
    public static final int PSP_KIRK_CMD_ECDSA_MULTIPLY_POINT = 13;
    public static final int PSP_KIRK_CMD_PRNG = 14;
    public static final int PSP_KIRK_CMD_INIT = 15;
    public static final int PSP_KIRK_CMD_ECDSA_SIGN = 16;
    public static final int PSP_KIRK_CMD_ECDSA_VERIFY = 17;
    public static final int PSP_KIRK_CMD_CERT_VERIFY = 18;
    public static final int PSP_KIRK_CMD_MODE_CMD1 = 1;
    public static final int PSP_KIRK_CMD_MODE_CMD2 = 2;
    public static final int PSP_KIRK_CMD_MODE_CMD3 = 3;
    public static final int PSP_KIRK_CMD_MODE_ENCRYPT_CBC = 4;
    public static final int PSP_KIRK_CMD_MODE_DECRYPT_CBC = 5;

    private int[] getAESKeyFromSeed(int seed) {
        switch (seed) {
            case 2: {
                return KeyVault.kirkAESKey20;
            }
            case 3: {
                return KeyVault.kirkAESKey1;
            }
            case 4: {
                return KeyVault.kirkAESKey2;
            }
            case 5: {
                return KeyVault.kirkAESKey3;
            }
            case 7: {
                return KeyVault.kirkAESKey21;
            }
            case 12: {
                return KeyVault.kirkAESKey4;
            }
            case 13: {
                return KeyVault.kirkAESKey5;
            }
            case 14: {
                return KeyVault.kirkAESKey6;
            }
            case 15: {
                return KeyVault.kirkAESKey7;
            }
            case 16: {
                return KeyVault.kirkAESKey8;
            }
            case 17: {
                return KeyVault.kirkAESKey9;
            }
            case 18: {
                return KeyVault.kirkAESKey10;
            }
            case 56: {
                return KeyVault.kirkAESKey11;
            }
            case 57: {
                return KeyVault.kirkAESKey12;
            }
            case 58: {
                return KeyVault.kirkAESKey13;
            }
            case 68: {
                return KeyVault.kirkAESKey22;
            }
            case 75: {
                return KeyVault.kirkAESKey14;
            }
            case 83: {
                return KeyVault.kirkAESKey15;
            }
            case 87: {
                return KeyVault.kirkAESKey16;
            }
            case 93: {
                return KeyVault.kirkAESKey17;
            }
            case 99: {
                return KeyVault.kirkAESKey18;
            }
            case 100: {
                return KeyVault.kirkAESKey19;
            }
        }
        return null;
    }

    private int executeKIRKCmd1(ByteBuffer out, ByteBuffer in, int size) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        ByteBuffer sigIn = in.duplicate();
        AES128_CMAC_Header header = new AES128_CMAC_Header(in);
        if (header.mode != 1) {
            return 2;
        }
        AES128 aes = new AES128("AES/CBC/NoPadding");
        byte[] k = new byte[16];
        for (int i = 0; i < KeyVault.kirkAESKey0.length; ++i) {
            k[i] = (byte)KeyVault.kirkAESKey0[i];
        }
        byte[] encryptedKeys = new byte[32];
        System.arraycopy(header.AES128Key, 0, encryptedKeys, 0, 16);
        System.arraycopy(header.CMACKey, 0, encryptedKeys, 16, 16);
        byte[] decryptedKeys = aes.decrypt(encryptedKeys, k, this.iv);
        int sigCheck = this.executeKIRKCmd10(sigIn, size);
        if (decryptedKeys == null) {
            return sigCheck;
        }
        byte[] aesBuf = new byte[16];
        System.arraycopy(decryptedKeys, 0, aesBuf, 0, aesBuf.length);
        int headerSize = 144;
        int headerOffset = 64;
        int elfDataSize = Integer.reverseBytes(header.dataSize);
        int elfDataOffset = Integer.reverseBytes(header.dataOffset);
        int paddedElfDataSize = elfDataSize + 15 & 0xFFFFFFF0;
        byte[] inBuf = new byte[paddedElfDataSize];
        System.arraycopy(in.array(), elfDataOffset + headerOffset + headerSize, inBuf, 0, paddedElfDataSize);
        byte[] outBuf = aes.decrypt(inBuf, aesBuf, this.iv);
        out.clear();
        out.put(outBuf);
        out.limit(elfDataSize);
        in.clear();
        return 0;
    }

    private int executeKIRKCmd4(ByteBuffer out, ByteBuffer in, int size) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        AES128_CBC_Header header = new AES128_CBC_Header(in);
        if (header.mode != 4) {
            return 2;
        }
        if (header.dataSize == 0) {
            return 16;
        }
        int[] key = this.getAESKeyFromSeed(header.keySeed);
        if (key == null) {
            return 15;
        }
        byte[] encKey = new byte[16];
        for (int i = 0; i < encKey.length; ++i) {
            encKey[i] = (byte)key[i];
        }
        AES128 aes = new AES128("AES/CBC/NoPadding");
        byte[] inBuf = new byte[size];
        in.get(inBuf, 0, size);
        byte[] outBuf = aes.encrypt(inBuf, encKey, this.iv);
        out.clear();
        out.put(outBuf);
        in.clear();
        return 0;
    }

    private int executeKIRKCmd5(ByteBuffer out, ByteBuffer in, int size) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        AES128_CBC_Header header = new AES128_CBC_Header(in);
        if (header.mode != 4) {
            return 2;
        }
        if (header.dataSize == 0) {
            return 16;
        }
        int[] key = null;
        if (header.keySeed != 256) {
            return 15;
        }
        key = this.fuseID;
        byte[] encKey = new byte[16];
        for (int i = 0; i < encKey.length; ++i) {
            encKey[i] = (byte)key[i];
        }
        AES128 aes = new AES128("AES/CBC/NoPadding");
        byte[] inBuf = new byte[size];
        in.get(inBuf, 0, size);
        byte[] outBuf = aes.encrypt(inBuf, encKey, this.iv);
        out.clear();
        out.put(outBuf);
        in.clear();
        return 0;
    }

    private int executeKIRKCmd7(ByteBuffer out, ByteBuffer in, int size) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        AES128_CBC_Header header = new AES128_CBC_Header(in);
        if (header.mode != 5) {
            return 2;
        }
        if (header.dataSize == 0) {
            return 16;
        }
        int[] key = this.getAESKeyFromSeed(header.keySeed);
        if (key == null) {
            return 15;
        }
        byte[] decKey = new byte[16];
        for (int i = 0; i < decKey.length; ++i) {
            decKey[i] = (byte)key[i];
        }
        AES128 aes = new AES128("AES/CBC/NoPadding");
        byte[] inBuf = new byte[size];
        in.get(inBuf, 0, size);
        byte[] outBuf = aes.decrypt(inBuf, decKey, this.iv);
        out.clear();
        out.put(outBuf);
        in.clear();
        return 0;
    }

    private int executeKIRKCmd8(ByteBuffer out, ByteBuffer in, int size) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        AES128_CBC_Header header = new AES128_CBC_Header(in);
        if (header.mode != 5) {
            return 2;
        }
        if (header.dataSize == 0) {
            return 16;
        }
        int[] key = null;
        if (header.keySeed != 256) {
            return 15;
        }
        key = this.fuseID;
        byte[] decKey = new byte[16];
        for (int i = 0; i < decKey.length; ++i) {
            decKey[i] = (byte)key[i];
        }
        AES128 aes = new AES128("AES/CBC/NoPadding");
        byte[] inBuf = new byte[size];
        in.get(inBuf, 0, size);
        byte[] outBuf = aes.decrypt(inBuf, decKey, this.iv);
        out.clear();
        out.put(outBuf);
        in.clear();
        return 0;
    }

    private int executeKIRKCmd10(ByteBuffer in, int size) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        AES128_CMAC_Header header = new AES128_CMAC_Header(in);
        if (header.mode != 1 && header.mode != 2 && header.mode != 3) {
            return 2;
        }
        if (header.dataSize == 0) {
            return 16;
        }
        AES128 aes = new AES128("AES/CBC/NoPadding");
        byte[] k = new byte[16];
        for (int i = 0; i < KeyVault.kirkAESKey0.length; ++i) {
            k[i] = (byte)KeyVault.kirkAESKey0[i];
        }
        byte[] encryptedKeys = new byte[32];
        System.arraycopy(header.AES128Key, 0, encryptedKeys, 0, 16);
        System.arraycopy(header.CMACKey, 0, encryptedKeys, 16, 16);
        byte[] decryptedKeys = aes.decrypt(encryptedKeys, k, this.iv);
        byte[] cmacHeaderHash = new byte[16];
        byte[] cmacDataHash = new byte[16];
        byte[] cmacBuf = new byte[16];
        System.arraycopy(decryptedKeys, 16, cmacBuf, 0, cmacBuf.length);
        byte[] inBuf = new byte[in.capacity() - 96];
        System.arraycopy(in.array(), 96, inBuf, 0, inBuf.length);
        aes.doInitCMAC(cmacBuf);
        aes.doUpdateCMAC(inBuf, 0, 48);
        cmacHeaderHash = aes.doFinalCMAC();
        int blockSize = Integer.reverseBytes(header.dataSize);
        if (blockSize % 16 != 0) {
            blockSize += 16 - blockSize % 16;
        }
        aes.doInitCMAC(cmacBuf);
        aes.doUpdateCMAC(inBuf, 0, 48 + blockSize + Integer.reverseBytes(header.dataOffset));
        cmacDataHash = aes.doFinalCMAC();
        if (cmacHeaderHash != header.CMACHeaderHash) {
            return 3;
        }
        if (cmacDataHash != header.CMACDataHash) {
            return 4;
        }
        return 0;
    }

    private int executeKIRKCmd11(ByteBuffer out, ByteBuffer in, int size) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        SHA1_Header header = new SHA1_Header(in);
        SHA1 sha1 = new SHA1();
        size = size < header.dataSize ? size : header.dataSize;
        header.readData(in, size);
        out.clear();
        out.put(sha1.doSHA1(header.data, size));
        in.clear();
        return 0;
    }

    private int executeKIRKCmd12(ByteBuffer out, int size) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        if (size != 60) {
            return 15;
        }
        ECDSA ecdsa = new ECDSA();
        ECDSAKeygenCtx ctx = new ECDSAKeygenCtx(out);
        ecdsa.setCurve();
        ECDSAKeygenCtx.access$1902(ctx, ecdsa.getPrivateKey());
        ctx.public_key = new ECDSAPoint(ecdsa.getPublicKey());
        ctx.write();
        return 0;
    }

    private int executeKIRKCmd13(ByteBuffer out, int outSize, ByteBuffer in, int inSize) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        if (inSize != 60 || outSize != 40) {
            return 15;
        }
        ECDSA ecdsa = new ECDSA();
        ECDSAMultiplyCtx ctx = new ECDSAMultiplyCtx(in, out);
        ecdsa.setCurve();
        ecdsa.multiplyPublicKey(ctx.public_key.toByteArray(), ctx.multiplier);
        ctx.write();
        return 0;
    }

    private int executeKIRKCmd14(ByteBuffer out, int size) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        if (size > 0) {
            Random rd = new Random();
            byte[] rdBytes = new byte[size];
            rd.nextBytes(rdBytes);
            out.clear();
            out.put(rdBytes);
        }
        return 0;
    }

    private int executeKIRKCmd16(ByteBuffer out, int outSize, ByteBuffer in, int inSize) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        if (inSize != 52 || outSize != 40) {
            return 15;
        }
        ECDSA ecdsa = new ECDSA();
        ECDSASignCtx ctx = new ECDSASignCtx(in);
        ECDSASig sig = new ECDSASig();
        ecdsa.setCurve();
        return 0;
    }

    private int executeKIRKCmd17(ByteBuffer in, int size) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        if (size != 100) {
            return 15;
        }
        ECDSA ecdsa = new ECDSA();
        ECDSAVerifyCtx ctx = new ECDSAVerifyCtx(in);
        ecdsa.setCurve();
        return 0;
    }

    public void hleUtilsSetFuseID(int[] id) {
        this.fuseID = id;
    }

    public int hleUtilsBufferCopyWithRange(ByteBuffer out, int outsize, ByteBuffer in, int insize, int cmd) {
        switch (cmd) {
            case 1: {
                return this.executeKIRKCmd1(out, in, insize);
            }
            case 4: {
                return this.executeKIRKCmd4(out, in, insize);
            }
            case 5: {
                return this.executeKIRKCmd5(out, in, insize);
            }
            case 7: {
                return this.executeKIRKCmd7(out, in, insize);
            }
            case 8: {
                return this.executeKIRKCmd8(out, in, insize);
            }
            case 10: {
                return this.executeKIRKCmd10(in, insize);
            }
            case 11: {
                return this.executeKIRKCmd11(out, in, insize);
            }
            case 12: {
                return this.executeKIRKCmd12(out, outsize);
            }
            case 13: {
                return this.executeKIRKCmd13(out, outsize, in, insize);
            }
            case 14: {
                return this.executeKIRKCmd14(out, insize);
            }
            case 16: {
                return this.executeKIRKCmd16(out, outsize, in, insize);
            }
            case 17: {
                return this.executeKIRKCmd17(in, insize);
            }
        }
        return 13;
    }

    private class ECDSAVerifyCtx {
        private ECDSAPoint public_key;
        private byte[] hash = new byte[20];
        private ECDSASig sig;

        private ECDSAVerifyCtx(ByteBuffer buf) {
            buf.get(this.public_key.x, 0, 20);
            buf.get(this.public_key.y, 0, 20);
            buf.get(this.hash, 0, 20);
            buf.get(this.sig.r, 0, 20);
            buf.get(this.sig.s, 0, 20);
        }
    }

    private class ECDSASignCtx {
        private byte[] enc = new byte[32];
        private byte[] hash = new byte[20];

        private ECDSASignCtx(ByteBuffer buf) {
            buf.get(this.enc, 0, 32);
            buf.get(this.hash, 0, 20);
        }
    }

    private class ECDSAMultiplyCtx {
        private byte[] multiplier = new byte[20];
        private ECDSAPoint public_key = new ECDSAPoint();
        private ByteBuffer out;

        private ECDSAMultiplyCtx(ByteBuffer input, ByteBuffer output) {
            this.out = output;
            input.get(this.multiplier, 0, 20);
            input.get(this.public_key.x, 0, 20);
            input.get(this.public_key.y, 0, 20);
        }

        public void write() {
            this.out.put(this.multiplier);
            this.out.put(this.public_key.toByteArray());
        }
    }

    private class ECDSAKeygenCtx {
        private byte[] private_key = new byte[20];
        private ECDSAPoint public_key;
        private ByteBuffer out;

        private ECDSAKeygenCtx(ByteBuffer output) {
            this.public_key = new ECDSAPoint();
            this.out = output;
        }

        public void write() {
            this.out.put(this.private_key);
            this.out.put(this.public_key.toByteArray());
        }

        static /* synthetic */ byte[] access$1902(ECDSAKeygenCtx x0, byte[] x1) {
            x0.private_key = x1;
            return x1;
        }
    }

    private class ECDSAPoint {
        private byte[] x = new byte[20];
        private byte[] y = new byte[20];

        private ECDSAPoint() {
        }

        private ECDSAPoint(byte[] data) {
            System.arraycopy(data, 0, this.x, 0, 20);
            System.arraycopy(data, 20, this.y, 0, 20);
        }

        public byte[] toByteArray() {
            byte[] point = new byte[40];
            System.arraycopy(point, 0, this.x, 0, 20);
            System.arraycopy(point, 20, this.y, 0, 20);
            return point;
        }
    }

    private class ECDSASig {
        private byte[] r = new byte[20];
        private byte[] s = new byte[20];

        private ECDSASig() {
        }
    }

    private class AES128_CMAC_ECDSA_Header {
        private byte[] AES128Key = new byte[16];
        private byte[] ECDSAHeaderSig_r = new byte[20];
        private byte[] ECDSAHeaderSig_s = new byte[20];
        private byte[] ECDSADataSig_r = new byte[20];
        private byte[] ECDSADataSig_s = new byte[20];
        private int mode;
        private byte useECDSAhash;
        private byte[] unk1 = new byte[11];
        private int dataSize;
        private int dataOffset;
        private byte[] unk2 = new byte[8];
        private byte[] unk3 = new byte[16];

        public AES128_CMAC_ECDSA_Header(ByteBuffer buf) {
            buf.get(this.AES128Key, 0, 16);
            buf.get(this.ECDSAHeaderSig_r, 0, 20);
            buf.get(this.ECDSAHeaderSig_s, 0, 20);
            buf.get(this.ECDSADataSig_r, 0, 20);
            buf.get(this.ECDSADataSig_s, 0, 20);
            this.mode = buf.getInt();
            this.useECDSAhash = buf.get();
            buf.get(this.unk1, 0, 11);
            this.dataSize = buf.getInt();
            this.dataOffset = buf.getInt();
            buf.get(this.unk2, 0, 8);
            buf.get(this.unk3, 0, 16);
        }
    }

    private class AES128_CMAC_Header {
        private byte[] AES128Key = new byte[16];
        private byte[] CMACKey = new byte[16];
        private byte[] CMACHeaderHash = new byte[16];
        private byte[] CMACDataHash = new byte[16];
        private byte[] unk1 = new byte[32];
        private int mode;
        private byte useECDSAhash;
        private byte[] unk2 = new byte[11];
        private int dataSize;
        private int dataOffset;
        private byte[] unk3 = new byte[8];
        private byte[] unk4 = new byte[16];

        public AES128_CMAC_Header(ByteBuffer buf) {
            buf.get(this.AES128Key, 0, 16);
            buf.get(this.CMACKey, 0, 16);
            buf.get(this.CMACHeaderHash, 0, 16);
            buf.get(this.CMACDataHash, 0, 16);
            buf.get(this.unk1, 0, 32);
            this.mode = buf.getInt();
            this.useECDSAhash = buf.get();
            buf.get(this.unk2, 0, 11);
            this.dataSize = buf.getInt();
            this.dataOffset = buf.getInt();
            buf.get(this.unk3, 0, 8);
            buf.get(this.unk4, 0, 16);
        }
    }

    private class AES128_CBC_Header {
        private int mode;
        private int unk1;
        private int unk2;
        private int keySeed;
        private int dataSize;

        public AES128_CBC_Header(ByteBuffer buf) {
            this.mode = buf.getInt();
            this.unk1 = buf.getInt();
            this.unk2 = buf.getInt();
            this.keySeed = buf.getInt();
            this.dataSize = buf.getInt();
        }
    }

    private class SHA1_Header {
        private int dataSize;
        private byte[] data;

        public SHA1_Header(ByteBuffer buf) {
            this.dataSize = buf.getInt();
        }

        private void readData(ByteBuffer buf, int size) {
            this.data = new byte[size];
            buf.get(this.data, 0, size);
        }
    }
}

