/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.Memory;
import jpcsp.format.DeferredStub;

public class DeferredVStubHI16
extends DeferredStub {
    public DeferredVStubHI16(SceModule sourceModule, String moduleName, int importAddress, int nid) {
        super(sourceModule, moduleName, importAddress, nid);
    }

    @Override
    public void resolve(Memory mem, int address) {
        int hiValue = mem.read16(this.getImportAddress()) << 16;
        int value = hiValue << 16;
        short relocatedLoValue = (short)(value += address);
        short relocatedHiValue = (short)(value >>> 16);
        if (relocatedLoValue < 0) {
            relocatedHiValue = (short)(relocatedHiValue + 1);
        }
        mem.write16(this.getImportAddress(), relocatedHiValue);
    }

    @Override
    public String toString() {
        return String.format("HI16 %s", super.toString());
    }
}

