/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.HLE.ISerializeString;
import jpcsp.HLE.ISerializeStruct;
import jpcsp.HLE.kernel.types.SceFontInfo;
import jpcsp.util.Utilities;

public class PGF {
    protected int headerOffset;
    protected int headerSize;
    protected String PGFMagic;
    protected int revision;
    protected int version;
    protected int charMapLength;
    protected int charPointerLength;
    protected int charMapBpe;
    protected int charPointerBpe;
    protected int bpp;
    protected int hSize;
    protected int vSize;
    protected int hResolution;
    protected int vResolution;
    protected String fontName;
    protected String fontType;
    protected int firstGlyph;
    protected int lastGlyph;
    protected int maxAscender;
    protected int maxDescender;
    protected int maxLeftXAdjust;
    protected int maxBaseYAdjust;
    protected int minCenterXAdjust;
    protected int maxTopYAdjust;
    protected int[] maxAdvance = new int[2];
    protected int[] maxSize = new int[2];
    protected int maxGlyphWidth;
    protected int maxGlyphHeight;
    protected int dimTableLength;
    protected int xAdjustTableLength;
    protected int yAdjustTableLength;
    protected int advanceTableLength;
    protected int shadowMapLength;
    protected int shadowMapBpe;
    protected int[] shadowScale = new int[2];
    protected int compCharMapBpe1;
    protected int compCharMapLength1;
    protected int compCharMapBpe2;
    protected int compCharMapLength2;
    protected int[][] dimensionTable;
    protected int[][] xAdjustTable;
    protected int[][] yAdjustTable;
    protected int[][] charmapCompressionTable1;
    protected int[][] charmapCompressionTable2;
    protected int[][] advanceTable;
    protected int[] shadowCharMap;
    protected int[] charMap;
    protected int[] charPointerTable;
    protected int[] fontData;
    protected int fontDataOffset;
    protected int fontDataLength;
    protected String fileNamez = "";

    protected PGF() {
    }

    public PGF(ByteBuffer f) throws IOException {
        this.read(f);
    }

    private void read(ByteBuffer f) throws IOException {
        int i;
        int i2;
        int i3;
        if (f.capacity() == 0) {
            return;
        }
        this.headerOffset = Utilities.readUHalf(f);
        this.headerSize = Utilities.readUHalf(f);
        this.PGFMagic = Utilities.readStringNZ(f, 4);
        this.revision = Utilities.readWord(f);
        this.version = Utilities.readWord(f);
        this.charMapLength = Utilities.readWord(f);
        this.charPointerLength = Utilities.readWord(f);
        this.charMapBpe = Utilities.readWord(f);
        this.charPointerBpe = Utilities.readWord(f);
        Utilities.skipUnknown(f, 2);
        this.bpp = Utilities.readUByte(f);
        Utilities.skipUnknown(f, 1);
        this.hSize = Utilities.readWord(f);
        this.vSize = Utilities.readWord(f);
        this.hResolution = Utilities.readWord(f);
        this.vResolution = Utilities.readWord(f);
        Utilities.skipUnknown(f, 1);
        this.fontName = Utilities.readStringNZ(f, 64);
        this.fontType = Utilities.readStringNZ(f, 64);
        Utilities.skipUnknown(f, 1);
        this.firstGlyph = Utilities.readUHalf(f);
        this.lastGlyph = Utilities.readUHalf(f);
        Utilities.skipUnknown(f, 26);
        this.maxAscender = Utilities.readWord(f);
        this.maxDescender = Utilities.readWord(f);
        this.maxLeftXAdjust = Utilities.readWord(f);
        this.maxBaseYAdjust = Utilities.readWord(f);
        this.minCenterXAdjust = Utilities.readWord(f);
        this.maxTopYAdjust = Utilities.readWord(f);
        this.maxAdvance[0] = Utilities.readWord(f);
        this.maxAdvance[1] = Utilities.readWord(f);
        this.maxSize[0] = Utilities.readWord(f);
        this.maxSize[1] = Utilities.readWord(f);
        this.maxGlyphWidth = Utilities.readUHalf(f);
        this.maxGlyphHeight = Utilities.readUHalf(f);
        Utilities.skipUnknown(f, 2);
        this.dimTableLength = Utilities.readUByte(f);
        this.xAdjustTableLength = Utilities.readUByte(f);
        this.yAdjustTableLength = Utilities.readUByte(f);
        this.advanceTableLength = Utilities.readUByte(f);
        Utilities.skipUnknown(f, 102);
        this.shadowMapLength = Utilities.readWord(f);
        this.shadowMapBpe = Utilities.readWord(f);
        Utilities.skipUnknown(f, 4);
        this.shadowScale[0] = Utilities.readWord(f);
        this.shadowScale[1] = Utilities.readWord(f);
        Utilities.skipUnknown(f, 8);
        if (this.revision == 3) {
            this.compCharMapBpe1 = Utilities.readWord(f);
            this.compCharMapLength1 = Utilities.readUHalf(f);
            Utilities.skipUnknown(f, 2);
            this.compCharMapBpe2 = Utilities.readWord(f);
            this.compCharMapLength2 = Utilities.readUHalf(f);
            Utilities.skipUnknown(f, 6);
        }
        this.dimensionTable = new int[2][this.dimTableLength];
        for (i3 = 0; i3 < this.dimTableLength; ++i3) {
            this.dimensionTable[0][i3] = Utilities.readWord(f);
            this.dimensionTable[1][i3] = Utilities.readWord(f);
        }
        this.xAdjustTable = new int[2][this.xAdjustTableLength];
        for (i3 = 0; i3 < this.xAdjustTableLength; ++i3) {
            this.xAdjustTable[0][i3] = Utilities.readWord(f);
            this.xAdjustTable[1][i3] = Utilities.readWord(f);
        }
        this.yAdjustTable = new int[2][this.yAdjustTableLength];
        for (i3 = 0; i3 < this.yAdjustTableLength; ++i3) {
            this.yAdjustTable[0][i3] = Utilities.readWord(f);
            this.yAdjustTable[1][i3] = Utilities.readWord(f);
        }
        this.advanceTable = new int[2][this.advanceTableLength];
        for (i3 = 0; i3 < this.advanceTableLength; ++i3) {
            this.advanceTable[0][i3] = Utilities.readWord(f);
            this.advanceTable[1][i3] = Utilities.readWord(f);
        }
        int shadowCharMapSize = (this.shadowMapLength * this.shadowMapBpe + 31 & 0xFFFFFFE0) / 8;
        this.shadowCharMap = new int[shadowCharMapSize];
        for (i2 = 0; i2 < shadowCharMapSize; ++i2) {
            this.shadowCharMap[i2] = Utilities.readUByte(f);
        }
        if (this.revision == 3) {
            this.charmapCompressionTable1 = new int[2][this.compCharMapLength1];
            for (i2 = 0; i2 < this.compCharMapLength1; ++i2) {
                this.charmapCompressionTable1[0][i2] = Utilities.readUHalf(f);
                this.charmapCompressionTable1[1][i2] = Utilities.readUHalf(f);
            }
            this.charmapCompressionTable2 = new int[2][this.compCharMapLength2];
            for (i2 = 0; i2 < this.compCharMapLength2; ++i2) {
                this.charmapCompressionTable2[0][i2] = Utilities.readUHalf(f);
                this.charmapCompressionTable2[1][i2] = Utilities.readUHalf(f);
            }
        }
        int charMapSize = (this.charMapLength * this.charMapBpe + 31 & 0xFFFFFFE0) / 8;
        this.charMap = new int[charMapSize];
        for (int i4 = 0; i4 < charMapSize; ++i4) {
            this.charMap[i4] = Utilities.readUByte(f);
        }
        int charPointerSize = (this.charPointerLength * this.charPointerBpe + 31 & 0xFFFFFFE0) / 8;
        this.charPointerTable = new int[charPointerSize];
        for (i = 0; i < charPointerSize; ++i) {
            this.charPointerTable[i] = Utilities.readUByte(f);
        }
        this.fontDataOffset = f.position();
        this.fontDataLength = f.capacity() - this.fontDataOffset;
        this.fontData = new int[this.fontDataLength];
        for (i = 0; i < this.fontDataLength; ++i) {
            this.fontData[i] = Utilities.readUByte(f);
        }
    }

    public void setFileNamez(String fileName) {
        this.fileNamez = fileName;
    }

    public String getFileNamez() {
        return this.fileNamez;
    }

    public String getPGFMagic() {
        return this.PGFMagic;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public int getRevision() {
        return this.revision;
    }

    public int getVersion() {
        return this.version;
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getFontType() {
        return this.fontType;
    }

    public int getFirstGlyphInCharMap() {
        return this.firstGlyph;
    }

    public int getLastGlyphInCharMap() {
        return this.lastGlyph;
    }

    public int getMaxGlyphWidth() {
        return this.maxGlyphWidth;
    }

    public int getMaxGlyphHeight() {
        return this.maxGlyphHeight;
    }

    public int[] getMaxSize() {
        return this.maxSize;
    }

    public int getMaxLeftXAdjust() {
        return this.maxLeftXAdjust;
    }

    public int getMinCenterXAdjust() {
        return this.minCenterXAdjust;
    }

    public int getMaxBaseYAdjust() {
        return this.maxBaseYAdjust;
    }

    public int getMaxTopYAdjust() {
        return this.maxTopYAdjust;
    }

    public int getCharMapLength() {
        return this.charMapLength;
    }

    public int getCharPointerLength() {
        return this.charPointerLength;
    }

    public int getShadowMapLength() {
        return this.shadowMapLength;
    }

    public int getCompCharMapLength() {
        return this.compCharMapLength1 + this.compCharMapLength2;
    }

    public int getCharMapBpe() {
        return this.charMapBpe;
    }

    public int getCharPointerBpe() {
        return this.charPointerBpe;
    }

    public int getShadowMapBpe() {
        return this.shadowMapBpe;
    }

    public int[] getMaxAdvance() {
        return this.maxAdvance;
    }

    public int[][] getAdvanceTable() {
        return this.advanceTable;
    }

    public int[] getCharMap() {
        return this.charMap;
    }

    public int[] getCharPointerTable() {
        return this.charPointerTable;
    }

    public int[][] getCharMapCompressionTable1() {
        return this.charmapCompressionTable1;
    }

    public int[][] getCharMapCompressionTable2() {
        return this.charmapCompressionTable2;
    }

    public int[] getShadowCharMap() {
        return this.shadowCharMap;
    }

    public int[] getShadowScale() {
        return this.shadowScale;
    }

    public int[] getFontdata() {
        return this.fontData;
    }

    public int getHSize() {
        return this.hSize;
    }

    public int getVSize() {
        return this.vSize;
    }

    public int getHResolution() {
        return this.hResolution;
    }

    public int getVResolution() {
        return this.vResolution;
    }

    public int getMaxAscender() {
        return this.maxAscender;
    }

    public int getMaxDescender() {
        return this.maxDescender;
    }

    public int getBpp() {
        return this.bpp;
    }

    public int getAdvanceTableLength() {
        return this.advanceTableLength;
    }

    public int[][] getDimensionTable() {
        return this.dimensionTable;
    }

    public int getDimensionTableLength() {
        return this.dimTableLength;
    }

    public int[][] getXAdjustTable() {
        return this.xAdjustTable;
    }

    public int getXAdjustTableLength() {
        return this.xAdjustTableLength;
    }

    public int[][] getYAdjustTable() {
        return this.yAdjustTable;
    }

    public int getYAdjustTableLength() {
        return this.yAdjustTableLength;
    }

    public SceFontInfo createFontInfo() {
        return new SceFontInfo(this);
    }

    @ISerializeStruct(size=264)
    public static class Info {
        public int maxGlyphWidthI;
        public int maxGlyphHeightI;
        public int maxGlyphAscenderI;
        public int maxGlyphDescenderI;
        public int maxGlyphLeftXI;
        public int maxGlyphBaseYI;
        public int minGlyphCenterXI;
        public int maxGlyphTopYI;
        public int maxGlyphAdvanceXI;
        public int maxGlyphAdvanceYI;
        public float maxGlyphWidthF;
        public float maxGlyphHeightF;
        public float maxGlyphAscenderF;
        public float maxGlyphDescenderF;
        public float maxGlyphLeftXF;
        public float maxGlyphBaseYF;
        public float minGlyphCenterXF;
        public float maxGlyphTopYF;
        public float maxGlyphAdvanceXF;
        public float maxGlyphAdvanceYF;
        public short maxGlyphWidth;
        public short maxGlyphHeight;
        public int charMapLength;
        public int shadowMapLength;
        public FontStyle fontStyle;
        public int Bpp = 4;
    }

    @ISerializeStruct(size=168)
    public static class FontStyle {
        public static final int FONT_FAMILY_SANS_SERIF = 1;
        public static final int FONT_FAMILY_SERIF = 2;
        public static final int FONT_STYLE_REGULAR = 1;
        public static final int FONT_STYLE_ITALIC = 2;
        public static final int FONT_STYLE_BOLD = 5;
        public static final int FONT_STYLE_BOLD_ITALIC = 6;
        public static final int FONT_STYLE_DB = 103;
        public static final int FONT_LANGUAGE_JAPANESE = 1;
        public static final int FONT_LANGUAGE_LATIN = 2;
        public static final int FONT_LANGUAGE_KOREAN = 3;
        public float fontH;
        public float fontV;
        public float fontHRes;
        public float fontVRes;
        public float fontWeight;
        public short fontFamily;
        public short fontStyle;
        public short fontStyleSub;
        public short fontLanguage;
        public short fontRegion;
        public short fontCountry;
        @ISerializeString(size=64)
        String fontName;
        public int fontAttributes;
        public int fontExpire;
    }
}

