/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.software;

import java.nio.Buffer;
import java.util.Comparator;
import java.util.HashMap;
import jpcsp.HLE.Modules;
import jpcsp.Memory;
import jpcsp.graphics.GeContext;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.software.CachedTextureResampled;
import jpcsp.graphics.RE.software.FilterCompiler;
import jpcsp.graphics.RE.software.IRandomTextureAccess;
import jpcsp.graphics.RE.software.IRenderer;
import jpcsp.graphics.RE.software.Lighting;
import jpcsp.graphics.RE.software.PixelColor;
import jpcsp.graphics.RE.software.RandomTextureAccessReader;
import jpcsp.graphics.RE.software.RendererTemplate;
import jpcsp.graphics.RE.software.TextureClip;
import jpcsp.graphics.VideoEngine;
import jpcsp.graphics.capture.CaptureManager;
import jpcsp.memory.FastMemory;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.ImageReader;
import jpcsp.util.LongLongKey;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public abstract class BaseRenderer
implements IRenderer {
    protected static final Logger log = VideoEngine.log;
    protected final boolean isLogTraceEnabled = log.isTraceEnabled();
    protected final boolean isLogDebugEnabled = log.isDebugEnabled();
    protected final boolean isLogInfoEnabled = log.isInfoEnabled();
    protected static final boolean captureEachPrimitive = false;
    protected static final boolean captureZbuffer = false;
    public static final int depthBufferPixelFormat = 6;
    protected static final int MAX_NUMBER_FILTERS = 15;
    public int[] memInt;
    public int imageWriterSkipEOL;
    public int depthWriterSkipEOL;
    protected RendererTemplate compiledRenderer;
    protected LongLongKey compiledRendererKey;
    protected LongLongKey baseRendererKey;
    protected boolean transform2D;
    protected int viewportWidth;
    protected int viewportHeight;
    protected int viewportX;
    protected int viewportY;
    protected int screenOffsetX;
    protected int screenOffsetY;
    protected float zscale;
    protected float zpos;
    public int nearZ;
    public int farZ;
    public int scissorX1;
    public int scissorY1;
    public int scissorX2;
    public int scissorY2;
    protected boolean setVertexPrimaryColor;
    protected int fbp;
    protected int fbw;
    protected int psm;
    protected int zbp;
    protected int zbw;
    protected boolean clearMode;
    protected boolean cullFaceEnabled;
    protected boolean frontFaceCw;
    protected boolean clipPlanesEnabled;
    protected boolean useVertexTexture;
    public IRandomTextureAccess textureAccess;
    protected int mipmapLevel = 0;
    public Lighting lighting;
    private static HashMap<LongLongKey, Integer> filtersStatistics = new HashMap();
    private static HashMap<LongLongKey, String> filterNames = new HashMap();
    protected boolean renderingInitialized;
    public CachedTextureResampled cachedTexture;
    protected boolean isTriangle;
    public int colorTestRef;
    public int colorTestMsk;
    public int alphaRef;
    public int stencilRef;
    public int stencilMask;
    public int sfix;
    public int dfix;
    public int colorMask;
    public boolean primaryColorSetGlobally;
    public float texTranslateX;
    public float texTranslateY;
    public float texScaleX = 1.0f;
    public float texScaleY = 1.0f;
    public int textureWidth;
    public int textureHeight;
    public int texEnvColorB;
    public int texEnvColorG;
    public int texEnvColorR;
    public float[] envMapLightPosU;
    public float[] envMapLightPosV;
    public boolean envMapDiffuseLightU;
    public boolean envMapDiffuseLightV;
    public float envMapShininess;
    public int texMinFilter;
    public int texMagFilter;
    public int primaryColor;
    public int[] ditherMatrix;

    protected void copy(BaseRenderer from) {
        this.imageWriterSkipEOL = from.imageWriterSkipEOL;
        this.depthWriterSkipEOL = from.depthWriterSkipEOL;
        this.compiledRendererKey = from.compiledRendererKey;
        this.compiledRenderer = from.compiledRenderer;
        this.lighting = from.lighting;
        this.textureAccess = from.textureAccess;
        this.memInt = from.memInt;
        this.transform2D = from.transform2D;
        this.nearZ = from.nearZ;
        this.farZ = from.farZ;
        this.scissorX1 = from.scissorX1;
        this.scissorY1 = from.scissorY1;
        this.scissorX2 = from.scissorX2;
        this.scissorY2 = from.scissorY2;
        this.cachedTexture = from.cachedTexture;
        this.isTriangle = from.isTriangle;
        this.colorTestRef = from.colorTestRef;
        this.colorTestMsk = from.colorTestMsk;
        this.alphaRef = from.alphaRef;
        this.stencilRef = from.stencilRef;
        this.stencilMask = from.stencilMask;
        this.sfix = from.sfix;
        this.dfix = from.dfix;
        this.colorMask = from.colorMask;
        this.primaryColorSetGlobally = from.primaryColorSetGlobally;
        this.texTranslateX = from.texTranslateX;
        this.texTranslateY = from.texTranslateY;
        this.texScaleX = from.texScaleX;
        this.texScaleY = from.texScaleY;
        this.textureWidth = from.textureWidth;
        this.textureHeight = from.textureHeight;
        this.texEnvColorB = from.texEnvColorB;
        this.texEnvColorG = from.texEnvColorG;
        this.texEnvColorR = from.texEnvColorR;
        this.envMapLightPosU = from.envMapLightPosU;
        this.envMapLightPosV = from.envMapLightPosV;
        this.envMapDiffuseLightU = from.envMapDiffuseLightU;
        this.envMapDiffuseLightV = from.envMapDiffuseLightV;
        this.envMapShininess = from.envMapShininess;
        this.texMinFilter = from.texMinFilter;
        this.texMagFilter = from.texMagFilter;
        this.primaryColor = from.primaryColor;
        this.ditherMatrix = from.ditherMatrix;
    }

    protected BaseRenderer() {
    }

    protected int getTextureAddress(int address, int x, int y, int textureWidth, int pixelFormat) {
        int bytesPerPixel = IRenderingEngine.sizeOfTextureType[pixelFormat];
        int numberOfPixels = y * textureWidth + x;
        return (address &= 0x3FFFFFFF) + (bytesPerPixel == 0 ? numberOfPixels >> 1 : numberOfPixels * bytesPerPixel);
    }

    private static int getFrameBufferAddress(int addr) {
        if ((addr &= 0x3FFFFFFF) < 0x4000000) {
            addr += 0x4000000;
        }
        return addr;
    }

    protected void init(GeContext context, CachedTextureResampled texture, boolean useVertexTexture, boolean isTriangle) {
        this.cachedTexture = texture;
        this.useVertexTexture = useVertexTexture;
        this.isTriangle = isTriangle;
        this.nearZ = context.nearZ;
        this.farZ = context.farZ;
        this.scissorX1 = context.scissor_x1;
        this.scissorY1 = context.scissor_y1;
        this.scissorX2 = context.scissor_x2;
        this.scissorY2 = context.scissor_y2;
        this.clearMode = context.clearMode;
        this.cullFaceEnabled = context.cullFaceFlag.isEnabled();
        this.frontFaceCw = context.frontFaceCw;
        this.clipPlanesEnabled = context.clipPlanesFlag.isEnabled();
        this.fbw = context.fbw;
        this.zbw = context.zbw;
        if (context.ditherFlag.isEnabled()) {
            this.ditherMatrix = (int[])context.dither_matrix.clone();
        }
        this.transform2D = context.vinfo.transform2D;
        if (!this.transform2D) {
            this.viewportWidth = context.viewport_width;
            this.viewportHeight = context.viewport_height;
            this.viewportX = context.viewport_cx;
            this.viewportY = context.viewport_cy;
            this.screenOffsetX = context.offset_x;
            this.screenOffsetY = context.offset_y;
            this.zscale = context.zscale;
            this.zpos = context.zpos;
            if (context.tex_map_mode == 0) {
                this.texTranslateX = context.tex_translate_x;
                this.texTranslateY = context.tex_translate_y;
                this.texScaleX = context.tex_scale_x;
                this.texScaleY = context.tex_scale_y;
            } else if (context.tex_map_mode == 2) {
                this.envMapLightPosU = new float[4];
                this.envMapLightPosV = new float[4];
                Utilities.copy(this.envMapLightPosU, context.light_pos[context.tex_shade_u]);
                Utilities.copy(this.envMapLightPosV, context.light_pos[context.tex_shade_v]);
                this.envMapDiffuseLightU = context.light_type[context.tex_shade_u] == 0;
                this.envMapDiffuseLightV = context.light_type[context.tex_shade_v] == 0;
                this.envMapShininess = context.materialShininess;
            }
        }
        if (this.isLogTraceEnabled) {
            log.trace((Object)String.format("Context: %s", context.toString()));
        }
    }

    protected boolean isUsingTexture(GeContext context) {
        return context.textureFlag.isEnabled() && (!this.transform2D || this.useVertexTexture) && !this.clearMode;
    }

    protected void initRendering(GeContext context) {
        if (this.renderingInitialized) {
            return;
        }
        this.fbp = BaseRenderer.getFrameBufferAddress(context.fbp);
        this.psm = context.psm;
        this.zbp = BaseRenderer.getFrameBufferAddress(context.zbp);
        this.colorTestRef = PixelColor.getColorBGR(context.colorTestRef);
        this.colorTestMsk = PixelColor.getColorBGR(context.colorTestMsk);
        this.alphaRef = context.alphaRef;
        this.stencilRef = context.stencilRef;
        this.stencilMask = context.stencilMask;
        this.sfix = context.sfix;
        this.dfix = context.dfix;
        this.colorMask = PixelColor.getColor(context.colorMask);
        this.textureWidth = context.texture_width[this.mipmapLevel];
        this.textureHeight = context.texture_height[this.mipmapLevel];
        this.texEnvColorB = PixelColor.getColor(context.tex_env_color[2]);
        this.texEnvColorG = PixelColor.getColor(context.tex_env_color[1]);
        this.texEnvColorR = PixelColor.getColor(context.tex_env_color[0]);
        this.texMinFilter = context.tex_min_filter;
        this.texMagFilter = context.tex_mag_filter;
        this.primaryColor = PixelColor.getColor(context.vertexColor);
        Memory mem = Memory.getInstance();
        if (mem instanceof FastMemory) {
            this.memInt = ((FastMemory)mem).getAll();
        }
        this.baseRendererKey = this.getBaseRendererKey(context);
        if (!this.transform2D && context.lightingFlag.isEnabled()) {
            this.lighting = new Lighting(context.view_uploaded_matrix, context.mat_emissive, context.ambient_light, context.lightFlags, context.light_pos, context.light_kind, context.light_type, context.lightAmbientColor, context.lightDiffuseColor, context.lightSpecularColor, context.lightConstantAttenuation, context.lightLinearAttenuation, context.lightQuadraticAttenuation, context.spotLightCutoff, context.spotLightCosCutoff, context.light_dir, context.spotLightExponent, context.materialShininess, context.lightMode, context.vinfo.normal != 0);
        }
        if (!this.transform2D && context.lightingFlag.isEnabled() && context.mat_flags != 0 && context.useVertexColor && context.vinfo.color != 0 && this.isTriangle) {
            this.setVertexPrimaryColor = true;
        }
        this.primaryColorSetGlobally = false;
        if (this.transform2D || !context.lightingFlag.isEnabled()) {
            if (context.useVertexColor && context.vinfo.color != 0) {
                this.setVertexPrimaryColor = true;
                if (!this.isTriangle) {
                    this.primaryColorSetGlobally = true;
                }
            } else {
                this.primaryColorSetGlobally = true;
            }
        }
        this.textureAccess = null;
        if (this.isUsingTexture(context)) {
            int textureBufferWidth = VideoEngine.alignBufferWidth(context.texture_buffer_width[this.mipmapLevel], context.texture_storage);
            int textureHeight = context.texture_height[this.mipmapLevel];
            int textureAddress = context.texture_base_pointer[this.mipmapLevel];
            if (this.cachedTexture == null) {
                int[] clut32 = VideoEngine.getInstance().readClut32(this.mipmapLevel);
                short[] clut16 = VideoEngine.getInstance().readClut16(this.mipmapLevel);
                IMemoryReader imageReader = ImageReader.getImageReader(textureAddress, textureBufferWidth, textureHeight, textureBufferWidth, context.texture_storage, context.texture_swizzle, context.tex_clut_addr, context.tex_clut_mode, context.tex_clut_num_blocks, context.tex_clut_start, context.tex_clut_shift, context.tex_clut_mask, clut32, clut16);
                this.textureAccess = new RandomTextureAccessReader(imageReader, textureBufferWidth, textureHeight);
            } else {
                this.textureAccess = this.cachedTexture.getOriginalTexture();
            }
            this.textureAccess = TextureClip.getTextureClip(context, this.mipmapLevel, this.textureAccess, textureBufferWidth, textureHeight);
        }
        this.renderingInitialized = true;
    }

    private LongLongKey getBaseRendererKey(GeContext context) {
        LongLongKey key = new LongLongKey();
        key.addKeyComponent(this.memInt != null);
        key.addKeyComponent(this.transform2D);
        key.addKeyComponent(this.clearMode);
        if (this.clearMode) {
            key.addKeyComponent(context.clearModeColor);
            key.addKeyComponent(context.clearModeStencil);
            key.addKeyComponent(context.clearModeDepth);
        } else {
            key.addKeyComponent(false);
            key.addKeyComponent(false);
            key.addKeyComponent(false);
        }
        key.addKeyComponent(this.nearZ == 0);
        key.addKeyComponent(this.farZ == 65535);
        key.addKeyComponent(context.colorTestFlag.isEnabled() ? context.colorTestFunc : 1, 2);
        if (context.alphaTestFlag.isEnabled()) {
            key.addKeyComponent(context.alphaFunc, 3);
            key.addKeyComponent(context.alphaRef == 0);
            key.addKeyComponent(context.alphaRef == 255);
        } else {
            key.addKeyComponent(1, 3);
            key.addKeyComponent(false);
            key.addKeyComponent(false);
        }
        if (context.stencilTestFlag.isEnabled()) {
            key.addKeyComponent(context.stencilFunc, 3);
            key.addKeyComponent(context.stencilOpFail, 3);
            key.addKeyComponent(context.stencilOpZFail, 3);
            key.addKeyComponent(context.stencilOpZPass, 3);
        } else {
            key.addKeyComponent(1, 3);
            key.addKeyComponent(7, 3);
            key.addKeyComponent(7, 3);
            key.addKeyComponent(7, 3);
        }
        key.addKeyComponent(context.depthTestFlag.isEnabled() ? context.depthFunc : 1, 3);
        if (context.blendFlag.isEnabled()) {
            key.addKeyComponent(context.blendEquation, 3);
            key.addKeyComponent(context.blend_src, 4);
            key.addKeyComponent(context.blend_dst, 4);
            key.addKeyComponent(context.sfix == 0);
            key.addKeyComponent(context.sfix == 0xFFFFFF);
            key.addKeyComponent(context.dfix == 0);
            key.addKeyComponent(context.dfix == 0xFFFFFF);
        } else {
            key.addKeyComponent(7, 3);
            key.addKeyComponent(15, 4);
            key.addKeyComponent(15, 4);
            key.addKeyComponent(false);
            key.addKeyComponent(false);
            key.addKeyComponent(false);
            key.addKeyComponent(false);
        }
        key.addKeyComponent(context.colorLogicOpFlag.isEnabled() ? context.logicOp : 3, 4);
        key.addKeyComponent(PixelColor.getColor(context.colorMask) == 0);
        key.addKeyComponent(context.depthMask);
        key.addKeyComponent(context.textureFlag.isEnabled());
        key.addKeyComponent(this.useVertexTexture);
        key.addKeyComponent(context.lightingFlag.isEnabled());
        key.addKeyComponent(this.setVertexPrimaryColor);
        key.addKeyComponent(this.primaryColorSetGlobally);
        key.addKeyComponent(this.isTriangle);
        key.addKeyComponent(context.mat_flags, 3);
        key.addKeyComponent(context.useVertexColor);
        key.addKeyComponent(context.textureColorDoubled);
        key.addKeyComponent(context.lightMode, 1);
        key.addKeyComponent(context.tex_map_mode, 2);
        if (context.tex_map_mode == 1) {
            key.addKeyComponent(context.tex_proj_map_mode, 2);
        } else {
            key.addKeyComponent(0, 2);
        }
        key.addKeyComponent(context.tex_translate_x == 0.0f);
        key.addKeyComponent(context.tex_translate_y == 0.0f);
        key.addKeyComponent(context.tex_scale_x == 1.0f);
        key.addKeyComponent(context.tex_scale_y == 1.0f);
        key.addKeyComponent(context.tex_wrap_s, 1);
        key.addKeyComponent(context.tex_wrap_t, 1);
        key.addKeyComponent(context.textureFunc, 3);
        key.addKeyComponent(context.textureAlphaUsed);
        key.addKeyComponent(context.psm, 2);
        key.addKeyComponent(context.tex_min_filter, 3);
        key.addKeyComponent(context.tex_mag_filter, 1);
        key.addKeyComponent(this.isLogTraceEnabled);
        key.addKeyComponent(false);
        key.addKeyComponent(context.ditherFlag.isEnabled());
        return key;
    }

    protected void preRender() {
    }

    protected void postRender() {
    }

    protected void captureZbufferImage() {
        GeContext context = VideoEngine.getInstance().getContext();
        int width = context.zbw;
        int height = Modules.sceDisplayModule.getHeightFb();
        int address = this.getTextureAddress(this.zbp, 0, 0, this.zbw, 6);
        Buffer buffer = Memory.getInstance().getBuffer(address, width * height * IRenderingEngine.sizeOfTextureType[6]);
        CaptureManager.captureImage(address, 0, buffer, width, height, width, 6, false, 0, false, false);
    }

    protected void statisticsFilters(int numberPixels) {
    }

    public static void exit() {
        if (log.isInfoEnabled()) {
            // empty if block
        }
        FilterCompiler.exit();
    }

    private static class FilterComparator
    implements Comparator<LongLongKey> {
        private FilterComparator() {
        }

        @Override
        public int compare(LongLongKey o1, LongLongKey o2) {
            return ((Integer)filtersStatistics.get(o1)).compareTo((Integer)filtersStatistics.get(o2));
        }
    }
}

