/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.software;

import java.util.LinkedList;
import jpcsp.graphics.RE.software.CachedTexture;
import jpcsp.graphics.RE.software.PixelColor;
import jpcsp.graphics.RE.software.RESoftware;
import jpcsp.graphics.VideoEngine;
import jpcsp.util.Utilities;

public class CachedTextureResampled {
    private static final boolean disableResampleAllTextures = false;
    private static final boolean disableResampleVRAMTexture = true;
    protected LinkedList<ResampleInfo> resampleInfos = new LinkedList();
    protected CachedTexture cachedTextureOriginal;

    public CachedTextureResampled(CachedTexture cachedTexture) {
        this.cachedTextureOriginal = cachedTexture;
        ResampleInfo resampleInfo = new ResampleInfo(cachedTexture.width, cachedTexture.height, cachedTexture);
        this.resampleInfos.add(resampleInfo);
    }

    public CachedTexture getOriginalTexture() {
        return this.cachedTextureOriginal;
    }

    public boolean canResample(float widthFactor, float heightFactor) {
        if (this.cachedTextureOriginal.isVRAMTexture()) {
            return widthFactor == 0.5f && heightFactor == 0.5f || widthFactor == 2.0f && heightFactor == 2.0f;
        }
        return widthFactor >= 0.5f && heightFactor >= 0.5f && widthFactor <= 2.0f && heightFactor <= 2.0f;
    }

    public CachedTexture resample(float widthFactor, float heightFactor) {
        if (widthFactor == 1.0f && heightFactor == 1.0f) {
            return this.cachedTextureOriginal;
        }
        int width = Utilities.round(widthFactor * (float)this.cachedTextureOriginal.width);
        int height = Utilities.round(heightFactor * (float)this.cachedTextureOriginal.height);
        return this.resample(width, height);
    }

    private synchronized CachedTexture resample(int width, int height) {
        for (ResampleInfo resampleInfo : this.resampleInfos) {
            if (!resampleInfo.matches(width, height)) continue;
            return resampleInfo.getCachedTextureResampled();
        }
        return this.resampleTexture(width, height);
    }

    private CachedTexture resampleTexture(int width, int height) {
        if (this.resampleInfos.size() >= 5 && VideoEngine.log.isInfoEnabled()) {
            VideoEngine.log.info((Object)String.format("Resampling texture from (%d,%d) to (%d,%d), pixelFormat=%d, resampled %d times", this.cachedTextureOriginal.width, this.cachedTextureOriginal.height, width, height, this.cachedTextureOriginal.pixelFormat, this.resampleInfos.size()));
        } else if (VideoEngine.log.isDebugEnabled()) {
            VideoEngine.log.debug((Object)String.format("Resampling texture from (%d,%d) to (%d,%d), pixelFormat=%d, resampled %d times", this.cachedTextureOriginal.width, this.cachedTextureOriginal.height, width, height, this.cachedTextureOriginal.pixelFormat, this.resampleInfos.size()));
        }
        RESoftware.textureResamplingStatistics.start();
        int widthPow2 = Utilities.makePow2(width);
        int heightPow2 = Utilities.makePow2(height);
        int[] buffer = new int[widthPow2 * heightPow2];
        int widthSkipEOL = widthPow2 - width;
        if (this.cachedTextureOriginal.width == width << 1 && this.cachedTextureOriginal.height == height << 1) {
            this.resampleTextureMinimize2(buffer, width, height, widthSkipEOL);
        } else if (this.cachedTextureOriginal.width << 1 == width && this.cachedTextureOriginal.height << 1 == height) {
            this.resampleTextureMagnify2(buffer, width, height, widthSkipEOL);
        } else {
            float widthFactor = (float)this.cachedTextureOriginal.width / (float)width;
            float heightFactor = (float)this.cachedTextureOriginal.height / (float)height;
            this.resampleTexture(buffer, width, height, widthSkipEOL, widthFactor, heightFactor);
        }
        CachedTexture.CachedTexturePow2 cachedTextureResampled = new CachedTexture.CachedTexturePow2(widthPow2, heightPow2, width, height, 3);
        cachedTextureResampled.setBuffer(buffer, 0, buffer.length);
        ResampleInfo resampleInfo = new ResampleInfo(width, height, cachedTextureResampled);
        this.resampleInfos.add(resampleInfo);
        RESoftware.textureResamplingStatistics.end();
        return cachedTextureResampled;
    }

    private void resampleTexture(int[] buffer, int width, int height, int widthSkipEOL, float widthFactor, float heightFactor) {
        float v = 0.0f;
        int index = 0;
        for (int y = 0; y < height; ++y) {
            float u = 0.0f;
            for (int x = 0; x < width; ++x) {
                buffer[index++] = this.readTexturePixelInterpolated(u, v, widthFactor, heightFactor);
                u += widthFactor;
            }
            index += widthSkipEOL;
            v += heightFactor;
        }
    }

    private void resampleTextureMinimize2(int[] buffer, int width, int height, int widthSkipEOL) {
        int index = 0;
        int y = 0;
        int v = 0;
        while (y < height) {
            int x = 0;
            int u = 0;
            while (x < width) {
                int pixel = PixelColor.divideBy4(this.cachedTextureOriginal.readPixel(u, v));
                pixel += PixelColor.divideBy4(this.cachedTextureOriginal.readPixel(u + 1, v));
                pixel += PixelColor.divideBy4(this.cachedTextureOriginal.readPixel(u, v + 1));
                buffer[index++] = pixel += PixelColor.divideBy4(this.cachedTextureOriginal.readPixel(u + 1, v + 1));
                ++x;
                u += 2;
            }
            index += widthSkipEOL;
            ++y;
            v += 2;
        }
    }

    private void resampleTextureMagnify2(int[] buffer, int width, int height, int widthSkipEOL) {
        int pixel;
        int index = 0;
        int lastU = (width -= 2) / 2;
        int lastV = (height -= 2) / 2;
        int y = 0;
        int v = 0;
        while (y < height) {
            int currentPixel = this.cachedTextureOriginal.readPixel(0, v);
            int x = 0;
            int u = 1;
            while (x < width) {
                buffer[index++] = currentPixel;
                pixel = PixelColor.divideBy2(currentPixel);
                currentPixel = this.cachedTextureOriginal.readPixel(u, v);
                buffer[index++] = pixel += PixelColor.divideBy2(currentPixel);
                x += 2;
                ++u;
            }
            int pixelLastU = this.cachedTextureOriginal.readPixel(lastU, v);
            buffer[index++] = pixelLastU;
            buffer[index++] = pixelLastU;
            index += widthSkipEOL;
            int x2 = 0;
            int u2 = 0;
            while (x2 < width) {
                pixel = PixelColor.divideBy2(this.cachedTextureOriginal.readPixel(u2, v));
                buffer[index++] = pixel += PixelColor.divideBy2(this.cachedTextureOriginal.readPixel(u2, v + 1));
                pixel = PixelColor.divideBy2(pixel);
                pixel += PixelColor.divideBy4(this.cachedTextureOriginal.readPixel(u2 + 1, v));
                buffer[index++] = pixel += PixelColor.divideBy4(this.cachedTextureOriginal.readPixel(u2 + 1, v + 1));
                x2 += 2;
                ++u2;
            }
            pixel = PixelColor.divideBy2(pixelLastU);
            buffer[index++] = pixel += PixelColor.divideBy2(this.cachedTextureOriginal.readPixel(lastU, v + 1));
            buffer[index++] = pixel;
            index += widthSkipEOL;
            y += 2;
            ++v;
        }
        int currentPixel = this.cachedTextureOriginal.readPixel(0, lastV);
        int index2 = index + width + widthSkipEOL + 2;
        int x = 0;
        int u = 0;
        while (x < width) {
            buffer[index++] = currentPixel;
            buffer[index2++] = currentPixel;
            pixel = PixelColor.divideBy2(currentPixel);
            currentPixel = this.cachedTextureOriginal.readPixel(u, lastV);
            buffer[index++] = pixel += PixelColor.divideBy2(currentPixel);
            buffer[index2++] = pixel;
            x += 2;
            ++u;
        }
        int pixelLastU = this.cachedTextureOriginal.readPixel(lastU, lastV);
        buffer[index++] = pixelLastU;
        buffer[index] = pixelLastU;
        buffer[index2++] = pixelLastU;
        buffer[index2] = pixelLastU;
    }

    private int readTexturePixelInterpolated(float u, float v, float widthFactor, float heightFactor) {
        int texelU0 = Utilities.pixelToTexel(u);
        int texelV0 = Utilities.pixelToTexel(v);
        int texelU1 = texelU0 + 1;
        int texelV1 = texelV0 + 1;
        if (texelU1 >= this.cachedTextureOriginal.width) {
            texelU1 = texelU0;
        }
        if (texelV1 >= this.cachedTextureOriginal.height) {
            texelV1 = texelV0;
        }
        float factorU1 = u - (float)texelU0;
        float factorV1 = v - (float)texelV0;
        float factorU0 = 1.0f - factorU1;
        float factorV0 = 1.0f - factorV1;
        if (factorU1 == 0.0f && widthFactor > 1.0f) {
            factorU1 = (widthFactor - 1.0f) / widthFactor;
            factorU0 = 1.0f / widthFactor;
        }
        if (factorV1 == 0.0f && heightFactor > 1.0f) {
            factorV1 = (heightFactor - 1.0f) / heightFactor;
            factorV0 = 1.0f / heightFactor;
        }
        int pixel = factorU0 > 0.0f && factorV0 > 0.0f ? PixelColor.multiply(this.cachedTextureOriginal.readPixel(texelU0, texelV0), factorU0 * factorV0) : 0;
        if (factorU1 > 0.0f && factorV0 > 0.0f) {
            pixel += PixelColor.multiply(this.cachedTextureOriginal.readPixel(texelU1, texelV0), factorU1 * factorV0);
        }
        if (factorU0 > 0.0f && factorV1 > 0.0f) {
            pixel += PixelColor.multiply(this.cachedTextureOriginal.readPixel(texelU0, texelV1), factorU0 * factorV1);
        }
        if (factorU1 > 0.0f && factorV1 > 0.0f) {
            pixel += PixelColor.multiply(this.cachedTextureOriginal.readPixel(texelU1, texelV1), factorU1 * factorV1);
        }
        return pixel;
    }

    public void setClut() {
        this.cachedTextureOriginal.setClut();
    }

    private static class ResampleInfo {
        private int resampleWidth;
        private int resampleHeight;
        private CachedTexture cachedTextureResampled;

        public ResampleInfo(int resampleWidth, int resampleHeight, CachedTexture cachedTextureResampled) {
            this.resampleWidth = resampleWidth;
            this.resampleHeight = resampleHeight;
            this.cachedTextureResampled = cachedTextureResampled;
        }

        public boolean matches(int width, int height) {
            return width == this.resampleWidth && height == this.resampleHeight;
        }

        public CachedTexture getCachedTextureResampled() {
            return this.cachedTextureResampled;
        }
    }
}

