/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.VertexArrayManager;
import jpcsp.graphics.VertexBuffer;
import jpcsp.graphics.VideoEngine;
import jpcsp.util.CpuDurationStatistics;

public class VertexBufferManager {
    private static VertexBufferManager instance;
    private static final int maxSize = 1000;
    private List<VertexBuffer> vertexBuffers = new LinkedList<VertexBuffer>();
    private static final int allowedVertexGapSize = 4096;
    private CpuDurationStatistics statistics = new CpuDurationStatistics("VertexBufferManager");
    private HashMap<Integer, VertexBuffer> fastLookup = new HashMap();

    public static VertexBufferManager getInstance() {
        if (instance == null) {
            instance = new VertexBufferManager();
        }
        return instance;
    }

    public static void exit() {
        if (instance != null) {
            // empty if block
        }
    }

    private static int getFastLookupKey(int address, int length) {
        return address;
    }

    private static int getFastLookupKey(int address, int length, int stride) {
        return address + (stride << 24);
    }

    public synchronized VertexBuffer getVertexBuffer(IRenderingEngine re, int address, int length, int stride, boolean strideAligned) {
        VertexBuffer vertexBuffer;
        int fastLookupKey;
        this.statistics.start();
        if (strideAligned) {
            fastLookupKey = VertexBufferManager.getFastLookupKey(address, length, stride);
            vertexBuffer = this.fastLookup.get(fastLookupKey);
            if (vertexBuffer != null && stride == vertexBuffer.getStride() && vertexBuffer.getBufferOffset(address) % stride == 0 && vertexBuffer.isAddressInside(address, length, 4096)) {
                this.statistics.end();
                return vertexBuffer;
            }
            boolean first = true;
            ListIterator<VertexBuffer> lit = this.vertexBuffers.listIterator();
            while (lit.hasNext()) {
                vertexBuffer = lit.next();
                if (stride == vertexBuffer.getStride() && vertexBuffer.getBufferOffset(address) % stride == 0 && vertexBuffer.isAddressInside(address, length, 4096)) {
                    if (!first) {
                        lit.remove();
                        this.vertexBuffers.add(0, vertexBuffer);
                    }
                    this.fastLookup.put(fastLookupKey, vertexBuffer);
                    this.statistics.end();
                    return vertexBuffer;
                }
                first = false;
            }
        } else {
            fastLookupKey = VertexBufferManager.getFastLookupKey(address, length);
            vertexBuffer = this.fastLookup.get(fastLookupKey);
            if (vertexBuffer != null && vertexBuffer.isAddressInside(address, length, 4096)) {
                this.statistics.end();
                return vertexBuffer;
            }
            boolean first = true;
            ListIterator<VertexBuffer> lit = this.vertexBuffers.listIterator();
            while (lit.hasNext()) {
                vertexBuffer = lit.next();
                if (vertexBuffer.isAddressInside(address, length, 4096)) {
                    if (!first) {
                        lit.remove();
                        this.vertexBuffers.add(0, vertexBuffer);
                    }
                    this.fastLookup.put(fastLookupKey, vertexBuffer);
                    this.statistics.end();
                    return vertexBuffer;
                }
                first = false;
            }
        }
        VertexBuffer vertexBuffer2 = new VertexBuffer(address, stride);
        this.vertexBuffers.add(0, vertexBuffer2);
        if (this.vertexBuffers.size() > 1000 && re != null) {
            VertexBuffer toBeDeleted = this.vertexBuffers.remove(this.vertexBuffers.size() - 1);
            if (re.isVertexArrayAvailable()) {
                VertexArrayManager.getInstance().onVertexBufferDeleted(re, toBeDeleted);
            }
            toBeDeleted.delete(re);
        }
        this.statistics.end();
        return vertexBuffer2;
    }

    public synchronized void forceReloadAllVertexBuffers() {
        for (VertexBuffer vertexBuffer : this.vertexBuffers) {
            vertexBuffer.forceReload();
        }
    }

    public synchronized void resetAddressAlreadyChecked() {
        for (VertexBuffer vertexBuffer : this.vertexBuffers) {
            vertexBuffer.resetAddressAlreadyChecked();
        }
    }

    protected void displayStatistics() {
        int length = 0;
        for (VertexBuffer vertexBuffer : this.vertexBuffers) {
            VideoEngine.log.info((Object)vertexBuffer);
            length += vertexBuffer.getLength();
        }
        VideoEngine.log.info((Object)String.format("VertexBufferManager: %d buffers, total length %d", this.vertexBuffers.size(), length));
    }

    public synchronized void reset(IRenderingEngine re) {
        ListIterator<VertexBuffer> lit = this.vertexBuffers.listIterator();
        while (lit.hasNext()) {
            VertexBuffer vertexBuffer = lit.next();
            vertexBuffer.delete(re);
            lit.remove();
        }
    }
}

