/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.HLE.Modules;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.MemoryVirtualFile;
import jpcsp.HLE.VFS.local.LocalVirtualFile;
import jpcsp.connector.AtracCodec;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.filesystems.SeekableRandomFile;
import jpcsp.format.psmf.PsmfAudioDemuxVirtualFile;
import jpcsp.media.MediaEngine;
import jpcsp.media.OMAFormat;
import jpcsp.media.PacketChannel;
import jpcsp.media.StreamReader;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.Settings;
import jpcsp.util.FileLocator;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class ExternalDecoder {
    private static Logger log = Modules.log;
    private static File extAudioDecoder;
    private static boolean enabled;
    private static boolean dumpAt3File;
    private static boolean dumpAudioStreamFile;
    private static boolean keepOmaFile;
    private static EnableExternalDecoderSettingsListerner enableExternalDecoderSettingsListerner;

    public ExternalDecoder() {
        ExternalDecoder.init();
    }

    private static void setEnabled(boolean flag) {
        enabled = flag;
    }

    private static void init() {
        if (enableExternalDecoderSettingsListerner == null) {
            enableExternalDecoderSettingsListerner = new EnableExternalDecoderSettingsListerner();
            Settings.getInstance().registerSettingsListener("ExternalDecoder", "emu.useExternalDecoder", enableExternalDecoderSettingsListerner);
        }
        if (enabled && extAudioDecoder == null) {
            String extAudioDecoderPath = System.getProperty("java.library.path");
            if (extAudioDecoderPath == null) {
                extAudioDecoderPath = "";
            } else if (!extAudioDecoderPath.endsWith("/")) {
                extAudioDecoderPath = extAudioDecoderPath + "/";
            }
            String[] extAudioDecoders = new String[]{"DecodeAudio.bat", "DecodeAudio.exe", "DecodeAudio.sh"};
            for (int i = 0; i < extAudioDecoders.length; ++i) {
                File f = new File(String.format("%s%s", extAudioDecoderPath, extAudioDecoders[i]));
                if (!f.exists()) continue;
                extAudioDecoder = f;
                break;
            }
            if (extAudioDecoder == null) {
                enabled = false;
            } else {
                log.info((Object)"Using the external audio decoder (SonicStage)");
            }
        }
        if (enabled) {
            FileLocator.getInstance();
        }
    }

    public static boolean isEnabled() {
        ExternalDecoder.init();
        return enabled;
    }

    private boolean executeExternalDecoder(String inputFileName, String outputFileName, String at3FileName, boolean keepInputFile) {
        File outputFile;
        boolean decoded = this.executeExternalDecoder(inputFileName, outputFileName, at3FileName);
        if (!keepInputFile) {
            File inputFile = new File(inputFileName);
            inputFile.delete();
            if (at3FileName != null) {
                File at3File = new File(at3FileName);
                at3File.delete();
            }
        }
        if ((outputFile = new File(outputFileName)).canRead() && outputFile.length() == 0L) {
            outputFile.delete();
            decoded = false;
        }
        return decoded;
    }

    private boolean executeExternalDecoder(String inputFileName, String outputFileName, String at3FileName) {
        if (at3FileName == null) {
            at3FileName = "";
        }
        String[] cmd = extAudioDecoder.toString().endsWith(".bat") ? new String[]{"cmd", "/C", extAudioDecoder.toString(), inputFileName, outputFileName, at3FileName} : new String[]{extAudioDecoder.toString(), inputFileName, outputFileName, at3FileName};
        try {
            Process extAudioDecodeProcess = Runtime.getRuntime().exec(cmd);
            StreamReader stdoutReader = new StreamReader(extAudioDecodeProcess.getInputStream());
            StreamReader stderrReader = new StreamReader(extAudioDecodeProcess.getErrorStream());
            stdoutReader.start();
            stderrReader.start();
            int exitValue = extAudioDecodeProcess.waitFor();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("External AudioDecode Process '%s' returned %d", extAudioDecoder.toString(), exitValue));
                log.debug((Object)("stdout: " + stdoutReader.getInput()));
                log.debug((Object)("stderr: " + stderrReader.getInput()));
            }
        }
        catch (InterruptedException e) {
            log.error((Object)e);
            return false;
        }
        catch (IOException e) {
            log.error((Object)e);
            return false;
        }
        return true;
    }

    private boolean decodeExtAudio(byte[] audioStreamData, int mpegFileSize, int mpegOffset, int audioChannel, long lastTimestamp) {
        ByteBuffer audioStream;
        ByteBuffer omaBuffer;
        if (audioStreamData == null) {
            return false;
        }
        if (dumpAudioStreamFile) {
            try {
                new File(MediaEngine.getExtAudioBasePath(mpegFileSize, lastTimestamp)).mkdirs();
                FileOutputStream pmfOut = new FileOutputStream(MediaEngine.getExtAudioPath(mpegFileSize, audioChannel, lastTimestamp, "audio"));
                pmfOut.write(audioStreamData);
                pmfOut.close();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        if ((omaBuffer = OMAFormat.convertStreamToOMA(audioStream = ByteBuffer.wrap(audioStreamData))) == null) {
            return false;
        }
        try {
            new File(MediaEngine.getExtAudioBasePath(mpegFileSize, lastTimestamp)).mkdirs();
            String encodedFileName = MediaEngine.getExtAudioPath(mpegFileSize, audioChannel, lastTimestamp, "oma");
            FileOutputStream os = new FileOutputStream(encodedFileName);
            os.getChannel().write(omaBuffer);
            os.close();
            String decodedFileName = MediaEngine.getExtAudioPath(mpegFileSize, audioChannel, lastTimestamp, "wav");
            if (!this.executeExternalDecoder(encodedFileName, decodedFileName, null, keepOmaFile)) {
                int channels = OMAFormat.getOMANumberAudioChannels(omaBuffer);
                if (channels == 1) {
                    log.info((Object)"Mono AT3+ audio stream could not be decoded by the external decoder");
                } else if (channels == 2) {
                    log.info((Object)"Stereo AT3+ audio stream could not be decoded by the external decoder");
                } else {
                    log.info((Object)("AT3+ audio stream could not be decoded by the external decoder (channels=" + channels + ")"));
                }
                return false;
            }
        }
        catch (IOException e) {
            log.error((Object)e);
            return false;
        }
        return true;
    }

    public void decodeExtAudio(IVirtualFile vFilePsmf, int mpegFileSize, int mpegOffset, int audioChannel, long lastTimestamp) {
        if (!ExternalDecoder.isEnabled()) {
            return;
        }
        if (vFilePsmf == null) {
            return;
        }
        PsmfAudioDemuxVirtualFile vFileDemuxedAudio = new PsmfAudioDemuxVirtualFile(vFilePsmf, mpegOffset, audioChannel);
        byte[] audioStreamData = Utilities.readCompleteFile(vFileDemuxedAudio);
        if (audioStreamData == null || audioStreamData.length == 0) {
            return;
        }
        this.decodeExtAudio(audioStreamData, mpegFileSize, mpegOffset, audioChannel, lastTimestamp);
    }

    public void setStreamFile(SeekableDataInput dataInput, IVirtualFile vFile, int address, long startPosition, int length) {
        FileLocator.getInstance().setFileData(dataInput, vFile, address, startPosition, length);
    }

    private static String getAtracAudioPath(int address, int atracFileSize, int atracHash, String suffix) {
        return String.format("%s%s", AtracCodec.getBaseDirectory(), ExternalDecoder.getAtracAudioFileName(address, atracFileSize, atracHash, suffix));
    }

    private static String getAtracAudioFileName(int address, int atracFileSize, int atracHash, String suffix) {
        return String.format("Atrac-%08X-%08X-%08X.%s", atracFileSize, address, atracHash, suffix);
    }

    private String decodeAtrac(byte[] atracData, int address, int atracFileSize, int atracHash, String decodedFileName) {
        try {
            ByteBuffer omaBuffer;
            ByteBuffer riffBuffer = ByteBuffer.wrap(atracData);
            String at3FileName = null;
            if (dumpAt3File) {
                new File(AtracCodec.getBaseDirectory()).mkdirs();
                at3FileName = ExternalDecoder.getAtracAudioPath(address, atracFileSize, atracHash, "at3");
                FileOutputStream encodedOut = new FileOutputStream(at3FileName);
                encodedOut.getChannel().write(riffBuffer);
                encodedOut.close();
                riffBuffer.rewind();
            }
            if ((omaBuffer = OMAFormat.convertRIFFtoOMA(riffBuffer)) == null) {
                log.info((Object)"AT3+ data could not be decoded by the external decoder (error while converting to OMA)");
                return null;
            }
            new File(AtracCodec.getBaseDirectory()).mkdirs();
            String encodedFileName = ExternalDecoder.getAtracAudioPath(address, atracFileSize, atracHash, "oma");
            FileOutputStream os = new FileOutputStream(encodedFileName);
            os.getChannel().write(omaBuffer);
            os.close();
            if (!this.executeExternalDecoder(encodedFileName, decodedFileName, at3FileName, keepOmaFile)) {
                int channels = OMAFormat.getOMANumberAudioChannels(omaBuffer);
                if (channels == 1) {
                    log.info((Object)"Mono AT3+ data could not be decoded by the external decoder");
                } else if (channels == 2) {
                    log.info((Object)"Stereo AT3+ data could not be decoded by the external decoder");
                } else {
                    log.info((Object)("AT3+ data could not be decoded by the external decoder (channels=" + channels + ")"));
                }
                return null;
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return decodedFileName;
    }

    public String decodeAtrac(PacketChannel packetChannel, int address, int atracFileSize, int atracHash) {
        if (!ExternalDecoder.isEnabled()) {
            return null;
        }
        byte[] atracData = new byte[atracFileSize];
        int readLength = packetChannel.read(atracData, atracData.length);
        if (readLength != atracData.length) {
            return null;
        }
        String decodedFileName = ExternalDecoder.getAtracAudioPath(address, atracFileSize, atracHash, "wav");
        return this.decodeAtrac(atracData, address, atracFileSize, atracHash, decodedFileName);
    }

    private IVirtualFile getAtracData(int address, int length, int atracFileSize) {
        IVirtualFile vFile;
        if (length >= atracFileSize) {
            vFile = FileLocator.getInstance().getVirtualFile(address, length, atracFileSize, null);
            if (vFile == null) {
                vFile = new MemoryVirtualFile(address, length);
            }
        } else {
            vFile = FileLocator.getInstance().getVirtualFile(address, length, atracFileSize, null);
        }
        return vFile;
    }

    public IVirtualFile extractAtrac(int address, int length, int atracFileSize, int atracHash) {
        if (!ExternalDecoder.isEnabled()) {
            return null;
        }
        return this.getAtracData(address, length, atracFileSize);
    }

    public IVirtualFile decodeAtrac(int address, int length, int atracFileSize, int atracHash, AtracCodec atracCodec) {
        if (!ExternalDecoder.isEnabled()) {
            return null;
        }
        String decodedFileName = ExternalDecoder.getAtracAudioPath(address, atracFileSize, atracHash, "wav");
        File decodedFile = new File(decodedFileName);
        if (decodedFile.canRead() && decodedFile.length() > 0L) {
            try {
                return new LocalVirtualFile(new SeekableRandomFile(decodedFile, "r"));
            }
            catch (FileNotFoundException e) {
                log.error((Object)"decodeAtrac", (Throwable)e);
                return null;
            }
        }
        IVirtualFile vFile = this.getAtracData(address, length, atracFileSize);
        if (vFile == null) {
            log.debug((Object)"AT3+ data could not be decoded by the external decoder (complete atrac data need to be retrieved)");
            atracCodec.setRequireAllAtracData();
            return null;
        }
        byte[] atracData = Utilities.readCompleteFile(vFile);
        if (atracData == null || atracData.length == 0) {
            return null;
        }
        if ((decodedFileName = this.decodeAtrac(atracData, address, atracFileSize, atracHash, decodedFileName)) == null) {
            return null;
        }
        decodedFile = new File(decodedFileName);
        try {
            return new LocalVirtualFile(new SeekableRandomFile(decodedFile, "r"));
        }
        catch (FileNotFoundException e) {
            log.error((Object)"decodeAtrac", (Throwable)e);
            return null;
        }
    }

    static {
        enabled = true;
        dumpAt3File = true;
        dumpAudioStreamFile = false;
        keepOmaFile = true;
    }

    private static class EnableExternalDecoderSettingsListerner
    extends AbstractBoolSettingsListener {
        private EnableExternalDecoderSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            ExternalDecoder.setEnabled(value);
        }
    }
}

