/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jpcsp.HLE.Modules;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.memory.NativeMemoryUtils;

public class NativeMemory
extends Memory {
    private long memory;
    private int memorySize;

    @Override
    public boolean allocate() {
        NativeMemoryUtils.init();
        this.memorySize = MemoryMap.END_RAM + 1;
        this.memory = NativeMemoryUtils.alloc(this.memorySize);
        if (this.memory == 0L) {
            return false;
        }
        log.info((Object)String.format("Using NativeMemory(littleEndian=%b)", NativeMemoryUtils.isLittleEndian()));
        return super.allocate();
    }

    @Override
    public void Initialise() {
        NativeMemoryUtils.memset(this.memory, 0, 0, this.memorySize);
    }

    @Override
    public int read8(int address) {
        return NativeMemoryUtils.read8(this.memory, address &= 0x3FFFFFFF);
    }

    @Override
    public int read16(int address) {
        return NativeMemoryUtils.read16(this.memory, address &= 0x3FFFFFFF);
    }

    @Override
    public int read32(int address) {
        return NativeMemoryUtils.read32(this.memory, address &= 0x3FFFFFFF);
    }

    @Override
    public void write8(int address, byte data) {
        NativeMemoryUtils.write8(this.memory, address &= 0x3FFFFFFF, data);
        Modules.sceDisplayModule.write8(address);
    }

    @Override
    public void write16(int address, short data) {
        NativeMemoryUtils.write16(this.memory, address &= 0x3FFFFFFF, data);
        Modules.sceDisplayModule.write16(address);
    }

    @Override
    public void write32(int address, int data) {
        NativeMemoryUtils.write32(this.memory, address &= 0x3FFFFFFF, data);
        Modules.sceDisplayModule.write32(address);
    }

    @Override
    public void memset(int address, byte data, int length) {
        NativeMemoryUtils.memset(this.memory, address &= 0x3FFFFFFF, data, length);
    }

    @Override
    public Buffer getMainMemoryByteBuffer() {
        return null;
    }

    @Override
    public Buffer getBuffer(int address, int length) {
        ByteBuffer buffer = NativeMemoryUtils.getBuffer(this.memory, address &= 0x3FFFFFFF, length);
        if (NativeMemoryUtils.isLittleEndian()) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            buffer.order(ByteOrder.BIG_ENDIAN);
        }
        return buffer;
    }

    @Override
    public void copyToMemory(int address, ByteBuffer source, int length) {
        address &= 0x3FFFFFFF;
        if (source.isDirect()) {
            NativeMemoryUtils.copyBufferToMemory(this.memory, address, source, source.position(), length);
        } else {
            for (length = Math.min(length, source.capacity()); length > 0; --length) {
                NativeMemoryUtils.write8(this.memory, address, source.get());
                ++address;
            }
        }
    }

    @Override
    protected void memcpy(int destination, int source, int length, boolean checkOverlap) {
        if (length <= 0) {
            return;
        }
        Modules.sceDisplayModule.write8(destination &= 0x3FFFFFFF);
        if (!checkOverlap || (source &= 0x3FFFFFFF) >= destination || !this.areOverlapping(destination, source, length)) {
            NativeMemoryUtils.memcpy(this.memory, destination, this.memory, source, length);
        } else {
            for (int i = length - 1; i >= 0; --i) {
                int b = NativeMemoryUtils.read8(this.memory, source + i);
                NativeMemoryUtils.write8(this.memory, destination + i, b);
            }
        }
    }
}

