/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.adhoc;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import jpcsp.network.adhoc.AdhocMessage;
import jpcsp.network.adhoc.AdhocSocket;

public class AdhocDatagramSocket
extends AdhocSocket {
    private DatagramSocket socket;

    @Override
    public int bind(int port) throws SocketException {
        if (port == 0) {
            this.socket = new DatagramSocket();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Opening socket on free local port %d", this.socket.getLocalPort()));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Opening socket on real port %d", port));
            }
            this.socket = new DatagramSocket(port);
        }
        this.socket.setBroadcast(true);
        this.socket.setSoTimeout(1);
        return this.socket.getLocalPort();
    }

    @Override
    public void close() {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    @Override
    public void setTimeout(int millis) throws SocketException {
        this.socket.setSoTimeout(millis);
    }

    @Override
    public void send(SocketAddress socketAddress, AdhocMessage adhocMessage) throws IOException {
        DatagramPacket packet = new DatagramPacket(adhocMessage.getMessage(), adhocMessage.getMessageLength(), socketAddress);
        this.socket.send(packet);
    }

    @Override
    public int receive(byte[] buffer, int size) throws IOException {
        DatagramPacket packet = new DatagramPacket(buffer, size);
        this.socket.receive(packet);
        this.setReceivedPort(packet.getPort());
        this.setReceivedAddress(packet.getAddress());
        return packet.getLength();
    }

    @Override
    public void connect(SocketAddress socketAddress, int port) throws IOException {
    }

    @Override
    public AdhocSocket accept() throws IOException {
        return null;
    }
}

