/*
 * Decompiled with CFR 0.152.
 */
package org.bolet.jgz;

import java.io.IOException;
import java.io.InputStream;
import org.bolet.jgz.CRCInputStream;
import org.bolet.jgz.JGZException;

public class GZipDecoder {
    private InputStream sub;
    private CRCInputStream in;
    private int compressionMethod;
    private int flags;
    private int mtime;
    private int flagsExtra;
    private int os;
    private String fnameOrig;
    private String comment;
    private int uncompressedCRC;
    private int uncompressedSize;
    public static final int FTEXT = 1;
    public static final int FHCRC = 2;
    public static final int FEXTRA = 4;
    public static final int FNAME = 8;
    public static final int FCOMMENT = 16;
    public static final int DEFLATE = 8;

    public GZipDecoder(InputStream inputStream) {
        this.sub = inputStream;
        this.in = new CRCInputStream(inputStream);
    }

    private int read1() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new JGZException("unexpected end-of-file");
        }
        return n;
    }

    private int readu2() throws IOException {
        int n = this.read1();
        int n2 = this.read1();
        return n + (n2 << 8);
    }

    private int reads4() throws IOException {
        int n = this.readu2();
        int n2 = this.readu2();
        return n + (n2 << 16);
    }

    private String readLatin1String() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n;
        while ((n = this.read1()) != 0) {
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    public InputStream nextMember() throws IOException {
        int n;
        int n2;
        this.in.resetCRC();
        int n3 = this.in.read();
        if (n3 < 0) {
            return null;
        }
        if (n3 != 31 || this.read1() != 139) {
            throw new JGZException("wrong magic number");
        }
        this.compressionMethod = this.read1();
        this.flags = this.read1();
        this.mtime = this.reads4();
        this.flagsExtra = this.read1();
        this.os = this.read1();
        if ((this.flags & 4) != 0) {
            n2 = this.readu2();
            while (n2 > 0) {
                this.read1();
            }
        }
        if ((this.flags & 8) != 0) {
            this.fnameOrig = this.readLatin1String();
        }
        if ((this.flags & 0x10) != 0) {
            this.comment = this.readLatin1String();
        }
        if ((this.flags & 2) != 0 && (n2 = this.in.getCRC() & 0xFFFF) != (n = this.readu2())) {
            throw new JGZException("bad header CRC");
        }
        return this.sub;
    }

    public void closeMember() throws IOException {
        this.uncompressedCRC = this.reads4();
        this.uncompressedSize = this.reads4();
    }

    public int getCompressionMethod() {
        return this.compressionMethod;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getMTime() {
        return this.mtime;
    }

    public int getFlagsExtra() {
        return this.flagsExtra;
    }

    public int getOS() {
        return this.os;
    }

    public String getOriginalFileName() {
        return this.fnameOrig;
    }

    public String getComment() {
        return this.comment;
    }

    public int getUncompressedCRC() {
        return this.uncompressedCRC;
    }

    public int getUncompressedSize() {
        return this.uncompressedSize;
    }

    public InputStream getSubStream() {
        return this.sub;
    }
}

