/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BigDecimalMathUtils {
    public static final BigDecimal TWO = BigDecimal.valueOf(2L);

    protected BigDecimalMathUtils() {
    }

    public static BigDecimal sum(List<BigDecimal> list) {
        BigDecimal bigDecimal = new BigDecimal(0);
        for (BigDecimal bigDecimal2 : list) {
            bigDecimal = bigDecimal.add(bigDecimal2);
        }
        return bigDecimal;
    }

    public static BigDecimal mean(List<BigDecimal> list, MathContext mathContext) {
        BigDecimal bigDecimal = BigDecimalMathUtils.sum(list);
        return bigDecimal.divide(new BigDecimal(list.size()), mathContext);
    }

    public static BigDecimal min(List<BigDecimal> list) {
        return new TreeSet<BigDecimal>(list).first();
    }

    public static BigDecimal max(List<BigDecimal> list) {
        return new TreeSet<BigDecimal>(list).last();
    }

    public static BigDecimal stddev(List<BigDecimal> list, boolean bl, MathContext mathContext) {
        int n = list.size();
        BigDecimal bigDecimal = n > 0 ? (n > 1 ? BigDecimalMathUtils.sqrt(BigDecimalMathUtils.var(list, bl, mathContext)) : BigDecimal.ZERO) : BigDecimal.valueOf(Double.NaN);
        return bigDecimal;
    }

    public static BigDecimal var(List<BigDecimal> list, boolean bl, MathContext mathContext) {
        int n = list.size();
        if (n == 0) {
            return BigDecimal.valueOf(Double.NaN);
        }
        if (n == 1) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = BigDecimalMathUtils.mean(list, mathContext);
        ArrayList<BigDecimal> arrayList = new ArrayList<BigDecimal>();
        for (BigDecimal bigDecimal2 : list) {
            BigDecimal bigDecimal3 = bigDecimal2.subtract(bigDecimal);
            arrayList.add(bigDecimal3.pow(2, mathContext));
        }
        BigDecimal bigDecimal4 = BigDecimalMathUtils.sum(arrayList);
        return bigDecimal4.divide(new BigDecimal(bl ? list.size() - 1 : list.size()), mathContext);
    }

    public static BigDecimal sqrt(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal3;
        BigDecimal bigDecimal4 = null;
        BigDecimal bigDecimal5 = null;
        int n = bigDecimal.precision();
        MathContext mathContext = new MathContext(n, RoundingMode.HALF_UP);
        BigDecimal bigDecimal6 = bigDecimal;
        double d = bigDecimal6.doubleValue();
        if (mathContext.getPrecision() == 0) {
            throw new IllegalArgumentException("\nRoots need a MathContext precision > 0");
        }
        if (d < 0.0) {
            throw new ArithmeticException("\nCannot calculate the square root of a negative number");
        }
        if (d == 0.0) {
            return bigDecimal.round(mathContext);
        }
        if (mathContext.getPrecision() < 50) {
            n += 10;
        }
        int n2 = 1;
        if (d == Double.POSITIVE_INFINITY) {
            BigInteger bigInteger = bigDecimal6.unscaledValue();
            int n3 = bigInteger.bitLength();
            int n4 = n3 / 2;
            bigInteger = bigInteger.shiftRight(n4);
            bigDecimal3 = new BigDecimal(bigInteger);
            MathContext mathContext2 = new MathContext(5, RoundingMode.HALF_DOWN);
            n += 10;
            bigDecimal2 = BigDecimal.ONE.divide(TWO.multiply(bigDecimal3, mathContext2), mathContext2);
        } else {
            double d2 = Math.sqrt(d);
            bigDecimal3 = new BigDecimal(d2);
            bigDecimal2 = new BigDecimal(0.5 / d2);
            n2 = 64;
        }
        int n5 = mathContext.getPrecision() + n;
        MathContext mathContext3 = new MathContext(n2, mathContext.getRoundingMode());
        return BigDecimalMathUtils.sqrtProcedure(mathContext3, n5, bigDecimal6, bigDecimal3, bigDecimal2, bigDecimal4, bigDecimal5);
    }

    private static BigDecimal sqrtProcedure(MathContext mathContext, int n, BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, BigDecimal bigDecimal4, BigDecimal bigDecimal5) {
        bigDecimal4 = BigDecimal.ONE.subtract(TWO.multiply(bigDecimal2, mathContext).multiply(bigDecimal3, mathContext), mathContext);
        bigDecimal3 = bigDecimal3.add(bigDecimal4.multiply(bigDecimal3, mathContext), mathContext);
        bigDecimal5 = bigDecimal.subtract(bigDecimal2.multiply(bigDecimal2, mathContext), mathContext);
        bigDecimal2 = bigDecimal2.add(bigDecimal5.multiply(bigDecimal3, mathContext), mathContext);
        int n2 = mathContext.getPrecision();
        n2 = n2 < 2 ? ++n2 : n2 * 2 - 1;
        if (n2 < 2 * n) {
            mathContext = new MathContext(n2, mathContext.getRoundingMode());
            BigDecimalMathUtils.sqrtProcedure(mathContext, n, bigDecimal, bigDecimal2, bigDecimal3, bigDecimal4, bigDecimal5);
        }
        return bigDecimal2;
    }

    public static void main(String[] stringArray) {
        System.out.println(BigDecimalMathUtils.sqrt(new BigDecimal("25029.33333")));
    }
}

