/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.util.HashMap;
import java.util.Map;
import org.lwjgl.opencl.CLContext;

final class CallbackUtil {
    private static final Map<CLContext, Long> contextUserData = new HashMap<CLContext, Long>();

    private CallbackUtil() {
    }

    static long createGlobalRef(Object obj) {
        return obj == null ? 0L : CallbackUtil.ncreateGlobalRef(obj);
    }

    private static native long ncreateGlobalRef(Object var0);

    private static native void deleteGlobalRef(long var0);

    static void checkCallback(int errcode, long user_data) {
        if (errcode != 0 && user_data != 0L) {
            CallbackUtil.deleteGlobalRef(user_data);
        }
    }

    static native long getContextCallback();

    static void registerCallback(CLContext context, long user_data) {
        if (context.getPointerUnsafe() == 0L) {
            if (user_data != 0L) {
                CallbackUtil.deleteGlobalRef(user_data);
            }
            return;
        }
        if (user_data != 0L) {
            contextUserData.put(context, user_data);
        }
    }

    static void unregisterCallback(CLContext context) {
        if (context.release() > 0) {
            return;
        }
        Long user_data = contextUserData.remove(context);
        if (user_data != null) {
            CallbackUtil.deleteGlobalRef(user_data);
        }
    }

    static native long getMemObjectDestructorCallback();

    static native long getBuildProgramCallback();

    static native long getNativeKernelCallback();

    static native long getEventCallback();

    static native long getLogMessageToSystemLogAPPLE();

    static native long getLogMessageToStdoutAPPLE();

    static native long getLogMessageToStderrAPPLE();
}

