/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.ui.shortcut;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class JsDebugLaunchShortcut
implements ILaunchShortcut {
    private static final String BROWSER_PATH = "C:\\\\Program Files\\\\Internet Explorer\\\\IEXPLORE.EXE";

    public void launch(ISelection selection, String mode) {
        IFile file = (IFile)((IStructuredSelection)selection).getFirstElement();
        this.launch(file, mode);
    }

    private void launch(IFile file, String mode) {
        ILaunchConfiguration configuration;
        String path = file.getLocation().toOSString();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("org.ayound.js.debug.core.JsDebug");
        try {
            ILaunchConfiguration[] configurations = launchManager.getLaunchConfigurations(type);
            int i = 0;
            while (i < configurations.length) {
                configuration = configurations[i];
                String attribute = configuration.getAttribute("url", null);
                if (path.equals(attribute)) {
                    DebugUITools.launch((ILaunchConfiguration)configuration, (String)mode);
                    return;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return;
        }
        try {
            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, file.getName());
            workingCopy.setAttribute("url", path);
            workingCopy.setAttribute("port", "8088");
            File browserFile = new File(BROWSER_PATH);
            if (browserFile.exists()) {
                workingCopy.setAttribute("browser", BROWSER_PATH);
                configuration = workingCopy.doSave();
                int result = DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)new Shell(), (ILaunchConfiguration)configuration, (String)"org.eclipse.debug.ui.launchGroup.debug");
                if (result == 1) {
                    configuration.delete();
                    workingCopy.delete();
                } else {
                    DebugUITools.launch((ILaunchConfiguration)configuration, (String)mode);
                }
            } else {
                MessageDialog.openError((Shell)new Shell(Display.getCurrent()), (String)"Debug Javascript Error!", (String)"The browser C:\\\\Program Files\\\\Internet Explorer\\\\IEXPLORE.EXE is not exists!");
            }
        }
        catch (CoreException coreException) {}
    }

    public void launch(IEditorPart editor, String mode) {
        IFile file = ((IFileEditorInput)editor.getEditorInput()).getFile();
        this.launch(file, mode);
    }
}

