/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.ui.adapter;

import org.ayound.js.debug.engine.EngineManager;
import org.ayound.js.debug.engine.IJsEngine;
import org.ayound.js.debug.model.JsBreakPoint;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class JsBreakpointAdapter
implements IToggleBreakpointsTargetExtension {
    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleLineBreakpoints(part, selection);
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection);
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.getEditor(part) != null;
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        ITextEditor textEditor = this.getEditor(part);
        if (textEditor != null) {
            IFileEditorInput editorInput = (IFileEditorInput)textEditor.getEditorInput();
            IFile resource = editorInput.getFile();
            ITextSelection textSelection = (ITextSelection)selection;
            int rulerLine = textSelection.getStartLine() + 1;
            IBreakpoint[] breakPoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
            boolean hasBreakPoint = false;
            IBreakpoint[] iBreakpointArray = breakPoints;
            int n = 0;
            int n2 = iBreakpointArray.length;
            while (n < n2) {
                IBreakpoint point = iBreakpointArray[n];
                if (point.getMarker().getResource().equals((Object)resource) && point.getMarker().getAttribute("lineNumber", 0) == rulerLine) {
                    point.delete();
                    hasBreakPoint = true;
                    break;
                }
                ++n;
            }
            int breakLine = this.getBreakPointLine(textEditor, rulerLine);
            if (breakLine < 1) {
                return;
            }
            try {
                if (!hasBreakPoint && breakLine == rulerLine) {
                    DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)new JsBreakPoint((IResource)editorInput.getFile(), breakLine));
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    private int getBreakPointLine(ITextEditor textEditor, int lineNum) {
        IFileEditorInput editorInput = (IFileEditorInput)textEditor.getEditorInput();
        IFile resource = editorInput.getFile();
        int rulerLine = lineNum;
        IJsEngine engine = EngineManager.getEngine();
        String text = textEditor.getDocumentProvider().getDocument((Object)editorInput).get();
        String url = resource.getFullPath().toString();
        if (text.startsWith("<")) {
            engine.compileHtml(url, text);
        } else {
            engine.compileJs(url, text);
        }
        if (engine.canBreakLine(url, rulerLine)) {
            return rulerLine;
        }
        int i = rulerLine;
        while (i > 0) {
            if (engine.canBreakLine(url, i)) {
                return i;
            }
            --i;
        }
        return 0;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    private ITextEditor getEditor(IWorkbenchPart part) {
        ITextEditor editorPart;
        IResource resource;
        if (part instanceof ITextEditor && (resource = (IResource)(editorPart = (ITextEditor)part).getEditorInput().getAdapter(IResource.class)) != null) {
            return editorPart;
        }
        return null;
    }
}

