/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.ui.editor;

import org.ayound.js.debug.engine.EngineManager;
import org.ayound.js.debug.ui.editor.ColorManager;
import org.ayound.js.debug.ui.editor.HtmlJsDocumentProvider;
import org.ayound.js.debug.ui.editor.HtmlJsconfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.mozilla.javascript.EvaluatorException;

public class JsEditor
extends AbstractDecoratedTextEditor {
    private ColorManager colorManager;

    public JsEditor() {
        this.setRulerContextMenuId("org.ayound.js.debug.rulerMenu");
        this.setEditorContextMenuId("org.ayound.js.debug.ui.jsEvalMenu");
        this.colorManager = new ColorManager();
        this.setSourceViewerConfiguration(new HtmlJsconfiguration(this.colorManager));
        this.setDocumentProvider((IDocumentProvider)new HtmlJsDocumentProvider());
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.validateAndMark();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        this.validateAndMark();
    }

    protected void validateAndMark() {
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            int n = 0;
            int n2 = iMarkerArray.length;
            while (n < n2) {
                IMarker marker = iMarkerArray[n];
                marker.delete();
                ++n;
            }
        }
        catch (CoreException coreException) {}
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        String text = document.get();
        if (text.trim().startsWith("<")) {
            try {
                EngineManager.getEngine().compileHtml("_temp.js", text);
            }
            catch (EvaluatorException e) {
                int lineNum;
                int errLine = lineNum = e.lineNumber();
                this.handleError(e, errLine, true);
            }
        } else {
            try {
                EngineManager.getEngine().compileJs("_temp.js", text);
            }
            catch (EvaluatorException e) {
                this.handleError(e, true);
            }
        }
    }

    protected void handleError(EvaluatorException e, int lineNum, boolean isFatal) {
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        try {
            IMarker marker = file.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("severity", 2);
            marker.setAttribute("message", (Object)("[Error]: " + e.details()));
            marker.setAttribute("lineNumber", lineNum);
            int startChar = this.getCharStart(lineNum, e.columnNumber());
            int endChar = this.getCharEnd(lineNum, e.columnNumber());
            marker.setAttribute("charStart", startChar);
            marker.setAttribute("charEnd", endChar);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    protected void handleError(EvaluatorException e, boolean isFatal) {
        this.handleError(e, e.lineNumber(), isFatal);
    }

    private int getCharStart(int lineNum, int columnNum) {
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        String text = document.get();
        int offset = 0;
        int lineIndex = 0;
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            ++offset;
            if (ch == '\n') {
                ++lineIndex;
            }
            if (lineIndex >= lineNum - 1) break;
            ++i;
        }
        return offset;
    }

    private int getCharEnd(int lineNum, int columnNum) {
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        String text = document.get();
        int offset = 0;
        int lineIndex = 0;
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            ++offset;
            if (ch == '\n') {
                ++lineIndex;
            }
            if (lineIndex >= lineNum) break;
            ++i;
        }
        return offset - 1;
    }
}

