/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.ui.views;

import java.util.List;
import org.ayound.js.debug.core.IEvalListener;
import org.ayound.js.debug.core.JsDebugCorePlugin;
import org.ayound.js.debug.model.ExpressionModel;
import org.ayound.js.debug.model.JsDebugStackFrame;
import org.ayound.js.debug.ui.expression.JsExpressionAddAction;
import org.ayound.js.debug.ui.expression.JsExpressionRemoveAction;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class EvalView
extends AbstractDebugView
implements ISelectionListener,
IEvalListener {
    private Text valueText;

    protected Viewer createViewer(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.makeColumnsEqualWidth = true;
        parent.setLayout((Layout)layout);
        Table table = new Table(parent, 0);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setWidth(200);
        column1.setResizable(true);
        table.setHeaderVisible(false);
        table.setLayoutData((Object)new GridData(1808));
        TableViewer viewer = new TableViewer(table);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        JsDebugCorePlugin.getDefault().addEvalListener((IEvalListener)this);
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof ExpressionModel) {
                    ExpressionModel model = (ExpressionModel)element;
                    if (columnIndex == 0) {
                        if (model.getError() != null) {
                            return String.valueOf(model.getExpression()) + " = error : " + model.getError();
                        }
                        return String.valueOf(model.getExpression()) + " = " + model.getResult();
                    }
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ExpressionModel model = (ExpressionModel)selection.getFirstElement();
                if (model != null) {
                    if (model.getError() != null) {
                        EvalView.this.valueText.setText(model.getError());
                    } else if (model.getResult() != null) {
                        EvalView.this.valueText.setText(model.getResult());
                    } else {
                        EvalView.this.valueText.setText("null");
                    }
                } else {
                    EvalView.this.valueText.setText("");
                }
            }
        });
        this.valueText = new Text(parent, 2);
        this.valueText.setLayoutData((Object)new GridData(1808));
        return viewer;
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IAction)new JsExpressionAddAction(this, "add watch experssion", null));
        menu.add((IAction)new JsExpressionRemoveAction(this, "remove watch expression", null));
    }

    protected String getHelpContextId() {
        return null;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        JsDebugStackFrame frame;
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable != null && adaptable instanceof IDebugElement && (frame = (JsDebugStackFrame)adaptable.getAdapter(JsDebugStackFrame.class)) != null && this.getViewer() != null) {
            this.getViewer().setInput((Object)frame.getExpressionResult());
            this.getViewer().refresh();
        }
    }

    public void update(JsDebugStackFrame frame) {
        if (frame != null && this.getViewer() != null) {
            this.getViewer().setInput((Object)frame.getExpressionResult());
            this.getViewer().refresh();
        }
    }

    protected void configureToolBar(IToolBarManager tbm) {
    }

    protected void createActions() {
    }
}

