/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.ui.views;

import java.util.Arrays;
import java.util.HashSet;
import org.ayound.js.debug.core.IResourceListener;
import org.ayound.js.debug.core.JsDebugCorePlugin;
import org.ayound.js.debug.model.JsDebugTarget;
import org.ayound.js.debug.server.IDebugServer;
import org.ayound.js.debug.server.JsDebugServer;
import org.ayound.js.debug.ui.JsDebugUIPlugin;
import org.ayound.js.debug.ui.JsFileEditorInput;
import org.ayound.js.debug.ui.editor.JsEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class ResourceView
extends AbstractDebugView
implements ISelectionListener,
IResourceListener {
    public ResourceView() {
        JsDebugCorePlugin.getDefault().addResourceListener((IResourceListener)this);
    }

    protected void configureToolBar(IToolBarManager tbm) {
    }

    protected void createActions() {
    }

    protected Viewer createViewer(Composite parent) {
        ListViewer viewer = new ListViewer(parent);
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 1) {
                    String resource = (String)selection.getFirstElement();
                    ResourceView.this.openFile(resource);
                }
            }
        });
        return viewer;
    }

    private void openFile(String resource) {
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(resource);
        if (res instanceof IFile) {
            JsFileEditorInput input = new JsFileEditorInput((IFile)res);
            try {
                IEditorPart[] editors;
                IWorkbenchPage page = JsDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart[] iEditorPartArray = editors = page.getEditors();
                int n = 0;
                int n2 = iEditorPartArray.length;
                while (n < n2) {
                    FileEditorInput jsInput;
                    IEditorPart editor = iEditorPartArray[n];
                    if (editor instanceof JsEditor && (jsInput = (FileEditorInput)editor.getEditorInput()).equals((Object)input)) {
                        page.closeEditor(editor, false);
                    }
                    ++n;
                }
                IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"org.ayound.js.debug.ui.editor.JsEditor", (boolean)true);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected String getHelpContextId() {
        return null;
    }

    public void resourceChange(String[] resources) {
        try {
            this.getViewer().setInput((Object)resources);
            this.getViewer().refresh();
        }
        catch (Exception exception) {}
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        block3: {
            ILaunch launch;
            JsDebugTarget fTarget;
            JsDebugServer server;
            IAdaptable adaptable;
            block4: {
                JsDebugTarget fTarget2;
                JsDebugServer server2;
                adaptable = DebugUITools.getDebugContext();
                if (adaptable == null) break block3;
                if (!(adaptable instanceof IDebugElement)) break block4;
                IDebugElement element = (IDebugElement)adaptable.getAdapter(IDebugElement.class);
                if (element == null || !element.getModelIdentifier().equals("org.ayound.js.debug.model") || !(server2 = (fTarget2 = (JsDebugTarget)element.getDebugTarget()).getServer()).isRunning() || this.getViewer() == null) break block3;
                String[] stringArray = server2.getResources();
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    String resource = stringArray[n];
                    this.addResource(resource);
                    ++n;
                }
                break block3;
            }
            if (adaptable instanceof ILaunch && (server = (fTarget = (JsDebugTarget)(launch = (ILaunch)adaptable.getAdapter(ILaunch.class)).getDebugTarget()).getServer()).isRunning() && fTarget != null && this.getViewer() != null) {
                String[] stringArray = server.getResources();
                int n = 0;
                int n3 = stringArray.length;
                while (n < n3) {
                    String resource = stringArray[n];
                    this.addResource(resource);
                    ++n;
                }
            }
        }
    }

    private void addResource(String resource) {
        if (this.getViewer() != null) {
            Object input = this.getViewer().getInput();
            if (input != null && input instanceof String[]) {
                String[] arr = (String[])input;
                if (Arrays.asList(arr).contains(resource)) {
                    return;
                }
                HashSet<String> set = new HashSet<String>();
                String[] stringArray = arr;
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    String str = stringArray[n];
                    set.add(str);
                    ++n;
                }
                set.add(resource);
                this.getViewer().setInput((Object)set.toArray(new String[set.size()]));
            } else {
                this.getViewer().setInput((Object)new String[]{resource});
            }
            this.getViewer().refresh();
            this.openFile(resource);
        }
    }

    public void addResource(String resource, IDebugServer server) {
        this.addResource(resource);
    }

    public void removeResource(String resource, IDebugServer server) {
        if (this.getViewer() != null) {
            Object input = this.getViewer().getInput();
            if (input != null && input instanceof String[]) {
                String[] arr = (String[])input;
                HashSet<String> set = new HashSet<String>();
                String[] stringArray = arr;
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    String str = stringArray[n];
                    if (!resource.equals(str)) {
                        set.add(str);
                    }
                    ++n;
                }
                this.getViewer().setInput((Object)set.toArray(new String[set.size()]));
            }
            this.getViewer().refresh();
        }
    }
}

