/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.ui;

import org.ayound.js.debug.model.JsBreakPoint;
import org.ayound.js.debug.model.JsValue;
import org.ayound.js.debug.model.JsVariable;
import org.ayound.js.debug.ui.JsFileEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.IEditorInput;

public class JsDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    public void computeDetail(IValue value, IValueDetailListener listener) {
        String detail = "";
        try {
            detail = value.getReferenceTypeName();
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
        listener.detailComputed(value, detail);
    }

    public String getEditorId(IEditorInput input, Object element) {
        return "org.ayound.js.debug.ui.editor.JsEditor";
    }

    public String getText(Object element) {
        try {
            if (element instanceof IStackFrame) {
                return ((IStackFrame)element).getName();
            }
            if (element instanceof JsVariable) {
                try {
                    return ((JsVariable)element).getName();
                }
                catch (DebugException e) {
                    e.printStackTrace();
                }
            } else if (element instanceof JsValue) {
                try {
                    return ((JsValue)element).getReferenceTypeName();
                }
                catch (DebugException e) {
                    e.printStackTrace();
                }
            } else {
                if (element instanceof IDebugTarget) {
                    return ((IDebugTarget)element).getName();
                }
                if (element instanceof IThread) {
                    return ((IThread)element).getName();
                }
                if (element instanceof JsBreakPoint) {
                    return ((JsBreakPoint)element).getText();
                }
                if (element instanceof IExpression) {
                    IExpression expr = (IExpression)element;
                    IValue val = expr.getValue();
                    StringBuffer buf = new StringBuffer(expr.getExpressionText());
                    if (val != null) {
                        buf.append('=');
                        buf.append(expr.getValue().getValueString());
                    }
                    return buf.toString();
                }
            }
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
        return super.getText(element);
    }

    public IEditorInput getEditorInput(Object element) {
        JsFileEditorInput editorInput = null;
        if (element instanceof IFile) {
            editorInput = new JsFileEditorInput((IFile)element);
        }
        return editorInput;
    }

    public void setAttribute(String attribute, Object value) {
    }
}

