/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.engine;

import java.util.HashMap;
import java.util.Map;
import org.ayound.js.debug.engine.IJsEngine;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.JsDebugCompileEngine;

public class JsEngineImpl
implements IJsEngine {
    private Map<String, JsDebugCompileEngine> engineMap = new HashMap<String, JsDebugCompileEngine>();
    private Map<String, String> compileMap = new HashMap<String, String>();

    public boolean canBreakLine(String url, int line) {
        JsDebugCompileEngine engine;
        return this.engineMap.containsKey(url) && (engine = this.engineMap.get(url)).getBreakPoints().containsKey(line - 1);
    }

    public void compileJs(String url, String text) {
        JsDebugCompileEngine compile = new JsDebugCompileEngine();
        compile.setLineno(0);
        compile.setSourceName(url);
        compile.setSourceString(text);
        this.compileMap.put(url, compile.compile());
        this.engineMap.put(url, compile);
    }

    public String compileJsOffset(String url, String text, int offset) throws EvaluatorException {
        JsDebugCompileEngine compile = null;
        if (this.engineMap.containsKey(url)) {
            compile = this.engineMap.get(url);
        } else {
            compile = new JsDebugCompileEngine();
            this.engineMap.put(url, compile);
        }
        compile.setLineno(0);
        compile.setSourceName(url);
        compile.setSourceString(text);
        compile.setOffsetLine(offset);
        String result = null;
        try {
            result = compile.compile();
        }
        catch (EvaluatorException e) {
            int errLine = offset + e.lineNumber();
            e.initLineNumber(errLine);
            throw e;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public void compileHtml(String url, String text) {
        htmlBuffer = new StringBuffer();
        scriptBuffer = new StringBuffer();
        scriptStart = false;
        scriptChar = false;
        currLine = 1;
        scriptOffsetLine = 0;
        i = 0;
        while (i < text.length()) {
            block9: {
                block10: {
                    block11: {
                        block8: {
                            ch = text.charAt(i);
                            if (ch != '\n') break block8;
                            ++currLine;
                            if (scriptChar) {
                                scriptBuffer.append(' ').append(ch);
                            } else {
                                htmlBuffer.append(ch);
                            }
                            break block9;
                        }
                        if (ch != '<') break block10;
                        if (text.length() <= i + 8) ** GOTO lbl-1000
                        targetTag = text.substring(i, i + 8).toLowerCase();
                        if (!targetTag.startsWith("<script")) break block11;
                        scriptOffsetLine = currLine;
                        scriptStart = true;
                        scriptChar = false;
                        ** GOTO lbl-1000
                    }
                    if (!targetTag.startsWith("</script")) ** GOTO lbl-1000
                    scriptStart = false;
                    scriptChar = false;
                    script = scriptBuffer.toString();
                    htmlBuffer.append(this.compileJsOffset(url, script, scriptOffsetLine));
                    scriptBuffer = new StringBuffer();
                    ** GOTO lbl-1000
                }
                if (ch == '>' && scriptStart && !scriptChar) {
                    htmlBuffer.append(ch);
                    scriptChar = true;
                    if (text.charAt(i + 1) == '\n') {
                        ++currLine;
                        ++i;
                    }
                } else if (scriptChar) {
                    scriptBuffer.append(ch);
                } else {
                    htmlBuffer.append(ch);
                }
            }
            ++i;
        }
        htmlStr = htmlBuffer.toString();
        this.compileMap.put(url, htmlStr);
    }

    public static void main(String[] args) {
        JsEngineImpl js = new JsEngineImpl();
        StringBuffer buffer = new StringBuffer();
        buffer.append("function test(){\n\n/*abc\ndef\nddd*/");
        buffer.append("\talert('a');\n");
        buffer.append("}");
        js.compileJs("test", buffer.toString());
        System.out.println(js.compileMap.get("test"));
    }

    public String getCompiledString(String url) {
        if (this.compileMap.containsKey(url)) {
            return this.compileMap.get(url);
        }
        return null;
    }
}

