/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ayound.js.debug.core.IEvalListener;
import org.ayound.js.debug.core.IResourceListener;
import org.ayound.js.debug.model.JsDebugStackFrame;
import org.ayound.js.debug.resource.JsResourceManager;
import org.ayound.js.debug.server.IDebugServer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class JsDebugCorePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.ayound.js.debug.core";
    public static final String MODEL_ID = "org.ayound.js.debug.model";
    private static JsDebugCorePlugin plugin;
    private static Set<Integer> usedPorts;
    private List<IResourceListener> resourceListeners = new ArrayList<IResourceListener>();
    private List<IEvalListener> evalListeners = new ArrayList<IEvalListener>();

    static {
        usedPorts = new HashSet<Integer>();
    }

    public void usePort(int port) {
        usedPorts.add(port);
    }

    public boolean hasPort(int port) {
        return usedPorts.contains(port);
    }

    public void removePort(int port) {
        usedPorts.remove(port);
    }

    public JsDebugCorePlugin() {
        plugin = this;
    }

    public void addEvalListener(IEvalListener listener) {
        this.evalListeners.add(listener);
    }

    public void removeEvalListener(IEvalListener listener) {
        this.evalListeners.remove(listener);
    }

    public void addResourceListener(IResourceListener listener) {
        this.resourceListeners.add(listener);
    }

    public void updateEval(final JsDebugStackFrame frame) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                for (IEvalListener listener : JsDebugCorePlugin.this.evalListeners) {
                    listener.update(frame);
                }
            }
        });
    }

    public void removeResourceListener(IResourceListener listener) {
        this.resourceListeners.remove(listener);
    }

    public void addResource(final String resource, final IDebugServer server) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                for (IResourceListener listener : JsDebugCorePlugin.this.resourceListeners) {
                    listener.addResource(resource, server);
                }
            }
        });
    }

    public void removeResource(final String resource, final IDebugServer server) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                for (IResourceListener listener : JsDebugCorePlugin.this.resourceListeners) {
                    listener.removeResource(resource, server);
                }
            }
        });
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        JsResourceManager.removeDebugProject();
        plugin = null;
        super.stop(context);
    }

    public static JsDebugCorePlugin getDefault() {
        return plugin;
    }
}

