/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.model;

import java.util.ArrayList;
import org.ayound.js.debug.model.JsDebugStackFrame;
import org.ayound.js.debug.model.JsValue;
import org.ayound.js.debug.model.JsVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IVariable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class VariableUtil {
    public static IVariable[] createVarsByObject(JSONObject rootJson, IDebugTarget target, ILaunch launch, JsDebugStackFrame frame, JsVariable parentVar) {
        if (rootJson != null) {
            ArrayList<JsVariable> vars = new ArrayList<JsVariable>();
            JSONArray names = rootJson.names();
            if (names == null) {
                return new IVariable[0];
            }
            int i = 0;
            while (i < names.length()) {
                try {
                    Object nameObj = names.get(i);
                    if (nameObj != null) {
                        String name = nameObj.toString();
                        JsVariable var = new JsVariable(name, target, launch);
                        JSONObject value = rootJson.getJSONObject(name);
                        String type = value.getString("type");
                        var.setReferenceTypeName(type);
                        JsValue jsValue = new JsValue(target, launch, frame);
                        if (value.has("value")) {
                            jsValue.setValueString(value.getString("value"));
                        } else {
                            jsValue.setValueString("");
                        }
                        jsValue.setReferenceTypeName(type);
                        jsValue.setParentVar(var);
                        var.setParentVar(parentVar);
                        var.setValue(jsValue);
                        vars.add(var);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                catch (DebugException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            return vars.toArray(new JsVariable[vars.size()]);
        }
        return null;
    }

    public static IVariable[] createVarsByObject(String jsonString, IDebugTarget target, ILaunch launch, JsDebugStackFrame frame, JsVariable parentVar) {
        try {
            JSONObject rootJson = new JSONObject(new JSONTokener(jsonString));
            return VariableUtil.createVarsByObject(rootJson, target, launch, frame, parentVar);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

