/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.server;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import org.ayound.js.debug.model.JsDebugStackFrame;
import org.ayound.js.debug.model.JsDebugThread;
import org.ayound.js.debug.model.JsErrorStackFrame;
import org.ayound.js.debug.model.ValueUtil;
import org.ayound.js.debug.model.VariableUtil;
import org.ayound.js.debug.server.AbstractProcessor;
import org.ayound.js.debug.server.IDebugServer;
import org.ayound.js.debug.server.JsDebugParam;
import org.ayound.js.debug.server.JsDebugResponse;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugProcessor
extends AbstractProcessor {
    public DebugProcessor(String requestUrl, String postData, JsDebugResponse response, IThread thread, IDebugServer server, Map<String, String> requestHeader) {
        super(requestUrl, postData, response, thread, server, requestHeader, null);
    }

    @Override
    public void process() {
        this.getResponse().writeHTMLHeader("UTF-8", null);
        JsDebugParam param = null;
        try {
            param = new JsDebugParam(this.getPostData());
        }
        catch (JSONException jSONException) {
            this.getResponse().close();
            return;
        }
        IThread thread = this.getThread();
        if (thread instanceof JsDebugThread) {
            JsDebugThread jsThread = (JsDebugThread)thread;
            if (param.isNewStack()) {
                jsThread.clearStackFrame();
            }
            if ("START".equalsIgnoreCase(param.getCommand()) || "RESUME".equalsIgnoreCase(param.getCommand())) {
                this.getResponse().writeResume();
                this.getResponse().close();
            } else if ("STEPOVER".equalsIgnoreCase(param.getCommand()) || "STEPINTO".equalsIgnoreCase(param.getCommand()) || "STEPRETURN".equalsIgnoreCase(param.getCommand())) {
                JsDebugStackFrame frame = new JsDebugStackFrame(this.getThread(), this.getThread().getDebugTarget(), this.getThread().getLaunch());
                frame.setResponse(this.getResponse());
                frame.setResource(param.getJsResource());
                frame.setLineNum(param.getLine());
                frame.setVariables(VariableUtil.createVarsByObject(param.getJsonStack(), thread.getDebugTarget(), thread.getLaunch(), frame, null));
                jsThread.addStackFrame(frame);
            } else if ("ERROR".equalsIgnoreCase(param.getCommand())) {
                JsErrorStackFrame frame = new JsErrorStackFrame(this.getThread(), this.getThread().getDebugTarget(), this.getThread().getLaunch());
                frame.setResponse(this.getResponse());
                String resource = param.getJsResource();
                int errorLine = param.getLine();
                if (resource != null) {
                    resource = resource.replace(this.getServer().getLocalBaseUrl(), "");
                    IFile resourceFile = this.getServer().getJsResourceManager().getFileByResource(resource);
                    resource = resourceFile.getFullPath().toString();
                }
                if (this.getServer().isHtmlPage(resource)) {
                    errorLine -= this.getServer().getDebugLine();
                }
                frame.setLineNum(errorLine);
                frame.setResource(resource);
                try {
                    frame.setErrorMsg(URLDecoder.decode(param.getError(), "utf-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    frame.setErrorMsg(param.getError());
                }
                jsThread.addStackFrame(frame);
                this.getResponse().writeResume();
                this.getResponse().close();
            } else if ("BREAKPOINT".equalsIgnoreCase(param.getCommand())) {
                JsDebugStackFrame frame = new JsDebugStackFrame(this.getThread(), this.getThread().getDebugTarget(), this.getThread().getLaunch());
                frame.setResponse(this.getResponse());
                frame.setResource(param.getJsResource());
                frame.setLineNum(param.getLine());
                frame.setVariables(VariableUtil.createVarsByObject(param.getJsonStack(), thread.getDebugTarget(), thread.getLaunch(), frame, null));
                jsThread.addStackFrame(frame);
            } else if ("EXPRESSION".equalsIgnoreCase(param.getCommand())) {
                try {
                    IStackFrame frame = jsThread.getTopStackFrame();
                    if (frame instanceof JsDebugStackFrame) {
                        JsDebugStackFrame jsFrame = (JsDebugStackFrame)frame;
                        jsFrame.setResponse(this.getResponse());
                        jsFrame.finishExpression(param.getExpression(), param.getResult(), param.getError());
                    }
                }
                catch (DebugException e) {
                    e.printStackTrace();
                }
            } else if ("VALUE".equalsIgnoreCase(param.getCommand())) {
                try {
                    IStackFrame frame = jsThread.getTopStackFrame();
                    if (frame instanceof JsDebugStackFrame) {
                        JsDebugStackFrame jsFrame = (JsDebugStackFrame)frame;
                        jsFrame.setResponse(this.getResponse());
                        ValueUtil.updateValue(param.getResult());
                    }
                }
                catch (DebugException e) {
                    e.printStackTrace();
                }
            } else {
                this.getResponse().writeResume();
                this.getResponse().close();
            }
        } else {
            this.getResponse().close();
        }
    }
}

