/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.server;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.ayound.js.debug.server.ResponseInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcesserUtil {
    public static ResponseInfo getResponseInfo(URL url, String method, String postData, Map<String, String> requestHeader) {
        InputStream stream = null;
        String encoding = null;
        String contentType = null;
        Map<String, List<String>> responseHeader = null;
        if (method == null) {
            method = "GET";
        }
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            String filePath = url.toString().substring(5);
            int paramOffset = filePath.indexOf(63);
            if (paramOffset > 0) {
                filePath = filePath.substring(0, paramOffset);
            }
            if (filePath.toLowerCase().endsWith(".js")) {
                contentType = "text/javascript";
            } else if (filePath.toLowerCase().endsWith(".htm") || filePath.toLowerCase().endsWith(".html")) {
                contentType = "text/html";
            }
            try {
                stream = new FileInputStream(filePath);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else if ("http".equalsIgnoreCase(url.getProtocol()) || "https".equalsIgnoreCase(url.getProtocol())) {
            try {
                String fileName;
                int offsetParam;
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setUseCaches(false);
                conn.setInstanceFollowRedirects(false);
                for (Map.Entry<String, String> entry : requestHeader.entrySet()) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
                conn.setRequestMethod(method);
                if (method.equalsIgnoreCase("POST")) {
                    conn.getOutputStream().write(postData.getBytes());
                    conn.getOutputStream().flush();
                }
                if ((offsetParam = (fileName = url.getFile()).indexOf(63)) > 0) {
                    fileName = fileName.substring(0, offsetParam);
                }
                contentType = fileName.toLowerCase().endsWith(".js") ? "text/javascript" : conn.getContentType();
                encoding = conn.getContentEncoding();
                stream = conn.getInputStream();
                responseHeader = conn.getHeaderFields();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new ResponseInfo(encoding, stream, contentType, responseHeader);
    }
}

