/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.server;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.ayound.js.debug.server.DebugProcessor;
import org.ayound.js.debug.server.HtmlPageProcessor;
import org.ayound.js.debug.server.IDebugServer;
import org.ayound.js.debug.server.IServerProcessor;
import org.ayound.js.debug.server.JsDebugResponse;
import org.ayound.js.debug.server.ProcesserUtil;
import org.ayound.js.debug.server.ResourceProcessor;
import org.ayound.js.debug.server.ResponseInfo;
import org.ayound.js.debug.server.ScriptProcessor;
import org.eclipse.debug.core.model.IThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessorFactory {
    public static IServerProcessor createProcessor(String resource, String method, String postData, JsDebugResponse response, IThread thread, IDebugServer server, Map<String, String> requestHeader) {
        String debugUrl = "/jsdebug.debug";
        if (resource.startsWith(debugUrl)) {
            return new DebugProcessor(resource, postData, response, thread, server, requestHeader);
        }
        URL url = ProcessorFactory.computeRemoteURL(resource, server);
        ResponseInfo info = ProcesserUtil.getResponseInfo(url, method, postData, requestHeader);
        String contentType = info.getContentType();
        if (info.getResponseHeader() != null && info.getResponseHeader().containsKey("Location")) {
            response.writeHTMLHeader(null, info.getResponseHeader());
            response.close();
            return null;
        }
        if (contentType != null && contentType.indexOf("text/javascript") > -1) {
            return new ScriptProcessor(resource, postData, response, thread, server, requestHeader, info);
        }
        if (contentType != null && contentType.indexOf("text/html") > -1) {
            return new HtmlPageProcessor(resource, postData, response, thread, server, requestHeader, info);
        }
        return new ResourceProcessor(resource, method, postData, response, thread, server, requestHeader, info);
    }

    private static URL computeRemoteURL(String resource, IDebugServer server) {
        String path = resource.replace(server.getLocalBaseUrl(), "");
        try {
            return new URL(server.getRemoteBaseUrl(), path);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

