/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.model;

import org.ayound.js.debug.model.JsDebugStackFrame;
import org.ayound.js.debug.model.JsValue;
import org.ayound.js.debug.model.JsVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public class JsErrorStackFrame
extends JsDebugStackFrame {
    public JsErrorStackFrame(IThread thread, IDebugTarget target, ILaunch launch) {
        super(thread, target, launch);
    }

    public void setErrorMsg(String msg) {
        JsValue value = new JsValue(this.getDebugTarget(), this.getLaunch(), this);
        value.setReferenceTypeName("error");
        value.setValueString(msg);
        JsVariable var = new JsVariable("error", this.getDebugTarget(), this.getLaunch());
        try {
            var.setValue(value);
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
        this.setVariables(new IVariable[]{var});
    }

    public String getName() throws DebugException {
        return "<error>" + this.getResource() + "[" + this.getLineNumber() + "]";
    }

    public boolean canResume() {
        return false;
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean canStepOver() {
        return false;
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean canTerminate() {
        return false;
    }
}

