/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.server;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.ayound.js.debug.server.IDebugServer;
import org.ayound.js.debug.server.IServerProcessor;
import org.ayound.js.debug.server.JsDebugResponse;
import org.ayound.js.debug.server.ResponseInfo;
import org.eclipse.debug.core.model.IThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProcessor
implements IServerProcessor {
    private String requestUrl;
    private String postData;
    private JsDebugResponse response;
    private IThread thread;
    private IDebugServer server;
    private Map<String, String> requestHeader;
    private ResponseInfo info;

    public AbstractProcessor(String requestUrl, String postData, JsDebugResponse response, IThread thread, IDebugServer server, Map<String, String> requestHeader, ResponseInfo info) {
        this.requestUrl = requestUrl;
        this.postData = postData;
        this.response = response;
        this.thread = thread;
        this.server = server;
        this.requestHeader = requestHeader;
        this.info = info;
    }

    @Override
    public abstract void process();

    public String getPostData() {
        return this.postData;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public JsDebugResponse getResponse() {
        return this.response;
    }

    public IDebugServer getServer() {
        return this.server;
    }

    public IThread getThread() {
        return this.thread;
    }

    public URL computeRemoteURL() {
        String path = this.requestUrl.replace(this.server.getLocalBaseUrl(), "");
        try {
            return new URL(this.server.getRemoteBaseUrl(), path);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Map<String, String> getRequestHeader() {
        return this.requestHeader;
    }

    public ResponseInfo getInfo() {
        return this.info;
    }
}

