/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.server;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.mozilla.intl.chardet.HtmlCharsetDetector;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;

public class CharsetDetector {
    private String charset;

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void detect(InputStream inputStream) {
        nsICharsetDetectionObserver charsetDetectObserver = new nsICharsetDetectionObserver(){

            public void Notify(String charset) {
                HtmlCharsetDetector.found = true;
                CharsetDetector.this.setCharset(charset);
            }
        };
        nsDetector detector = new nsDetector(2);
        detector.Init(charsetDetectObserver);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        try {
            try {
                String[] charsets;
                byte[] buffer = new byte[1024];
                boolean done = false;
                boolean isAscii = true;
                boolean found = false;
                int len = 0;
                while ((len = bufferedInputStream.read(buffer, 0, buffer.length)) != -1) {
                    if (isAscii) {
                        isAscii = detector.isAscii(buffer, len);
                    }
                    if (isAscii || done) continue;
                    done = detector.DoIt(buffer, len, false);
                }
                detector.DataEnd();
                if (isAscii) {
                    if (this.charset == null) {
                        this.setCharset("UTF-8");
                    }
                    found = true;
                }
                if (!found && this.charset == null && (charsets = detector.getProbableCharsets()).length > 0) {
                    this.setCharset(charsets[0]);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                bufferedInputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void detect(String fileName) {
        try {
            this.detect(new FileInputStream(fileName));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void detect(File file) {
        try {
            this.detect(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void detect(IFile file) {
        InputStream stream = null;
        try {
            try {
                stream = file.getContents();
                this.detect(stream);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

