/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.server;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.ayound.js.debug.server.IDebugServer;
import org.ayound.js.debug.server.IServerProcessor;
import org.ayound.js.debug.server.JsDebugResponse;
import org.ayound.js.debug.server.ProcessorFactory;
import org.eclipse.debug.core.model.IThread;

public class JsConnectionThread
extends Thread {
    private Socket connection;
    private IThread thread;
    private IDebugServer server;

    public JsConnectionThread(Socket conn, IThread thread, IDebugServer server) {
        this.connection = conn;
        this.thread = thread;
        this.server = server;
        this.start();
    }

    public static String unescape(String src) {
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length());
        int lastPos = 0;
        int pos = 0;
        while (lastPos < src.length()) {
            pos = src.indexOf("%", lastPos);
            if (pos == lastPos) {
                char ch;
                if (src.charAt(pos + 1) == 'u') {
                    ch = (char)Integer.parseInt(src.substring(pos + 2, pos + 6), 16);
                    tmp.append(ch);
                    lastPos = pos + 6;
                    continue;
                }
                ch = (char)Integer.parseInt(src.substring(pos + 1, pos + 3), 16);
                tmp.append(ch);
                lastPos = pos + 3;
                continue;
            }
            if (pos == -1) {
                tmp.append(src.substring(lastPos));
                lastPos = src.length();
                continue;
            }
            tmp.append(src.substring(lastPos, pos));
            lastPos = pos;
        }
        return tmp.toString();
    }

    public void run() {
        try {
            int contentLength = 0;
            HashMap<String, String> requestHeader = new HashMap<String, String>();
            String postData = "";
            if (this.connection != null) {
                JsDebugResponse response;
                IServerProcessor processor;
                String recieved;
                InputStream is = this.connection.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String requestLine = br.readLine();
                StringTokenizer tokens = new StringTokenizer(requestLine);
                String method = tokens.nextToken();
                String resource = requestLine.substring(requestLine.indexOf(47), requestLine.lastIndexOf(47) - 5);
                while ((recieved = br.readLine()) != null && recieved.length() != 0) {
                    if (recieved.trim().equals("")) break;
                    if (!recieved.toLowerCase().startsWith("content-length:") || recieved.length() <= 16) continue;
                    contentLength = Integer.parseInt(recieved.substring(16));
                }
                StringBuffer buffer = new StringBuffer();
                if ("POST".equalsIgnoreCase(method) && contentLength > 0) {
                    int i = 0;
                    while (i < contentLength) {
                        buffer.append((char)br.read());
                        ++i;
                    }
                    postData = JsConnectionThread.unescape(buffer.toString());
                }
                if ((processor = ProcessorFactory.createProcessor(resource, method, postData, response = new JsDebugResponse(this.connection.getOutputStream(), this.connection, this.server.getJsResourceManager()), this.thread, this.server, requestHeader)) != null) {
                    processor.process();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IDebugServer getServer() {
        return this.server;
    }
}

