/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.ayound.js.debug.resource.JsResourceManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsDebugResponse {
    private PrintWriter out;
    private Socket client;
    private OutputStream outPutStream;
    private JsResourceManager jsManager;

    public JsDebugResponse(OutputStream outPutStream, Socket client, JsResourceManager manager) {
        this.client = client;
        this.outPutStream = outPutStream;
        this.jsManager = manager;
        try {
            this.out = new PrintWriter(this.client.getOutputStream(), true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isClosed() {
        return this.client.isClosed();
    }

    public void writeHTMLHeader(String encoding, Map<String, List<String>> responseHeader) {
        if (responseHeader != null) {
            if (responseHeader.containsKey("Location")) {
                this.out.println("HTTP/1.0 301 Moved Permanently");
            } else {
                this.out.println("HTTP/1.0 200 OK");
            }
            for (Map.Entry<String, List<String>> entry : responseHeader.entrySet()) {
                if (entry.getKey() == null || "Content-Length".equals(entry.getKey())) continue;
                String value = Arrays.toString(entry.getValue().toArray());
                value = value.substring(1, value.length() - 1);
                if ("Location".equals(entry.getKey())) {
                    String localUrl = this.getJsManager().getServer().getLocalBaseUrl();
                    try {
                        URL locationUrl = new URL(value);
                        value = String.valueOf(localUrl) + locationUrl.getPath();
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
                this.out.println(String.valueOf(entry.getKey()) + ":" + value);
            }
        } else {
            this.out.println("HTTP/1.0 200 OK");
            if (encoding == null) {
                this.out.println("Content-Type:text/html;");
            } else {
                this.out.println("Content-Type:text/html;charset=" + encoding);
            }
        }
        this.out.println();
    }

    public void writeJsHeader(String encoding) {
        this.out.println("HTTP/1.0 200 OK");
        if (encoding == null) {
            this.out.println("Content-Type:text/javascript;");
        } else {
            this.out.println("Content-Type:text/javascript;charset=" + encoding);
        }
        this.out.println();
    }

    public void writeOtherHeader(String fileName, String encoding, Map<String, List<String>> responseHeader, int length) {
        fileName = fileName.toLowerCase();
        this.out.println("HTTP/1.0 200 OK");
        if (responseHeader != null) {
            for (Map.Entry<String, List<String>> entry : responseHeader.entrySet()) {
                String key = entry.getKey();
                if (key == null) continue;
                String value = Arrays.toString(entry.getValue().toArray());
                value = value.substring(1, value.length() - 1);
                this.out.println(String.valueOf(key) + ":" + value);
            }
        } else if (fileName.endsWith("gif")) {
            this.out.println("Content-Type:image/gif");
        } else if (fileName.endsWith("png")) {
            this.out.println("Content-Type:image/png");
        } else if (fileName.endsWith("jpg") || fileName.endsWith("jpeg")) {
            this.out.println("Content-Type:image/jpeg");
        } else if (fileName.endsWith("bmp")) {
            this.out.println("Content-Type:image/bmp");
        } else if (fileName.endsWith("css")) {
            this.out.println("Content-Type:text/css");
        }
        this.out.println();
    }

    public void write(String str) {
        if (!this.client.isClosed()) {
            this.out.write(str);
        }
    }

    public void writeln(String str) {
        if (!this.client.isClosed()) {
            this.out.write(String.valueOf(str) + "\n");
        }
    }

    public void writeln(String str, String encoding) {
        OutputStreamWriter writer = null;
        try {
            this.outPutStream.flush();
            writer = new OutputStreamWriter(this.outPutStream, encoding);
            writer.write(String.valueOf(str) + "\n");
            writer.flush();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.out.close();
        try {
            this.outPutStream.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            this.client.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeResume() {
        StringBuffer buffer = new StringBuffer("{COMMAND:'BREAKPOINT',BREAKPOINTS:{");
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = manager.getBreakpoints();
        int n = 0;
        int n2 = iBreakpointArray.length;
        while (n < n2) {
            IBreakpoint point = iBreakpointArray[n];
            try {
                if (point.isEnabled()) {
                    String resource = this.jsManager.getResourceByFile((IFile)point.getMarker().getResource());
                    int line = point.getMarker().getAttribute("lineNumber", 0);
                    buffer.append("'").append(resource).append(line).append("':true,");
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n;
        }
        buffer.append("'end':false}}");
        this.write(buffer.toString());
    }

    public void writeTerminate() {
        this.write("{COMMAND:'TERMINATE'}");
    }

    public void writeStepOver() {
        this.write("{COMMAND:'STEPOVER'}");
    }

    public void writeStepReturn() {
        this.write("{COMMAND:'STEPRETURN'}");
    }

    public void writeStepInTo() {
        this.write("{COMMAND:'STEPINTO'}");
    }

    public OutputStream getOutPutStream() {
        return this.outPutStream;
    }

    public JsResourceManager getJsManager() {
        return this.jsManager;
    }

    public void writeExpression(String expression) {
        this.write("{COMMAND:'EXPRESSION',\"EXPRESSION\":\"" + expression.replace("\"", "\\\"") + "\"}");
    }

    public void writeValue(String expression) {
        this.write("{COMMAND:'VALUE',\"EXPRESSION\":\"" + expression.replace("\"", "\\\"") + "\"}");
    }
}

