/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.model;

import java.util.ArrayList;
import org.ayound.js.debug.model.JsDebugElement;
import org.ayound.js.debug.model.JsDebugThread;
import org.ayound.js.debug.server.JsDebugServer;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;

public class JsDebugTarget
extends JsDebugElement
implements IDebugTarget {
    private JsDebugServer server;
    IThread[] threads = new IThread[0];

    public JsDebugTarget(JsDebugServer server, ILaunch lanuch) {
        super(null, lanuch);
        this.server = server;
    }

    public String getName() throws DebugException {
        return "JavaScript Debug [" + this.server.getPort() + "]";
    }

    public IProcess getProcess() {
        return null;
    }

    public IThread[] getThreads() throws DebugException {
        return this.threads;
    }

    public boolean hasThreads() throws DebugException {
        return this.threads != null && this.threads.length > 0;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return false;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public void terminate() throws DebugException {
        this.setTerminated(true);
        this.server.stop();
        this.fireTerminateEvent();
    }

    public boolean canResume() {
        return false;
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean isSuspended() {
        return false;
    }

    public void resume() throws DebugException {
    }

    public void suspend() throws DebugException {
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void addThread(JsDebugThread jsThread) {
        ArrayList<IThread> list = new ArrayList<IThread>();
        IThread[] iThreadArray = this.threads;
        int n = 0;
        int n2 = iThreadArray.length;
        while (n < n2) {
            IThread thread = iThreadArray[n];
            list.add(thread);
            ++n;
        }
        list.add(jsThread);
        this.threads = list.toArray(new IThread[list.size()]);
        this.fireCreationEvent();
        this.fireChangeEvent(256);
        this.fireSuspendEvent(16);
    }

    public JsDebugServer getServer() {
        return this.server;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }
}

