/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.ayound.js.debug.model.JsDebugElement;
import org.ayound.js.debug.model.JsDebugStackFrame;
import org.ayound.js.debug.model.JsDebugTarget;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsDebugThread
extends JsDebugElement
implements IThread {
    private IStackFrame[] stackFrames = new IStackFrame[0];
    private Set<String> debugExpressions = new HashSet<String>();

    public JsDebugThread(IDebugTarget target, ILaunch launch) {
        super(target, launch);
    }

    public String getName() throws DebugException {
        IDebugTarget target = this.getDebugTarget();
        if (target instanceof JsDebugTarget) {
            return "Thread [" + ((JsDebugTarget)target).getServer().getRemoteBaseUrl() + "]";
        }
        return "Thread ";
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        return this.stackFrames;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        if (this.hasStackFrames()) {
            return this.stackFrames[0];
        }
        return null;
    }

    public void addExpression(String expression) {
        this.debugExpressions.add(expression);
    }

    public void removeExpression(String expression) {
        this.debugExpressions.remove(expression);
    }

    public boolean hasStackFrames() throws DebugException {
        return this.stackFrames != null && this.stackFrames.length > 0;
    }

    public boolean canResume() {
        try {
            if (this.getTopStackFrame() != null) {
                return this.getTopStackFrame().canResume();
            }
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean isSuspended() {
        return false;
    }

    public void resume() throws DebugException {
        if (this.getTopStackFrame() != null) {
            this.getTopStackFrame().resume();
        }
    }

    public void suspend() throws DebugException {
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean canStepOver() {
        return false;
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return false;
    }

    public void stepInto() throws DebugException {
    }

    public void stepOver() throws DebugException {
    }

    public void stepReturn() throws DebugException {
    }

    public boolean canTerminate() {
        try {
            if (this.getTopStackFrame() != null) {
                return this.getTopStackFrame().canTerminate();
            }
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void terminate() throws DebugException {
        if (this.getTopStackFrame() != null) {
            this.getTopStackFrame().terminate();
        }
    }

    public void clearStackFrame() {
        ArrayList list = new ArrayList();
        this.stackFrames = list.toArray(new IStackFrame[list.size()]);
        this.fireResumeEvent(8);
        this.fireSuspendEvent(16);
        this.fireChangeEvent(512);
    }

    public void addStackFrame(JsDebugStackFrame frame) {
        ArrayList<IStackFrame> list = new ArrayList<IStackFrame>();
        list.add(frame);
        IStackFrame[] iStackFrameArray = this.stackFrames;
        int n = 0;
        int n2 = iStackFrameArray.length;
        while (n < n2) {
            IStackFrame stackFrame = iStackFrameArray[n];
            list.add(stackFrame);
            ++n;
        }
        this.stackFrames = list.toArray(new IStackFrame[list.size()]);
        this.fireResumeEvent(8);
        this.fireSuspendEvent(16);
        this.fireChangeEvent(512);
    }

    public Set<String> getDebugExpressions() {
        return this.debugExpressions;
    }
}

