/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.model;

import org.ayound.js.debug.model.JsDebugStackFrame;
import org.ayound.js.debug.model.JsVariable;
import org.ayound.js.debug.model.ValueUtil;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.swt.widgets.Display;

public class JsValue
implements IValue {
    private IVariable[] variables;
    private String referenceTypeName;
    private IDebugTarget target;
    private ILaunch launch;
    private JsDebugStackFrame frame;
    private String valueString;
    private JsVariable parentVar;

    public JsValue(IDebugTarget target, ILaunch launch, JsDebugStackFrame frame) {
        this.target = target;
        this.launch = launch;
        this.frame = frame;
    }

    public void setVariables(IVariable[] variables) {
        this.variables = variables;
    }

    public void setReferenceTypeName(String referenceTypeName) {
        this.referenceTypeName = referenceTypeName;
    }

    public void setValueString(String valueString) {
        this.valueString = valueString;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.referenceTypeName;
    }

    public String getValueString() throws DebugException {
        return this.valueString;
    }

    public synchronized IVariable[] getVariables() throws DebugException {
        if (this.variables != null) {
            return this.variables;
        }
        if (this.frame.isExecuted() || this.frame.isTerminated()) {
            return new IVariable[0];
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ValueUtil.getUpdateValue(JsValue.this, JsValue.this.frame);
            }
        });
        while (this.variables == null) {
        }
        return this.variables;
    }

    public boolean hasVariables() throws DebugException {
        if ("object".equals(this.getReferenceTypeName())) {
            if (this.variables == null) {
                return true;
            }
            return this.variables.length > 0;
        }
        return false;
    }

    public boolean isAllocated() throws DebugException {
        return false;
    }

    public IDebugTarget getDebugTarget() {
        return this.target;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public String getModelIdentifier() {
        return "org.ayound.js.debug.model";
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public JsVariable getParentVar() {
        return this.parentVar;
    }

    public void setParentVar(JsVariable parentVar) {
        this.parentVar = parentVar;
    }
}

