/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.model;

import java.util.ArrayList;
import org.ayound.js.debug.model.JsDebugStackFrame;
import org.ayound.js.debug.model.JsValue;
import org.ayound.js.debug.model.JsVariable;
import org.ayound.js.debug.model.VariableUtil;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;

public class ValueUtil {
    private static JsValue value = null;
    private static JsDebugStackFrame frame = null;

    public static synchronized void updateValue(String string) {
        if (value != null) {
            IVariable[] vars = VariableUtil.createVarsByObject(string, frame.getDebugTarget(), frame.getLaunch(), frame, value.getParentVar());
            if (vars == null) {
                vars = new IVariable[]{};
            }
            value.setVariables(vars);
        }
    }

    public static synchronized void getUpdateValue(JsValue value, JsDebugStackFrame frame) {
        ValueUtil.value = value;
        ValueUtil.frame = frame;
        ArrayList<String> pathList = new ArrayList<String>();
        JsVariable var = value.getParentVar();
        try {
            pathList.add(var.getName());
        }
        catch (DebugException e1) {
            e1.printStackTrace();
        }
        if (var != null) {
            while (var.getParentVar() != null) {
                var = var.getParentVar();
                try {
                    pathList.add(var.getName());
                }
                catch (DebugException e) {
                    e.printStackTrace();
                }
            }
            StringBuffer buffer = new StringBuffer();
            int i = pathList.size() - 1;
            while (i > -1) {
                if (i == pathList.size() - 1) {
                    buffer.append((String)pathList.get(i));
                } else {
                    buffer.append("[\"" + (String)pathList.get(i) + "\"]");
                }
                --i;
            }
            String path = buffer.toString();
            if (path.length() > 0) {
                frame.writeValue(path);
            } else {
                value.setVariables(new IVariable[0]);
            }
        } else {
            value.setVariables(new IVariable[0]);
        }
    }

    public static JsDebugStackFrame getStackFrame() {
        return frame;
    }
}

