/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.script;

public class ScriptCompileUtil {
    public static String compileJsLine(String[] lines, String resourcePath, int index) {
        String jsLine = lines[index];
        return ScriptCompileUtil.compileOneLine(jsLine, lines, resourcePath, index);
    }

    private static String compileOneLine(String jsLine, String[] lines, String resourcePath, int index) {
        int firstColon = jsLine.indexOf(58);
        if (firstColon > 0 && firstColon < jsLine.length() - 2) {
            if (jsLine.trim().startsWith("case ")) {
                int caseOffset = jsLine.indexOf(58);
                if (caseOffset > 0) {
                    String caseLine = String.valueOf(jsLine.substring(0, caseOffset + 1)) + ScriptCompileUtil.getdebugString(lines, resourcePath, index) + ";";
                    if (caseOffset < jsLine.length()) {
                        caseLine = String.valueOf(caseLine) + jsLine.substring(caseOffset + 1);
                    }
                    return caseLine;
                }
                return jsLine;
            }
            String beforeColon = jsLine.substring(0, firstColon).trim();
            boolean isColonLine = true;
            if (beforeColon.startsWith("'") && beforeColon.endsWith("'")) {
                isColonLine = true;
            } else if (beforeColon.startsWith("\"") && beforeColon.endsWith("\"")) {
                isColonLine = true;
            } else {
                if (beforeColon.equals("default")) {
                    String defaultLine = String.valueOf(jsLine.substring(0, firstColon + 1)) + ScriptCompileUtil.getdebugString(lines, resourcePath, index) + ";";
                    return defaultLine;
                }
                int i = 0;
                while (i < beforeColon.length()) {
                    char ch = beforeColon.charAt(i);
                    if (!Character.isLetterOrDigit(ch) && ch != '_' && ch != '$') {
                        isColonLine = false;
                    }
                    ++i;
                }
            }
            if (isColonLine) {
                return "$jsd:" + ScriptCompileUtil.getdebugString(lines, resourcePath, index) + "," + jsLine;
            }
        } else if (index > 1) {
            String lastLine = lines[index - 1];
            if (((lastLine = lastLine.replaceAll("//.*", "").replaceAll("/\\*.*\\*/", "").trim()).startsWith("if") || lastLine.startsWith("else if")) && !lastLine.endsWith("{") && !jsLine.startsWith("{")) {
                boolean isIfLine = true;
                int bracket = 0;
                int i = 0;
                while (i < lastLine.length() - 1) {
                    char ch = lastLine.charAt(i);
                    if (ch == '(') {
                        --bracket;
                    } else if (ch == ')' && ++bracket == 0) {
                        isIfLine = false;
                    }
                    ++i;
                }
                if (isIfLine) {
                    return "if(" + ScriptCompileUtil.getdebugString(lines, resourcePath, index) + "||true)" + jsLine;
                }
            } else if (lastLine.equals("else")) {
                return "if(" + ScriptCompileUtil.getdebugString(lines, resourcePath, index) + "||true)" + jsLine;
            }
        }
        return String.valueOf(ScriptCompileUtil.getdebugString(lines, resourcePath, index)) + ";" + jsLine;
    }

    private static String getdebugString(String[] lines, String resourcePath, int index) {
        String debugStr = "$jsd('" + resourcePath + "'," + (index + 1) + ",this,((typeof(arguments)!=\"undefined\"?arguments:null)),function(__text){return eval(__text);})";
        return debugStr;
    }

    public static String compileHtmlLine(String[] lines, String resourcePath, int index) {
        StringBuffer buffer = new StringBuffer();
        String htmlLine = lines[index];
        int scriptOffset = htmlLine.toLowerCase().indexOf("<script");
        String preLine = "";
        String lastLine = htmlLine;
        if (scriptOffset >= 0) {
            preLine = htmlLine.substring(0, scriptOffset + 7);
            lastLine = htmlLine.substring(scriptOffset + 7);
            buffer.append(preLine);
        }
        if (lastLine.trim().startsWith("<")) {
            return htmlLine;
        }
        int offset = lastLine.indexOf(62);
        if (offset >= 0) {
            buffer.append(lastLine.substring(0, offset));
            if (!buffer.toString().toLowerCase().contains("<script")) {
                int i = index - 1;
                while (i >= 0) {
                    String line = lines[i];
                    int offsetScript = line.toLowerCase().indexOf("<script");
                    if (offsetScript > -1) {
                        buffer.append(line.substring(offsetScript));
                        break;
                    }
                    buffer.append(line);
                    --i;
                }
            }
            htmlLine = buffer.toString().contains(">") ? (scriptOffset >= 0 ? String.valueOf(preLine) + lastLine.substring(0, offset + 1) + ScriptCompileUtil.getdebugString(lines, resourcePath, index) + ";" + lastLine.substring(offset + 1) : String.valueOf(preLine) + ScriptCompileUtil.compileOneLine(lastLine, lines, resourcePath, index)) : String.valueOf(preLine) + lastLine.substring(0, offset + 1) + ScriptCompileUtil.getdebugString(lines, resourcePath, index) + ";" + lastLine.substring(offset + 1);
        } else {
            htmlLine = ScriptCompileUtil.compileOneLine(htmlLine, lines, resourcePath, index);
        }
        return htmlLine;
    }
}

