/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.ayound.js.debug.core.JsDebugCorePlugin;
import org.ayound.js.debug.engine.EngineManager;
import org.ayound.js.debug.engine.IJsEngine;
import org.ayound.js.debug.model.JsDebugTarget;
import org.ayound.js.debug.model.JsDebugThread;
import org.ayound.js.debug.model.JsErrorStackFrame;
import org.ayound.js.debug.resource.JsResourceManager;
import org.ayound.js.debug.server.IDebugServer;
import org.ayound.js.debug.server.JsConnectionThread;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IWatchExpressionListener;

public class JsDebugServer
implements IDebugServer {
    ServerSocket serverSocket;
    private boolean running = false;
    private ILaunch launch;
    private int port;
    private JsDebugTarget target;
    private JsDebugThread thread;
    private URL remoteUrl;
    private IJsEngine jsEngine;
    private JsResourceManager jsManager;
    private Set<String> resources = new HashSet<String>();
    private String defaultEncoding;
    private int debugLine = 0;
    private Set<String> htmlPage = new HashSet<String>();
    private IWatchExpressionListener evalListener;

    public JsDebugServer(ILaunch launch, ServerSocket socketServer, URL remoteUrl, JsResourceManager jsManager) {
        this.launch = launch;
        this.serverSocket = socketServer;
        this.port = socketServer.getLocalPort();
        this.remoteUrl = remoteUrl;
        this.jsManager = jsManager;
        this.jsManager.setServer(this);
    }

    protected void startRun() {
        new Thread(){

            public void run() {
                while (JsDebugServer.this.isRunning()) {
                    try {
                        Socket conn = JsDebugServer.this.serverSocket.accept();
                        new JsConnectionThread(conn, JsDebugServer.this.getThread(), JsDebugServer.this);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }

    public boolean isRunning() {
        return this.running;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public int getPort() {
        return this.port;
    }

    public void stop() {
        for (String resource : this.resources) {
            JsDebugCorePlugin.getDefault().removeResource(resource, this);
        }
        this.jsManager.clear();
        this.running = false;
        try {
            this.serverSocket.close();
            JsDebugCorePlugin.getDefault().removePort(this.port);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JsDebugThread getThread() {
        return this.thread;
    }

    public JsDebugTarget getTarget() {
        return this.target;
    }

    public String getLocalBaseUrl() {
        return "http://localhost:" + this.port;
    }

    public URL getRemoteBaseUrl() {
        return this.remoteUrl;
    }

    public boolean start() {
        try {
            this.target = new JsDebugTarget(this, this.launch);
            this.thread = new JsDebugThread(this.target, this.launch);
            this.target.addThread(this.thread);
            this.launch.addDebugTarget((IDebugTarget)this.target);
            this.jsEngine = EngineManager.getEngine();
        }
        catch (Exception exception) {
            return false;
        }
        this.running = true;
        this.startRun();
        return true;
    }

    public IJsEngine getJsEngine() {
        return this.jsEngine;
    }

    public String[] getResources() {
        return this.resources.toArray(new String[this.resources.size()]);
    }

    public void addResource(String resource) {
        JsDebugCorePlugin.getDefault().addResource(resource, this);
        this.resources.add(resource);
    }

    public JsResourceManager getJsResourceManager() {
        return this.jsManager;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void compileError(String errorMsg, String resorce, int line) {
        JsErrorStackFrame frame = new JsErrorStackFrame(this.thread, this.target, this.launch);
        frame.setResource(resorce);
        frame.setLineNum(line);
        frame.setErrorMsg(errorMsg);
        this.thread.addStackFrame(frame);
    }

    public void setDebugLine(int line) {
        this.debugLine = line;
    }

    public int getDebugLine() {
        return this.debugLine;
    }

    public void addHtmlPage(String resource) {
        this.htmlPage.add(resource);
    }

    public boolean isHtmlPage(String resource) {
        return this.htmlPage.contains(resource);
    }
}

