/*!
*
* mi v 1.0.8
* By Darrel.Hsu ShenYong.Chen mingelz
* 
* CopyRight 2011-2012 , web@miliao.com
* 2012-03-17
*
*/

;;(function(G){
  M = G.M ||  {} ;
  M.tid = 100;
  
  M.UA = navigator.userAgent.toLowerCase() ;
  var DOC = document;
  
 
  M.genId = function( pre ){
    pre = pre || 'MID-';
    return pre + "" + this.tid++ ; 
  };
  
  M.isIE = !!window.ActiveXObject ;

  M.ability = {
    placeholder:function(){ return 'placeholder' in DOC.createElement("input"); }(),
    flash:function(){
        var plg = navigator.plugins ;
        return plg.length > 0 && function(){
            for(var i=0,p;p=plg[i++];){
	      if( p.name.toLowerCase().indexOf("shockwave flash") > -1 ){
	        return true;
	      }
	    }
	    return false;
          }() ;
    }(),
    audioMp3Supported:function(){
      if( typeof HTMLAudioElement === 'function' || typeof HTMLAudioElement === 'object' ){
        var a = new Audio();
        return a.canPlayType("audio/mpeg");
      }
      return false;
    }(),
    localStorage:function(){
      return !!window.localStorage;
    }(),
    fixedSupport:function(){
      var div = DOC.createElement("div") ,
          divstyle = div.style ;
      divstyle.cssText = "position:absolute;position:fixed;"
      return divstyle['position'] == 'fixed';
    }()
  };

  M.isMaxthon3 = function(){
    return !!window.MxActiveXObject 
           && window.navigator.appVersion.toLowerCase().indexOf("maxthon") > -1 ; 
  }();

  M.isEmptyObject = function( obj ){
    return ( typeof obj === 'object' ) && function(){
      for(var p in obj ){}
      return p === undefined ;
    }();
  };

  /*
  * 参数化url
  * author Darrel.Hsu
  */
  M.params = function( u ){
    u = u || location.search;
    /*
    * 如果u为undefined则使用location.search
    * 如果两个都没有，就返返回一个false
    */
    if( !u ){ return false; }
    var p = u.split("\?");
    var o = {};
    p = p.length ==2 ? p[1] : p[0];
    var list = p.split("\&");
    for( var i=0; i<list.length; i++ ){
      var m = list[i];
      m = m.split("\=");
      o[m[0]] = m.slice(1,m.length).join("=") || "";
    }
    return o ;
  };

  M.decodeParams = function ( para ){
    if( typeof para !== 'object' ){
      return para;
    }else{
      var html = [];
      for(var p in para ){
        html.push( p + "=" + encodeURIComponent( para[p]) );
      }
      return html.join("&");
    }
  }
  /*
  * @author darrel
  * @params [html:String,data:JSON ]
  * 模版
  */
  M.template = function( html , data , reg ){
    //1.区别老的模版方法 
    //3.因为不考虑原样返回的问题了，可以定制模版类型。
    var reg = reg ||  /\{([\w-]+)\}/g ;
    return html.replace( reg, function( m , name ){
      if( data[name] !== undefined ){
        var ret ;
        if(data[name] instanceof Function){
          ret =  data[name].call(data);
        }else{
          ret =  data[name];
        }
        return reg.test( ret ) ?  
          M.template( ret , data , reg ) : ret ;                  
      }else{
        //2.原来的方法中对未处理的模版原样返回，
	//2.但存在模版死循环的风险
        return "" ;
      }
    });
  };
  /*
  *@author darrel
  *@params [url:URL]
  * 返回当前url或设置转跳 
  */
  M.locate = function( url ){
    if(!!!url){
      return window.location.href;
    }else{
      window.location.href = url;
    }
  };
  /*
  *类方法重载
  *如果想针对某类进行扩展方法或重载可以用这个方法
  * eg.
  * <code>
  *   M.override( M.Object , {
  *     test:function(){
  *       // to do
  *     }
  *   })
  * </code>
  * 这样M.Object就有了test方法
  */
  M.override = function( origclass , overrides ){
    if( overrides ){
      //$.extend( origclass.prototype , overrides )
      for(var p in overrides){
         origclass.prototype[p] = overrides[p];
	 //把方法或属性写入原型链之中
	 //如果原型链中已经有这个属性或方法则会覆盖，
	 //否则就是新增
      }
    }
  };
 
  //类的继承方法
  M.extend = function( superclass , subclass ){
    var F = function(){ } , 
      sb  = subclass ,
      sbp ,
      overrides = sb ,
      spp = superclass.prototype ;
    var oc = Object.prototype.constructor;
    /*if( typeof subclass == 'object'){
      /*
      * 如果subclass没有构造函数（typeof {} == 'object' ,
      * typeof function(){} == 'function'）
      * 需要给 sublcass指定一个构造。
      * 如果父类存在且有构造，就直接使用父类的将构造
      * 否则就使用黙认的构造（这个构造以认为传入
      * 的数参为一个或多个Object，然后依次将Object的属性
      * 拷呗到subclass中来）
      * 
      *
      sb  =  superclass.constructor == oc ? 
          subclass.constructor : 
          function( ){ 
            //for( var i=0; i<arguments.length; i++ ){
              var p = arguments[0];
              //$.extend( this, p );
              for(var pt in p){
                this[pt] = p[pt];
              }
              if( 'init' in this && this['init'] instanceof Function){
                this.init();
              }
            //}
          };
    /*}*/
    sb = sb.constructor !== oc ?
      sb.constructor :
      function(){
        var arg = arguments[0];
        for(var p in arg){
          this[p] = arg[p]
        }
        if( 'init' in this && this['init'] instanceof Function ){
          this.init();
        }
      };
    F.prototype = spp; /* 把父类的prototype传过来 */
    sbp = sb.prototype = new F(); /* sbp -- subclass.prototype 通过new F()形成原型链*/
    sbp.constructor = sb ;/*重置构造引用，防止 instanceof 链接断开*/
    /*if( spp.constructor == oc ){
      spp.constructor = superclass ;
    }*/
    sbp.override = function( o ){
      M.override( sb , o );
    }
    sb.extend = function( o ){
      return M.extend( sb , o );
    } /*扩展子类，为其增加extend方法方便扩展*/
    M.override(  sb , overrides );
    return sb; 
  };
  
  M.Object = M.extend( {} ,{
    /*
     *
     *
     *
     *
     *
     */
    on:function( e , fun ){
      if( e.indexOf(",") > -1 ){
          var es = e.split(",");
          for(var i=0;i<es.length;i++){
              this.on( es[i] , fun );
          }
      }else{
        var ev =  ( this.evts = this.evts || {}  )[e];
        ev = ev || (this.evts[e] = [] );
        ev.push(fun) ;
     }
    },
    fire:function(ev){
      this.evts = this.evts || {};
      var args = Array.prototype.slice.call( arguments ,0 );
      args.shift();
      var  fun = this.evts[ev] ;
      if( fun instanceof Array ){
        for(var i=0,p;p=fun[i++];){
          this.eventTag = ev ;
          p.apply( this , args );
        }
      }
    },
    un:function(e  ,fun){
      this.evts = this.evts || {};
      var ev = this.evts[e];
      if( ev ){
        if( !!fun ){
          for(var i =0 , p ; p = ev[i++] ; ){
            if( fun === p ){
              ev.splice( i-1 ,1 );
              i-- ;
            }
          }
        }else{
           this.evts[e] = null ;
        }
      }
    }
  });
  
  M.merge = function( o , p ){
    for(var attr in p ){
      o[ attr ] = p[ attr ];
    }
    return o ;
  } ;

  M.applyIf = M.applyIf || function ( o, p ){
    if(arguments[2]){
      for(var i=2;i<arguments.length;i++){
        M.applyIf(o,arguments[i])
      }
    }
    if(o && p && typeof p == 'object'){
      for(var c in p){
        if(o.hasOwnProperty(c)){
          o[c]=p[c]
        }
      }
    }
  };
  M.applyIfNot = function( o , org , keep){
    var Key =" \u2001"
    keep = Key + ( keep || [] ).join( Key ) + Key ;
    for( var p in org ){
      if( !( p in o ) &&  keep.indexOf( Key + p + Key ) <= -1 ){
        o[ p ] = org[p];
      }
    }
  };
}(window));
;
/*
 * 重新调整了代码结构
 * 新的选择器 By Shenyong.Chen 
 * fixed some bug , eg. hasClass
 * El支持事件主动触发
 * 增加Cookie方法的支持
 * 1.0.7.6
 * 增加高级选择器支持
 * 1.0.8.6
 * 优化json代码
 * El增加insertBeforeTarget和insertAfterTarget方法
 * 1.0.9.6
 * 增加delegate与undelegate方法 
 * 优化El的parents方法
 * 优先Els的getAt方法
 * 1.0.9.7
 * 修复IE6和IE7下取From属性可能存在的bug
 * 修改选择器无法选择IE6和IE7下与Form中含有id为"id"的form
*/
M.version = '1.0.9.7'
;;(function( M ){
M.Util = {
  encodeJSON:function( o ){
    if ( typeof o === 'string' ){
      return window.JSON ? JSON.parse( o ) : eval( "(" + o + ')' );
    }else{
      return o ;
    }
  },
  decodeJSON: function (json) {
    if (window.JSON && window.JSON.stringify) {
       return JSON.stringify(json);
     }
     var html = [];
     if(typeof json == 'object') {
       if(json instanceof Array){
         var ar = [];
         html.push("[");
         for(var i = 0; i < json.length; i ++) {
             ar.push(this.decodeJSON(json[i]));
         }
         html.push(ar.join());
         html.push("]");
       } else {
         html.push("{");
         var ar = [];
         for(var p in json) {
             ar.push("\"" + p + "\":" + (this.decodeJSON(json[p])));
         }
         html.push(ar.join());
         html.push("}");
       }
     return html.join("");
   } else {
     if(typeof json !== 'number') {
       return "\"" + ( json || "" ) + "\"";
     } else {
       return json;
     }
   }
  },
  isNaN : function( o ){
    //只有NaN才会自己不等于自己
    return o !== o ;
  },
  getKeys:function( obj ){
    if( Object.getOwnPropertyNames ){
      return Object.getOwnPropertyNames( obj )
    }else{
      var keys = [] , i = 0 ;
      for( keys[i++]  in obj );
      return keys ;
    }
  },
  toArray:function( ar ){
    if( M.isIE ){
      var result = [] ;
      for(var i =0;i<ar.length;i++){
        result.push( ar[i]);
      }
      return result ;
    }else{
      return Array.prototype.slice.call( ar );
    }
  },
  hashParams:function( url ){
    url = ( url || location.hash ).replace(/(^#|#$)/g);
    return M.params( url );
  },
  setCookie:function( name, value, expires, path, domain, secure  ){
    document.cookie = name + "=" + escape(value) +
      ((expires) ? "; expires=" + expires : "") +
      ((path) ? "; path=" + path : "") +
      ((domain) ? "; domain=" + domain : "") +
      ((secure) ? "; secure" : "");
  },
  getCookie:function( name ){
    var key = name + '=',
        klen = key.length,
        carr = document.cookie.split(';');
    for ( var i = 0, tmp; tmp = carr[i++]; ) {
      tmp = tmp.trim();
      if ( key == tmp.substring(0, klen) ) {
        return unescape( tmp.substring( klen ) );
      }
    }
    return '';
  },
  delCookie: function( name, path, domain ){
    M.Util.setCookie( name, '', 'Thu, 01 Jan 1970 00:00:00 GMT', path, domain );
  }
};

M.encode = M.Util.encodeJSON;
/*
 * Array
 */
var Ap = Array.prototype ;
Ap.getAt = function( index ){
  return this[index];
};
Ap.each = function( fun ){
  for(var i=0;i<this.length;i++){
    var result = fun.call( this , i , this[i] );
    if( result === false ){
      return i ;  
    }
  }
};
if( !( 'indexOf' in Ap ) ){
  Ap.indexOf = function( element , i ){
    for (i = i || 0; i < this.length; ++i) {
      if (this[i] === element) {
        return i;
      }
    }
    return -1;
  }
};
Ap.remove = function( item ){
  var i = this.indexOf( item );
  if( i != -1 ) {
    this.splice( i , 1 );
  }
};
/* 
 * String 
 */
  String.prototype.encodeHTML = function () {
    return this.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/"/g, "&quot;");
  };
  String.prototype.decodeHTML = function () {
    return this.replace(/&quot;/g,'"').replace(/&lt;/g,'<').replace(/&gt;/g,'>').replace(/&amp;/g, "&");
  };  

  if( !''.trim ){
    String.prototype.trim = function(){
      return this.replace(/^\s+/,"").replace(/\s+$/,"");
    }   
  };
}( M ));
/* 元素选择器

用法： MSelector( selectors [, context] )
返回值：元素数组

selectors:
支持 tag、id、class 及其组合，空格、>、+、逗号，例如：
div
#d1  取id为d1的元素
div#d1 取id为d1的div
#d1>* 取 #d1 的子元素
#d1,#d2 div>* 取 #d1 及 #d2的后代div的子元素
div.abc.def 取 class含abc和def的div

不去重，例如：
有html：<div id=d1><div><div></div></div></div>
div div 会选出3个div
#d1,#d1 会选出2个#d1
不排序，例如：
有html：<img id=g1><img id=g2>
#g2,#g1 会g2在前

tag、id、class 允许的字符：字母、数字、下划线
允许可选的空格：例如：#d1,#d2>div 可以写成 #d1, #d2 > div

context:
元素 或 document（缺省）


Match Selector
用法：MSelector.match(el1, sel, el2)
返回值：boolean
说明：如果以 el1 为上下文，sel 为选择器，可以找到 el2，返回 true；否则 false。
或者说，从 el1 到 el2，是否存在一条路 sel。

*/
var MSelector = function(document) {
  var fs = {
    '>': children,
    '+': nextEl,
    '~': nextAll,
    '^': prevEl,
    '^^': prevAll,
    '<': parent,
    '<<': parentAll
  };

  var relRev = {
    ' ': '<<',
    '>': '<',
    '+': '^',
    '~': '^^',
    '<': '>',
    '<<': ' ',
    '^': '+',
    '^^': '~'
  };


  var re_sel_parts = /([\s>+~<^]+)([#.*\w-]+)/g;
  var re_simpleSel_parts = /\*|[#.]?[\w-]+/g;

  var testel = document.createElement('div');
  var isByClassSupported = !!testel.getElementsByClassName;
  var contains = testel.contains ? function(a, b) {
    return a != b && a.contains(b);
  } : function(a, b) { return b.compareDocumentPosition(a) & 8; };

  testel = null;

  function parseSelector(s) {
    s = ' ' + s;
    var sel = [], tag, id, cls;

    re_sel_parts.lastIndex = 0;
    for (var sel_parts; sel_parts = re_sel_parts.exec(s); tag = id = cls = null) {
      var combinator = trim(sel_parts[1]) || ' ';
      var simpleSel_parts = sel_parts[2].match(re_simpleSel_parts);
      var ch0 = simpleSel_parts[0].charAt(0);
      var j = (ch0 == '*') ? 1 :
      (ch0 != '#' && ch0 != '.') ? ((tag = simpleSel_parts[0].toUpperCase()), 1) : 0;

      for (; j < simpleSel_parts.length; ++j) {
        var t = simpleSel_parts[j].substr(1);
        if (simpleSel_parts[j].charAt(0) == '#') {
          if (id && id != t) {
            return;
          }
          id = t;
        }
        else {
          (cls || (cls = [])).push(t);
        }
      }

      if (cls) cls.re = reClasses(cls);
      sel.push(combinator, {
        tag: tag,
        id: id,
        cls: cls
      });
    }

    return sel;
  }
  function parseGroup(s) {
    var sels = [];
    var a = s.split(',');
    for (var i = 0; i < a.length; ++i) {
      var t = parseSelector(a[i]);
      if (t) {
        sels.push(t);
      }
    }
    return sels;
  }

  function trim(s) {
    return s.replace(/^\s+|\s+$/g, '');
  }

  function parent(el) {
    el = el.parentNode;
    if (el && el.nodeType == 1) {
      return el;
    }
  }
  function nextEl(el) {
    while (el = el.nextSibling) {
      if (el.nodeType == 1) {
        return el;
      }
    }
  }
  function prevEl(el) {
    while (el = el.previousSibling) {
      if (el.nodeType == 1) {
        return el;
      }
    }
  }

  function nextAll(el, a) {
    while (el = el.nextSibling) {
      if (el.nodeType == 1) {
        a.push(el);
      }
    }
  }
  function prevAll(el, a) {
    while (el = el.previousSibling) {
      if (el.nodeType == 1) {
        a.push(el);
      }
    }
  }
  function parentAll(el, a) {
    while ((el = el.parentNode) && el.nodeType == 1) {
      a.push(el);
    }
  }
  function children(el, a) {
    for (el = el.firstChild; el; el = el.nextSibling) {
      if (el.nodeType == 1) {
        a.push(el);
      }
    }
  }

  function reClasses(a) {
    if (a.length == 1) {
      return RegExp('(?:^|\\s)' + (a[0]) + '(?:\\s|$)');
    }

    var s = '^';
    for (var i = 0; i < a.length; ++i) {
      s += '(?=(?:[\\s\\S]*\\s)?' + (a[i]) + '(?:\\s|$))';
    }
    return RegExp(s);
  }
  function toArray(obj) {
    var a = [];
    for (var i = 0, len = obj.length; i < len; ++i) {
      a[i] = obj[i];
    }
    return a;
  }


  function query(s, ctx) {
    if (typeof ctx == 'string') {
      ctx = query(ctx);
    }
    else {
      if (!ctx) {
        ctx = document;
      }

      switch (ctx.nodeType) {
        case 1:
        case 9:
          ctx = [ctx];
          break;
        default:
          if (ctx.length && ctx[0].nodeType == 1) {
            if (!(ctx instanceof Array)) {
              ctx = toArray(ctx);
            }
          }
          else {
            return [];
          }
      }
    }

    var sels = parseGroup(s);
    var ret = [];

    for (var i = 0; i < sels.length; i++) {
      var a = find(ctx, sels[i]);
      if (a.length) {
        ret = ret.concat(a);
      }
    }
    return ret;
  }

  function getByTag(node, tag) {
    var a = node.getElementsByTagName(tag);
    var b = [], n, i = 0, j, k = 0;
    if (tag == '*' && (n = node.getElementsByTagName('!').length)) {
      for (j = 0; j < n; i++) {
        if (a[i].nodeType == 1) {
          b[k++] = a[i];
        }
        else {
          j++;
        }
      }
    }
    for (n = a.length; i < n; i++) {
      b[k++] = a[i];
    }
    return b;
  }


  function find(context, selector) {
    var relation = selector.shift();
    var simpleSel = selector.shift();
    var tag = simpleSel.tag;
    var id = simpleSel.id;
    var cls = simpleSel.cls;
    var a = [];

    if (id) {
      var t = document.getElementById(id);
      if (t) {
        if (document == context[0]) {
          a.push(t);
        }
        else {
          for (var i = 0; i < context.length; ++i) {
            if (checkRelation(context[i], relation, t)) {
              a.push(t);
              break;
            }
          }
        }
      }
    }
    else {
      if (relation == ' ') {
        if (cls && isByClassSupported) {
          cls = cls.join(' ');
          for (var i = 0; i < context.length; ++i) {
            var t = context[i].getElementsByClassName(cls);
            if (t.length) a = a.concat(toArray(t));
          }
          cls = null;
        }
        else {
          if (!tag) tag = '*';
          for (var i = 0; i < context.length; ++i) {
            var t = getByTag(context[i], tag);
            if (t.length) {
              a = a.concat((t));
            }
          }
          tag = null;
        }
      }
      else {
        var fn = fs[relation];
        if (relation == '+' || relation == '^' || relation == '<') {
          for (var i = 0; i < context.length; ++i) {
            var t = fn(context[i]);
            if (t) {
              a.push(t);
            }
          }
        }
        else {
          for (var i = 0; i < context.length; ++i) {
            fn(context[i], a);
          }
        }
      }
    }
    if (tag || id || cls) {
      var b = [];
      for (var i = 0; i < a.length; ++i) {
        if (testEl(a[i], simpleSel)) {
          b.push(a[i]);
        }
      }
      a = b;
    }
    return a.length && selector.length > 1 ? find(a, selector) : a;
  }

  function testEl(t, sel) {
    var tag = sel.tag;
    var id = sel.id;
    var cls = sel.cls;
    var elid = t.getAttribute("id") ;
    if( !!id ){
      elid =  t.getAttribute("id");
      if( typeof elid == "object" ){
        elid = t.getAttributeNode("id").nodeValue ;
      }
    }
    return (!tag || tag == t.tagName) &&
    (!id || id == elid ) &&
    (!cls || (
      (t = t.className) && cls.re.test(t)
    ));
  }

  function checkRelation(context, relation, element) {
    switch (relation) {
      case '>':
        return element.parentNode == context;
      case ' ':
        return context.nodeType == 9 || contains(context, element);
      case '+':
        return nextEl(context) == element;
      case '~':
        while (element = prevEl(element)) {
          if (element == context) {
            return true;
          }
        }
        return false;
    }
    return checkRelation(element, relRev[relation], context);
  }

  function match(el1, sel, el2) {
    while (true) {
      var lastOne = sel.pop();
      if (!testEl(el2, lastOne)) return false;

      lastOne = sel[sel.length - 1];
      if (sel.length == 1) {
        return checkRelation(el1, lastOne, el2);
      }

      if (lastOne == '+' || lastOne == '^' || lastOne == '<') {
        el2 = fs[lastOne](el2);
        if (!el2) {
          return false;
        }
        sel.pop();
      }
      else {
        break;
      }
    }

    var arr = find([el1], sel);
    if (!arr.length) return false;
    if (sel.length) {
      lastOne = sel[0];
      for (var i = arr.length; i--; ) {
        if (checkRelation(arr[i], lastOne, el2)) {
          return true;
        }
      }
    }
    else {
      for (var i = arr.length; i--; ) {
        if (arr[i] == el2) {
          return true;
        }
      }
    }
    return false;
  }

  query.match = function(el1, s, el2) {
    var a = parseGroup(s);
    for (var i = 0; i < a.length; ++i) {
      if (match(el1, a[i], el2)) {
        return true;
      }
    }
    return false;
  };
  return query;
} (document);
/*
 * Dom Event Driver
 * author: Darrel
 */
(function( M ){
  var hooks = {
    change:function(){
      return document.all ?  'propertychange': 'input';
    }(),
    get:function( e ){
      if( e in hooks && e !== 'get' ){
        return hooks[ e ];
      }else{
        return e;
      }
    }
  }
  M.ElementEvent = function(dom){
    this.dom = this.isDom(dom)?dom:dom.dom;
    this.EvtHash = {} ;
    if(!this.isDom(this.dom)){
      throw "Dom Error";
    }
  }
  M.ElementEvent = M.extend( M.Object , {

    constructor:M.ElementEvent,

    isDom:function(dom){
      if( ( !dom || dom.nodeType != 1 ) &&  dom !== window ){
        return false;
      }
      return true;
    },

    on:function(e,fun){
      var me = this;
      me.EvtHash[e] = function( e ){ return fun.call(me ,e );} ;
      if( document.all ){
        this.dom.attachEvent( "on" + e , me.EvtHash[e] );
      }else{
        this.dom.addEventListener(e, me.EvtHash[ e ],false);
      }
      return this;
    },

    un:function(e,fun){
      if( fun === undefined ){
        fun = this.EvtHash[ e ];
      }
      if( document.all ){
        this.dom.detachEvent( "on" + e,fun );
      }else{
        this.dom.removeEventListener( e , fun , false );
      }
      return this;
    },

    fire:function(e){
      e = hooks.get( e );
      if( document.createEventObject){
        var evt = document.createEventObject();
        this.dom.fireEvent( 'on' + e , evt );
      }else{
        var evt = document.createEvent("HTMLEvents");
        evt.initEvent(  e ,true,true);
        this.dom.dispatchEvent( evt );
      }
      return this;
    },

    change:function(fun){
      var me = this;
      this.on(hooks.get('change') ,function(){
        fun.call(me);
      });
      return this;    
    },

    hover:function(funIn,funOut){
      this.on('mouseover',funIn);
      if(funOut){
        this.on('mouseout',funOut);
      }
      return this;
    },

    click:function(fun){
      return this.on('click',fun);
    },

    tap:function( fun ){
      var me = this;
      if( window.Touch ){
        me.on("touchstart",function funstart( evt ){
          var touch = false ;
          function funmove(){
            touch = true ;
          }
          function funend( e ){
            if( !touch ){
              fun.call( me.dom , evt )
            }
            me.un( "touchmove" , funmove );
            me.un( "touchend" , funend );
          }
          me.on("touchmove" , funmove );
          me.on("touchend" , funend );
        });
      }else{
        me.click( fun );
      }
    },

    touch:function( fun ){
      var me = this ;
      me.on("touchstart" , function(  ){
        var org , point , touch ;
	function funmove( eventObj ){
	    var evt = eventObj.targetTouches[0];
	    if( !org && !!evt ){
	       org = { x: evt.pageX , y:evt.pageY }
	    }
	    eventObj.move = { x: evt.pageX - org.x , y: evt.pageY - org.y }
	    eventObj.touchend = false ;
	    eventObj.touchX = evt.pageX ;
	    eventObj.touchY = evt.pageY ;
	    eventObj.touchend = false ;
	    point = eventObj ;
	    touch = true ;
	    fun.call( me , eventObj );
	}
	function funend( en ){
	  if( touch ){
	    point.touchend = true ;
	    fun.call( me , point ); 
	  }
	  me.un( "touchmove" , funmove );
	  me.un( "touchend" , funend );
	}
        me.on("touchmove" , funmove );
	me.on("touchend" , funend );
      });
    },
    ready:function(cb){
      var o = this.dom;
      if(o.readyState){
        o.onreadystatechange = function(){
          if( o.readyState == 'loaded' || 
              o.readyState == 'complete'){
            cb.call(this.dom);
            o.onreadystatechange = null;
          }
        }
      }else{
        o.onload = function(){
          cb.call(this.dom);
        }
      }
    }  
  });

//Dom Content Ready Support
  var readyList ;
  M.domReady = false ;
  var DOMContentLoaded = function(){
    if( M.domReady ){
      return false;
    }else{
      M.domReady = true ;
      for(var i=0,fun;fun=readyList[i++];){
        fun.call( M )
      }
    }
  }   
  M.ready = function( fun ){
    M.domReady = window.clientReady || M.domReady ;
    if( document.readyState == 'complete' ){
      fun.call( M );
    }else if(fun instanceof Function){
      readyList = readyList || [] ;
      readyList.push( fun );
      DOC = document ;
      if( M.domReady ){
        DOMContentLoaded();
      }else{
        if( !!DOC.attachEvent ){
          DOC.attachEvent( "onreadystatechange", DOMContentLoaded );
          window.attachEvent("load", DOMContentLoaded );
        }else if( DOC.addEventListener){
          DOC.addEventListener( "DOMContentLoaded", DOMContentLoaded, false );
          window.addEventListener("load", DOMContentLoaded  , false );
        }
      }
    }
  }
  M.ready(function(){
    // do nothing
  });
}( M ));
/*
* M.Element 
* 元素类，用于基本Dom元素的封装
* author Darrel.Hsu xdarui@xiaomi.com 
* 2012-3-17
*/
(function( M ){
  var EventHashManager = {} ,  //全局中保存evtManager的hash，确保同一个dom对应的Element能正确操作事件相关
      DomEventManager = {} ,
      KEY = 1 ; //防止同时产生多个mjs标识的时候重复
  function initEvtMgr( element ){
    element.evtManager = element.evtManager || function(){
      var mhid = element.attr("mjs");
      if( null == mhid || mhid.length < 1 ){
        mhid = new Date().getTime() + "" + KEY++  
        element.attr("mjs" , mhid );
      }
      if( mhid in DomEventManager ){
        return DomEventManager[ mhid ];
      }else{
        return DomEventManager[ mhid ] = new M.ElementEvent( element.dom  ); 
      }
    }();
  }
  function fireEvent( element , evt ){
    initEvtMgr( element );
    element.evtManager.fire( evt );
  }
  function eventHelper( me , evtname ){
    return function( evt ){
       me.fireEvent( evtname , evt );
    };
  }
  /*
   * M扩展
   */
  M.newElement = function( tag , props ){
    return new M.Element( tag , props );
  }
  var ElementAttrsHooks = {
    'class':function( val ){
      this.dom.className = val ;
    },
    html:function( val ){
      this.html( val ) ;
    },
    style:function( val ){
      this.dom.style.cssText = val ;
    },
    'for':function( val ){
      this.dom.htmlFor = val ;
    },
    mjs:function(){},
    events:function( evts ){ 
      for( var p in evts ){
        this.addListener( p ,evts[p] )
      }
    }
  }
  /* M.Element可以通过构造产生一个元素，如：
   * new M.Element( "div" , {
   *   html:'createed by new M.Element'
   *   events:{
   *     click:function(){ alert( this.html() ) }
   *   }
  */
  M.Element = function( el , props ){
    if( typeof el === 'string' ){
      this.dom = document.createElement( el );
    }else{
      this.dom = el instanceof M.Element ? el.dom : el  ;
    }
    if( !!props ){ this.attrs( props ) }
    var mhid = this.attr("mjs");
    if( null == mhid || mhid.length < 1 ){
      mhid = new Date().getTime() + "" + KEY++  
      this.attr("mjs" , mhid );
    }
    if( !( mhid in EventHashManager ) ){
      EventHashManager[ mhid ] = { delegate:{} } ;
    }
    this.domEventHash = EventHashManager[ mhid ];
  }
  M.Element = M.extend( M.Object , {

    //构造要传回
    constructor:M.Element,

    //判断当前元素是否为一个节点元素
    isDom:function( dom ){
      dom = dom || this.dom;
      if( ( !dom || dom.nodeType != 1 ) && dom !== window ){ 
        return false;
      }   
      return true;
    },
    /*
    * fireEvent实际上有一个事件代码加缓存器。
    * 当开发者调用addListener时，会先检查容器中
    * 是否已经对dom进行注册相关的事件，以click为例：
    * addListener会先检查有没有dom元素有没有被注册click事件，
    * 如果已经注册则直接在事件响应动作列表里追加响应回调，而非重复注册
    * 当click事件被触发时，El主动调用fireEvent并把注册的回调依次拿出来
    * 并执行这些回调。
    * 
    */
    fireEvent:function( evtname , evt  ){
      initEvtMgr( this );
      var me = this; 
      var evtList = me.domEventHash[ evtname ] ;
      !!me.evtManager && evtList.each(function( index , fun ){
        var result = fun.call( me , evt );
        if( result === false){
          if( !!evt.preventDefault ){
            evt.preventDefault();
          }else{
            evt.returnValue = false ;
          }
        }
      });
    },
    click:function( fun ){
      this.addListener("click", fun );
      return this;
    },
    /*
    * tap方法只适用于支持触摸的设备上（有window.Touch）
    * tap方法会监听ontouchstart事件，如果这个事件之后没有产生滑动
    * 则认为触发了tab事件，这里我们不能通过return false把默认动作
    * 去掉，如果去掉了则很可能造成列表类型的滑动失效，从而导致不能
    * 查看更多项目
    */
    tap:function( fun ){
      this.addListener("tap", fun );
      return this;
    },
    change:function( fun ){
      this.addListener("change", fun );
      return this;
    },
    touch:function( fun ){
      this.addListener("touch", fun );
      return this;
    },
    undelegate :function( sel , evt , fn ){
      var me = this ,
          DelegateEventManager = this.domEventHash.delegate ;
      if( evt === undefined ){
        for( var act in DelegateEventManager ){
          this.removeListener( act , me._fireDD );
          delete DelegateEventManager[ evt ];
        }
      }else if( sel === undefined && evt in DelegateEventManager ){
        delete DelegateEventManager[ evt ][ sel ];
      }else if( evt in DelegateEventManager  ){
        var arr = DelegateEventManager[ evt ][ sel ];
        var index = arr.indexOf( fn );
        arr.splice( index , 1 );
        if( arr.length == 0 ){
          delete DelegateEventManager[evt][sel];
        }
        if( M.isEmptyObject( DelegateEventManager[evt]) ){
          delete DelegateEventManager[evt] ;
          this.removeListener( evt , this._fireDD );
        }
      }
	  return this;
    },
    delegate:function( sel , evt  , fn ){
      var me = this ,
          DelegateEventManager = this.domEventHash.delegate ;
      if( ! ( evt in DelegateEventManager ) ){
        me.addListener( evt , me._fireDD );
        DelegateEventManager[ evt ] = { };
      }
      DelegateEventManager[evt][ sel ] = DelegateEventManager[ evt ][ sel ] || [];
      DelegateEventManager[evt][ sel ].push( fn );
      return me ;
    },
    _fireDD:function( e ){
      var evtname = e.type ,
          me = this ,
          DelegateEventManager = this.domEventHash.delegate ;
      if( evtname in DelegateEventManager ){
        var delegate = DelegateEventManager[ evtname ];
        for( var sel in delegate ){
          var node = e.target || e.srcElement ;
          var cancel = false
          do{
            if( MSelector.match( me.dom, sel , node ) ){
              delegate[sel].each(function( index , fun ){
                if( fun.call( new M.Element( node ) , e ) === false ){
                  if (e.preventDefault){
                    e.preventDefault();
                  }else{
                    e.returnValue = false; 
                  }
                  if(e.stopPropagation){
                    e.stopPropagation();
                  }else{
                    e.cancelBubble = true;
                  }
                  cancel = true ;
                }
              });
              break;
            }
          }while( ( node = node.parentNode ) && !cancel  && (  node != me.dom ) );
        }
      }
	  return this;
    },
    addListener:function( evtname ,fun , fun1 ){
      initEvtMgr( this );
      var me = this ,
          evts = me.domEventHash ;
      if( fun === undefined ){
        /*
        * 此处为了实现主动事件触发方法
        * 比如,El调用click方法会被转换成：addListener("clici",fun)
        * 如果未在click方法中加入回调方法，则意味着主动触发事件
        * 因为不是所有事件都一定通过el绑定上，所以这里会调用evtManager
        * 主动触发dom的click方法
        *
        */
        me.evtManager.fire( evtname );
      }else if( !( evtname in evts ) ){
        var hooks = {
          change:function( fun  ){
            me.evtManager.change( function( e ){  
              me.fireEvent( "change" ,e );
            });
          },
          tap:function( fun ){
            me.evtManager.tap( function( e ){  
             me.fireEvent( "tap" ,e );
            } );
          },
         touch:function( fun ){
            me.evtManager.touch( function( e ){
             me.fireEvent( "touch" ,e );
           });
         }
        }

        if( evtname in hooks  ){
          var args = M.Util.toArray( arguments );
          args.shift();
          hooks[evtname].apply( me , args )
        }else if( evtname == 'hover'){
          me.evtManager.hover(function( e ){
            !!fun && fun.call( me , e );
          },function( e ){
            !!fun1 && fun1.call( me , e );
          });
        }else{
          me.evtManager.on( evtname , eventHelper( me , evtname ) ) ;
        }
        hook = null ;
        evts[ evtname ] = [ fun ] ;
      }else{
        evts[ evtname ].push( fun );  
      }
      return me;
    }, 

    removeListener:function( evtname,fun ){
      initEvtMgr( this );
      var me = this ,
          evts = me.domEventHash ;
      var evtIn = !!( evtname in evts ) ;
      if( !!me.evtManager ){ 
        if( fun === undefined ){
          delete evts[ evtname ];
          evtIn = false ;
        }
        if(  ( evtIn  && evts[evtname].length <= 1 ) || 
           !evtIn
          ){
          if( evtIn && evts[evtname].length == 1 ){
            evts[ evtname ].remove( fun );
            delete evts[ evtname ];
            evtIn = false ;
          }
          if( !evtIn ){
            me.evtManager.un( evtname );
          }
        }else{
          evts[ evtname ].remove( fun );
        }
      }
      return me;
    },
    attrs:function( props ){
      for( var attr in props ){
        if( attr in ElementAttrsHooks ){
          ElementAttrsHooks[ attr ].call( this ,  props[attr] );
      }else{
          this.dom[ attr ] = props[ attr ];
        }
      }
    },
    get:function( key ){
      var value = this.dom.getAttribute( key );
      if( typeof value == "object" ){
        //IE6 IE7的BUG
        //当form元素的子元素中含有id与form属性同名元素时，getAttribute为该元素。
        value = this.dom.getAttributeNode( key ) ;
        //有可能没有这个属性节点
        if( null != value ){
          value = value.nodeValue ;
        }
      }
      return  this.dom.getAttribute( key );
    },
    set:function( attrName , val  ){
      this.dom.setAttribute( attrName , val ) ;
      return this;
    },
    attr:function( attrName , val ){
      if( val === undefined ){
        return this.dom[attrName] || this.get( attrName ) ;
      }else{
        return this.set( attrName , val );
      }
    },

    val:function( val ){
      if( val === undefined ){
        return this.dom.value ;
      }else{
        this.dom.value = val ;
        return this ;
      }
    },
    removeAttr:function( attr ){
      this.dom.removeAttribute( attr );
      return this;
    },

    hasClass:function( cls ){
      return ( " " + this.dom.className + " " ).indexOf( " " + cls + " " ) > -1 ;
    },

    addClass:function( cls ){
      if( !this.hasClass(cls) ){
        this.dom.className = ( this.dom.className + " " + cls ).trim() ; 
      }
      return this;
    },

    toggleClass:function( cls ){
      if( this.hasClass( cls ) ){
        this.removeClass( cls );
      }else{
        this.addClass( cls );
      }
      return this;
    },

    removeClass:function( cls ){
      var me = this , 
          className = me.dom.className ;
          className = " " + className + " ";
      var clss = cls.split(/\s+/);
      for( var i=0,c; c = clss[i++] ; ){
        if( c.length > 0 ){
          className = className.replace( " "+ c + " " , " " );
        }
      }
      className = className.trim().split(/\s+/);
      me.dom.className = className.join(" ");
      return me;
    },
    
    hide:function(){
      this.dom.style.display = 'none';
      return this;
    },

    show:function(){
      this.dom.style.display = '';
      return this;
    },

    css:function( attr , value ){
      if(typeof attr == 'object' ){
        for( var p in attr ){
          this.css( p , attr[p] );
         }
        return this;
      }else{
        if( value ){
          this.dom.style[ attr ] = value 
          return this;
        }else{
          return this.dom.style[ attr ];
        }
      }
    },

    parent:function(){
      var node = this.dom.parentNode ;
      if( this.isDom( node ) ){ 
        return new M.Element( node ) 
      }else{
        if( node.parentNode && 
            ( node = node.parentNode )  && 
            this.isDom( node )
          ){
          return new M.Element( node );
        }else{
          return null;
        } 
      }; 
    },
   
    next:function( tag ){
      if (tag) tag = tag.toUpperCase();
      var node = this.dom;
      while (node = node.nextSibling) {
        if (node.nodeType == 1 && (!tag || tag == node.tagName)) {
          return new M.Element( node );
        }
      }
    },    
    //只接受字符串或Element
    insertBeforeTarget:function( el ){
      if( ! ( el instanceof M.Element ) ){
        el = M.getEl( el );
      }
      var parentDom = el.parent().dom ;
      parentDom.insertBefore( this.dom , el.dom );
    },
    
    insertAfterTarget:function( el ){
      if( !( el instanceof M.Element) ){
        el = M.getEl( el );
      }
      var node ,
          parentDom = el.dom.parentNode ;
      if( node = el.dom.nextSibling ){
        parentDom.insertBefore( this.dom , el.dom );
      }else{
        parentDom.appendChild( this.dom );
      }
    },
    appendTo:function( el ){
      if( !( el instanceof M.Element ) ){
        if( typeof el === 'string' ){
          M.getEl( el ).append( this )
        }else{
          el.appendChild( this.dom )
        }
      }else{
        el.append( this ) ;
      }
      return this ;
    },
    append:function( el ){
      if( 
           el instanceof M.ElementsCollection ||
           el instanceof Array 
      ){
        for(var i = 0 ; i< el.length ; i++ ){
          this.append( el.getAt( i ) );
        }
      }else if( el instanceof M.Element ){
        this.append( el.dom );
      }else if(typeof el === 'string'){
        var org = this.dom.innerHTML ;
        if( org.trim().length < 1 ){
          this.html( el )
        }else{
          var fag = document.createElement( this.dom.tagName );
          fag.innerHTML = el ;
          var node ; 
          while( node = fag.firstChild ){
           this.append( node );
          };
        }
      }else{
        this.dom.appendChild( el );
      }
    },
    
    contains:function( el ){
      if( el instanceof M.Element ){
        el = el.dom
      }
      /*
      * 0  一致
      * 1  节点在不同的文档
      * 2  B在A之前
      * 4  A在B之前
      * 8  B包含A
      * 16 A包含B
      * 32 浏览器私有
      * 如果A包含B那么A一定是在B之前，所以比较的结果应该是16+4
      */
      return el.contains ? this.dom != el && this.dom.contains( el ) 
                         : this.dom.compareDocumentPosition( el ) == 20 ;
    },

    parents:function( sel ){
      var a = MSelector('<<' + sel, this.dom);
      if (a.length) {
        return new M.Element( a[0] );
      }
    },

    remove:function(){
      var me = this ;
      for( var evt in  me.evts ){
        me.removeListener( evt );
      }
      var mid = this.get("mjs");
      delete EventHashManager[ mid ];
      delete DomEventManager[ mid ];
      this.parent().removeChild( this ) ;
      this.dom = null;
    },

    removeChild:function( el ){
      var dom = 'dom' in el ? el.dom : el ;
      this.dom.removeChild( dom );
    },

    text:function( txt ){
      var attr = 'innerText' in this.dom ? 'innerText' : 'textContent';
      if( undefined === txt ){
        return this.dom[ attr ]  ;
      }else{
        this.dom[ attr ] = txt ;
        return this;
      }
    },

    html:function( html ){
     // if( 'innerHTML' in this.dom ){
        if( html === undefined ){
          return this.dom.innerHTML ;
        }else{
          this.dom.innerHTML = html ;
          return this;
        }
      }
    // }

  });

  M.ElementsCollection = function( el ){
    if( !( el instanceof Array) ){
      el = [ el ];
    }
    this.el = el;
    this.length = el.length ;
  };

  M.ElementsCollection = M.extend( M.Object , {

    constructor:M.ElementsCollection,

    add:function( el ){
      this.el.join( el.dom || el )
      this.length = this.el.length ;
    },

    getAt:function( index , ctx ){
      ctx = ctx || document ;
      if( typeof index == 'number'){
        return new M.Element( this.el[index] );
      }else{
        var sp = index.charAt(0) , re = [] ;
        var id = index.replace(/^[\.#]/,"")
        for( var i = 0 ; i< this.el.length ;i++ ){
          if( MSelector.match( ctx , index , this.el[i]) ){
            re.push( new M.Element( this.el[i] ) ); 
          }
        }
        return new M.ElementsCollection( re );
      }
    },

    doApply:function(){
      var args = Array.prototype.slice.call( arguments )
      var method = args.shift()
      for( var i = 0 , E ; E = this.el[i++]; ){
        var m = new M.Element( E ) ,
        F = m[method] ;
        m[method].apply( m  , args ) ;
      }
      return this;
    },
    click:function( fun ){
      this.doApply("click", fun );
      return this
    },
    tap:function( fun ){
      this.doApply("tap",fun );
      return this;
    },
    hide:function(){
      this.doApply("hide");
      return this;
    },
    show:function(){
      this.doApply("show");
      return this;
    }
    
  });

  M.get = function( id , ctx ){
    var result = MSelector( id , ctx );
    return result.length == 1 ? result[0] : result ;
  };
  M.getEl = function( id , parent ){
    var el =  M.get( id , parent ) ;
    if( el.length == 0  ){ return null } ;
    if( el instanceof Array ){
      el = el[0];
    }
    return new M.Element( el );
  }

  M.getEls = function( id , parent ){
    return new M.ElementsCollection( M.get( id , parent ) );
  }
  
  M.compat = function(){
    return window.document.compatMode === "CSS1Compat"
  }

  M.isWindow = function( el ){
    return Object.prototype.toString.call( el) == '[object global]'
  }
  
  /*['Width','Height'].each(function( i , per ){
    var type = per.toLowerCase();
    M.Element.prototype['inner' + per ] = function(){
      return 
    }
  });*/
}( M ));

(function(){

M.Net = M.Net || {};
M.net = M.Net ;
var netMaskObject = new M.Object();
M.Net.ajax = function(){
  var func = {} ;
  var ajaxHis = {} ;
  function setHeader(o){
    var _setHeaders=function(headers){
      for(var h in headers){
          if(/;$/.test(headers[h])){
          o.Ajax(h, headers[h] +'charset=' + ajax.coding);
        }else{
          o.Ajax.setRequestHeader(h, headers[h] + ';charset=' + ajax.coding);
        }
        
      }
    }
    _setHeaders(ajax.defaultHeaders)
    if(ajax.headers){
      _setHeaders(ajax.headers)
    }
  }
  function getAjaxObject(){
    var Ajax
    try {
      if (window.XMLHttpRequest) {
                     Ajax =  new XMLHttpRequest();
                } else {
                    if (window.ActiveXObject) {
                        try {
                             Ajax = new ActiveXObject("Msxml2.XMLHTTP");
                        } catch (e) {
                            try {
                                 Ajax = new ActiveXObject("Microsoft.XMLHTTP");
                            } catch (e) {
                               throw 'Create Ajax Error .' + e
                            }
                        }
                    }
                }
            }catch(e){
        throw 'Create Ajax Error .' + e
    }
    return {
      Ajax:Ajax,
      transId:'ajax-' + ( ++ajax.transId )
    }
  }
  function iniHeader(label,value){
    ajax.headers = ajax.headers||{}
    ajax.headers[label] = value
  }

  function doRequest( config  ){
    var o = getAjaxObject() || null ,
      method = config.method ,
	   url = config.url ,
	   dataType = config.dataType ;
    netMaskObject.fire("ajaxStart", o.transId , config);
    func[o.transId] = { 'success': config.success , 'failure' : config.failure };
    if (o) {
      if( method.toUpperCase() == 'GET' && !M.isEmptyObject( config.data ) ){
        var pms = {}  ;
        if( url.indexOf("?") > -1 ){
          pms = M.params( url );
        }
        M.merge( pms , config.data );
        url = url.split("?")[0] + "?" + M.decodeParams( pms );
      }
      o.Ajax.open(method.toUpperCase(), url, config.asynchronous)
      setHeader(o)
      if( config.asynchronous ){
        handlerAjaxReady(o , config )
      }
      var transid = o.transId;
      ajaxHis[ transid ] = setTimeout(function(){
        if( transid in func ){
	  handlerRequestTimeout( o , config , func[ o.transId ]['failure']  ); 
	}
	delete func[ transid ];
      } , config.timeout || o.timeout  )
      o.Ajax.send( M.decodeParams( config.data ) || null)
      if( ! config.asynchronous ){
        handlerRequestComplete( o , config );
      }
    }
  }
  function handlerRequestTimeout( o , config , cb ){
    var request = o.Ajax ;
    request.abort();
    if( 'onTimeout' in config ){
      config.onTimeout.call( config, request );
      netMaskObject.fire("ajaxTimeout" , o.transId , request );
    }else{
      cb.call( config ,request )
    }
  }
  function handlerRequestComplete( o  , config  ){
    var request = o.Ajax ;
    window.clearTimeout( ajaxHis[ o.transId ] )
    delete ajaxHis[ o.transId ]
    if ( request.readyState == 4 ) { 
      netMaskObject.fire("ajaxComplete" , o.transId , request );
      if ( request.status == 200 ) {
        if( config.dataType === 'json' ){
          var ct = request.getResponseHeader("Content-Type");
          ct = ct.split(";")[0];
          if( ct.trim() === 'application/json' ){
            try{
              func[ o.transId ]['success'].call( config ,request, M.encode( request.responseText ) )
            }catch( e ){
	      netMaskObject.fire("ajaxError" , e , request );
              func[ o.transId ]['failure'].call( config ,request ,e )
            }
          }else{
	    netMaskObject.fire("ajaxError" , 'header error' , request );
            func[ o.transId ]['failure'].call( config ,request )
          }
        }else{
          func[ o.transId ]['success'].call( config ,request )
	}
      }else{
        netMaskObject.fire("ajaxError" , 'header error' , request );
        func[ o.transId ]['failure'].call( config ,request )
      }
      delete func[ o.transId ];
    }
  };
  function handlerAjaxReady( o , config ){
    var request = o.Ajax
     request.onreadystatechange = function(){
       handlerRequestComplete( o , config )
     }
  }
  var ajax = {
    /*
     *#cfg {String} 
     */
    dataType:'',
    /**
           * @cfg {String} method GET 或者 POST,默认GET.
           */
    method:'POST',
    /**
     * @cfg {String} url 请求URL
     */
    url:'',
    /**
     * @cfg {Boolean} asynchronous 是否为异步，默认为true
     */
    asynchronous:true,
    /**
     * @cfg {Number} timeout 设置超时，默认为5000ms
     */
    timeout:5000,
    success:function(){},
    failure:function(){},
    /**
     * 默认请求头
     * @cfg {Object} defaultHeaders
     */
    defaultHeaders:{ 
      'Content-Type' :'application/x-www-form-urlencoded' /*,
      /*'Accept-Charset':this.coding   /*无效？*/
      },
    ajaxDone:function( fun ){
      netMaskObject.on("ajaxComplete" , fun )
    },
    ajaxStart:function( fun ){
      netMaskObject.on("ajaxStart" , fun )
    },
    ajaxError:function( fun ){
      netMaskObject.on("ajaxError" , fun )
    },
    ajaxTimeout:function( fun ){
       netMaskObject.on("ajaxTimeout" , fun )
    },
    /**
     * @cfg {Boolean} cache 是否缓存,默认为false
     */
    headers:{},
    cache:true,
    /**
     * 编码类型
     * @param {String} coding
     */
    coding:'UTF-8',
    /**
     * private
     */
    transId:0,
    /**
     * 启动一个ajax请求
     */
    request:function(o){
      var me = this
      M.applyIfNot( o , me , ["request","defaultHeaders"])
      if(!o.data){
        if(o.xml || o.params){
          var hds = me.headers ||{}
          if(!hds || !hds['ContentType']){
            iniHeader('ContentType',o.xml ?  'text/xml' :'application/json')
            o.data = o.xml || o.params
          }
        }
      }
      return doRequest( o  )
    }
  };
  return ajax;
}();
  
/*
  M.net.ajax.request({
      url:'',
      method:'',
      data:{ 
          inAjax:1
        },
      dataType:'json'
      succes:function( xhr , data ){
        console.log( data )
      },
      failure:function(){
      }
    });
  var ajaxTimer = {} ;
  M.Net.ajax.ajaxStart(function( id ){
    var top = document.body.scrollTop + 10 ;
    var mask = new M.Element('div',{
      id:'ajax-' + id,
      html:'',
      style:'-webkit-border-radius:30px;padding:5px;width:120px;position:absolute;z-index:999;right:10px;top:'+ top +'px;height:30px;line-height:30px;background:#F00;color:#FFF;text-align:center;opacity: 0.4;'
    }).appendTo("body");
    var showRequest = function(){
      if( id in ajaxTimer && !!mask.dom ){
         var html = mask.html();
	 if( html.length >= 10 ){
	   html = "-";
	 }else{
	   html += "-";
	 }
	 mask.html( html );
	 ajaxTimer[id] = setTimeout( showRequest , 200 );
      }
    }
    ajaxTimer[id] = setTimeout( showRequest , 500 );
  });
  M.Net.ajax.ajaxDone(function( id ){
    window.clearTimeout( ajaxTimer[id] );
    M.getEl("#ajax-" + id).remove();
  });*/
}());
;(function(){
  var _removeScriptTag = function(scr) {
  if (scr.clearAttributes) {
    scr.clearAttributes();
  } else {
    for (var attr in scr) {
      if (scr.hasOwnProperty(attr)) {
        delete scr[attr];
      }
    }
  }
  if (scr && scr.parentNode) {
    scr.parentNode.removeChild(scr);
  }
  scr = null;
};
M.net.jsonp = function(url, callback) {
  var scr = document.createElement("SCRIPT"),
  scriptLoaded = 0,
  attr;

  // IE和opera支持onreadystatechange
  // safari、chrome、opera支持onload
  scr.onload = scr.onreadystatechange = function() {
    // 避免opera下的多次调用
    if (scriptLoaded) {
      return;
    }

    var readyState = scr.readyState;
    if ('undefined' == typeof readyState || readyState == "loaded" || readyState == "complete") {
      scriptLoaded = 1;
      try { ('function' == typeof callback) && callback();
      } finally {
        _removeScriptTag(scr);
      }
    }
  };

  scr.setAttribute('type', 'text/javascript');
  scr.setAttribute('src', url);
  M.get("head")[0].appendChild(scr);
};
})();
